/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.collectd.api.ValueList;
import org.collectd.mx.MBeanAttribute;
import org.collectd.mx.MBeanQuery;
import org.collectd.mx.MBeanSender;
import org.collectd.protocol.Network;

public class MBeanCollector
implements Runnable {
    private static final Logger _log = Logger.getLogger(MBeanCollector.class.getName());
    private static boolean _useDescriptors = "true".equals(Network.getProperty("mx.descriptors", "true"));
    private static Method _getDescriptor;
    private static final String _metricTypeField;
    private MBeanSender _sender;
    private long _interval = 60L;
    private Map<String, MBeanQuery> _queries = new HashMap<String, MBeanQuery>();

    public MBeanSender getSender() {
        return this._sender;
    }

    public void setSender(MBeanSender sender) {
        this._sender = sender;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    public Map<String, MBeanQuery> getQueries() {
        return this._queries;
    }

    public MBeanQuery addMBean(String objectName) {
        MBeanQuery query = this._queries.get(objectName);
        if (query == null) {
            try {
                query = new MBeanQuery(new ObjectName(objectName));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(objectName);
            }
            this._queries.put(objectName, query);
        }
        return query;
    }

    public MBeanAttribute addMBeanAttribute(String objectName, String attributeName) {
        MBeanQuery query = this.addMBean(objectName);
        if (attributeName != null) {
            MBeanAttribute attr = new MBeanAttribute(attributeName);
            query.addAttribute(attr);
            return attr;
        }
        return null;
    }

    private boolean isNumber(Object obj) {
        if (obj == null) {
            return false;
        }
        return Number.class.isAssignableFrom(obj.getClass());
    }

    private String getBeanName(ObjectName query, ObjectName name) {
        Map<String, String> skip = query == null ? new HashMap() : query.getKeyPropertyList();
        StringBuffer iname = new StringBuffer();
        for (String key : name.getKeyPropertyList().keySet()) {
            if (skip.get(key) != null) continue;
            if (iname.length() > 0) {
                iname.append(' ');
            }
            iname.append(name.getKeyProperty(key));
        }
        return iname.toString();
    }

    private void dispatch(MBeanQuery query, String plugin, String typeInstance, ObjectName name, MBeanAttribute attr, Number val) {
        String instName;
        val = attr.getDataType() == 1 ? (Number)new Double(val.doubleValue()) : (Number)new Long(val.longValue());
        String pluginInstance = query.getPluginInstance();
        if (pluginInstance == null) {
            pluginInstance = this._sender.getInstanceName();
        }
        String beanName = query.getAlias();
        ValueList vl = new ValueList();
        vl.setInterval(this.getInterval());
        vl.setPlugin(plugin);
        if (beanName == null) {
            beanName = this.getBeanName(null, name);
        } else if (query.getName().isPattern() && (instName = this.getBeanName(query.getName(), name)) != null) {
            beanName = beanName + " " + instName;
        }
        vl.setPluginInstance(pluginInstance + "-" + beanName);
        vl.setType(attr.getTypeName());
        vl.setTypeInstance(typeInstance);
        vl.addValue(val);
        this._sender.dispatch(vl);
    }

    public void collect(MBeanQuery query, ObjectName name) throws Exception {
        String plugin;
        MBeanServerConnection conn = this._sender.getMBeanServerConnection();
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("[jcollectd] mbeans available:" + conn.getMBeanCount());
        }
        if ((plugin = query.getPlugin()) == null) {
            plugin = name.getDomain();
        }
        HashMap<String, MBeanAttributeInfo> attrInfo = null;
        if (_useDescriptors) {
            MBeanInfo info = conn.getMBeanInfo(name);
            attrInfo = new HashMap<String, MBeanAttributeInfo>();
            for (MBeanAttributeInfo ainfo : info.getAttributes()) {
                attrInfo.put(ainfo.getName(), ainfo);
            }
        }
        for (MBeanAttribute attr : query.getAttributes()) {
            Object obj;
            String attrName = attr.getAttributeName();
            try {
                obj = conn.getAttribute(name, attrName);
            }
            catch (Exception e) {
                continue;
            }
            if (_useDescriptors) {
                try {
                    Descriptor descriptor = (Descriptor)_getDescriptor.invoke(attrInfo.get(attrName), (Object[])null);
                    Object type = descriptor.getFieldValue(_metricTypeField);
                    if ("counter".equals(type)) {
                        if (attr.getTypeName().equals("gauge")) {
                            attr.setTypeName("counter");
                        }
                        attr.setDataType(0);
                    }
                }
                catch (Exception descriptor) {
                    // empty catch block
                }
            }
            if (obj instanceof CompositeData) {
                CompositeData data = (CompositeData)obj;
                String key = attr.getCompositeKey();
                if (key == null) {
                    Set<String> keys = data.getCompositeType().keySet();
                    for (String ckey : keys) {
                        obj = data.get(ckey);
                        if (!this.isNumber(obj)) continue;
                        this.dispatch(query, plugin, attrName + "." + ckey, name, attr, (Number)obj);
                    }
                    continue;
                }
                obj = data.get(key);
            }
            if (!this.isNumber(obj)) continue;
            this.dispatch(query, plugin, attr.getName(), name, attr, (Number)obj);
        }
        this._sender.flush();
    }

    private void run(MBeanQuery query, ObjectName name) {
        try {
            if (query.getAttributes().size() == 0) {
                query = this.queryAll(name);
            }
            this.collect(query, name);
        }
        catch (Exception e) {
            _log.log(Level.FINE, "[jcollectd] collect failed:" + name, e);
        }
    }

    private MBeanQuery queryAll(ObjectName name) throws Exception {
        MBeanQuery query = new MBeanQuery(name);
        MBeanInfo info = this._sender.getMBeanServerConnection().getMBeanInfo(name);
        MBeanAttributeInfo[] attrs = info.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            query.addAttribute(new MBeanAttribute(attrs[i].getName()));
        }
        return query;
    }

    @Override
    public void run() {
        for (MBeanQuery query : this._queries.values()) {
            ObjectName name = query.getName();
            if (name.isPattern()) {
                Set<ObjectName> beans;
                try {
                    beans = this._sender.getMBeanServerConnection().queryNames(name, null);
                }
                catch (Exception e) {
                    _log.warning("queryNames(" + name + "): " + e);
                    return;
                }
                for (ObjectName oname : beans) {
                    if (!query.isExcluded(oname.getCanonicalName())) {
                        this.run(query, oname);
                        continue;
                    }
                    if (!_log.isLoggable(Level.FINE)) continue;
                    _log.fine("excluding:" + oname);
                }
                continue;
            }
            this.run(query, name);
        }
    }

    static {
        _metricTypeField = Network.getProperty("mx.metricTypeField", "metricType");
        if (_useDescriptors) {
            try {
                _getDescriptor = MBeanAttributeInfo.class.getMethod("getDescriptor", null);
            }
            catch (Exception e) {
                _useDescriptors = false;
            }
        }
    }
}

