/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.io.File;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.collectd.mx.MBeanAttribute;
import org.collectd.mx.MBeanCollector;
import org.collectd.mx.MBeanQuery;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MBeanConfig {
    private static final Logger _log = Logger.getLogger(MBeanConfig.class.getName());
    private XPath _xpath = XPathFactory.newInstance().newXPath();

    private String getAttribute(Node node, String name) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node item = attrs.getNamedItem(name);
        if (item == null) {
            return null;
        }
        return item.getNodeValue();
    }

    private NodeList eval(String name, Node node) throws XPathExpressionException {
        return (NodeList)this._xpath.evaluate(name, node, XPathConstants.NODESET);
    }

    private NodeList eval(String name, InputSource is) throws XPathExpressionException {
        return (NodeList)this._xpath.evaluate(name, is, XPathConstants.NODESET);
    }

    public MBeanCollector add(String source) throws Exception {
        String name = source + "-jcollectd.xml";
        if (new File(source).exists()) {
            return this.add(new InputSource(source));
        }
        if (new File(name).exists()) {
            return this.add(new InputSource(name));
        }
        String[] rs = new String[]{name, "etc/" + name, "META-INF/" + name};
        for (int i = 0; i < rs.length; ++i) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(rs[i]);
            if (is == null) continue;
            return this.add(is);
        }
        String lastTry = "./etc/" + name;
        if (new File(lastTry).exists()) {
            return this.add(new InputSource(lastTry));
        }
        _log.severe("[jcollectd] unable to read:" + new File(name).getAbsolutePath() + " or:" + new File(source).getAbsolutePath() + " or:" + name + " or: ./etc/" + name + " or: META-INF/" + name + " or: etc/" + name);
        return null;
    }

    public MBeanCollector add(InputStream is) throws Exception {
        return this.add(new InputSource(is));
    }

    public MBeanCollector add(InputSource is) throws Exception {
        MBeanCollector collector = new MBeanCollector();
        String path = "/jcollectd-config/mbeans";
        NodeList plugins = this.eval("/jcollectd-config/mbeans", is);
        int len = plugins.getLength();
        if (len == 0) {
            throw new IllegalArgumentException("Missing /jcollectd-config/mbeans");
        }
        for (int i = 0; i < len; ++i) {
            Node plugin = plugins.item(i);
            String pluginName = this.getAttribute(plugin, "name");
            NodeList mbeans = this.eval("mbean", plugin);
            for (int j = 0; j < mbeans.getLength(); ++j) {
                Node mbean = mbeans.item(j);
                String objectName = this.getAttribute(mbean, "name");
                String objectNameAlias = this.getAttribute(mbean, "alias");
                String excludePattern = this.getAttribute(mbean, "exclude");
                NodeList attrs = this.eval("attribute", mbean);
                MBeanQuery query = collector.addMBean(objectName);
                query.setExcludePattern(excludePattern);
                if (pluginName != null) {
                    query.setPlugin(pluginName);
                }
                if (objectNameAlias != null) {
                    query.setAlias(objectNameAlias);
                }
                for (int k = 0; k < attrs.getLength(); ++k) {
                    Node attr = attrs.item(k);
                    String attrName = this.getAttribute(attr, "name");
                    String type = this.getAttribute(attr, "type");
                    String units = this.getAttribute(attr, "units");
                    String alias = this.getAttribute(attr, "alias");
                    if (type == null) {
                        type = "gauge";
                    }
                    MBeanAttribute mattr = new MBeanAttribute(attrName, type);
                    if (alias != null) {
                        mattr.setName(alias);
                    }
                    if (units != null) {
                        // empty if block
                    }
                    query.addAttribute(mattr);
                }
            }
        }
        return collector;
    }
}

