/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.collectd.mx.MBeanAttribute;

public class MBeanQuery {
    private String _plugin;
    private String _pluginInstance;
    private ObjectName _name;
    private String _alias;
    private String _excludePattern;
    private Pattern _compiledExcludePattern;
    private Set<MBeanAttribute> _attributes = new HashSet<MBeanAttribute>();

    public MBeanQuery(ObjectName name) {
        this._name = name;
    }

    public String getPlugin() {
        return this._plugin;
    }

    public void setPlugin(String plugin) {
        this._plugin = plugin;
    }

    public String getPluginInstance() {
        return this._pluginInstance;
    }

    public void setPluginInstance(String pluginInstance) {
        this._pluginInstance = pluginInstance;
    }

    public ObjectName getName() {
        return this._name;
    }

    public void setName(ObjectName name) {
        this._name = name;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public Set<MBeanAttribute> getAttributes() {
        return this._attributes;
    }

    public void setAttributes(Set<MBeanAttribute> attributes) {
        this._attributes = attributes;
    }

    public void addAttribute(MBeanAttribute attribute) {
        this._attributes.add(attribute);
    }

    public void setExcludePattern(String excludePattern) {
        this._excludePattern = excludePattern;
        if (excludePattern != null) {
            this._compiledExcludePattern = Pattern.compile(excludePattern);
        }
    }

    public boolean isExcluded(String beanName) {
        if (this._excludePattern == null) {
            return false;
        }
        if (this._excludePattern.length() == 0) {
            return false;
        }
        return this._compiledExcludePattern.matcher(beanName).matches();
    }
}

