/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import javax.management.MBeanServerFactory;
import org.collectd.mx.CollectdMBeanRegistry;
import org.collectd.protocol.Dispatcher;
import org.collectd.protocol.UdpReceiver;

public class MBeanReceiver
extends UdpReceiver
implements Runnable {
    private static final String MX = "com.sun.management.jmxremote";
    private static final String DMX = "-Dcom.sun.management.jmxremote";

    public MBeanReceiver() {
        this.setDispatcher(new CollectdMBeanRegistry());
    }

    public MBeanReceiver(Dispatcher dispatcher) {
        super(dispatcher);
    }

    private void setup() throws Exception {
        DatagramSocket socket = this.getSocket();
        if (socket instanceof MulticastSocket) {
            MulticastSocket mcast = (MulticastSocket)socket;
            System.err.println("Multicast interface=" + mcast.getInterface());
        }
        System.err.println(this.getListenAddress() + ":" + this.getPort() + " listening...");
        this.listen();
    }

    @Override
    public void run() {
        try {
            this.setup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int ix = name.indexOf(64);
        if (ix == -1) {
            return null;
        }
        return name.substring(0, ix);
    }

    private static boolean hasMBeanServer() {
        return MBeanServerFactory.findMBeanServer(null).size() != 0;
    }

    private static boolean checkMxAgent(String[] args) {
        if (MBeanReceiver.hasMBeanServer()) {
            return true;
        }
        boolean hasMx = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(DMX)) continue;
            hasMx = true;
            break;
        }
        if (hasMx) {
            return true;
        }
        try {
            System.err.print("Enabling -Dcom.sun.management.jmxremote...");
            System.setProperty(MX, "true");
            String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
            String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            VirtualMachine vm = VirtualMachine.attach(pid);
            String connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            if (connectorAddress == null) {
                String agent = vm.getSystemProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
                vm.loadAgent(agent);
                connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            }
            System.err.println((hasMx = MBeanReceiver.hasMBeanServer()) ? "ok" : "failed");
            return hasMx;
        }
        catch (Throwable t) {
            System.err.println("failed: " + t);
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        if (!MBeanReceiver.checkMxAgent(args)) {
            System.err.println("Try using: java -Dcom.sun.management.jmxremote ...");
            return;
        }
        Thread lt = new Thread(new MBeanReceiver());
        lt.setDaemon(true);
        lt.start();
        boolean launchJconsole = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-jconsole")) {
                System.err.println("Unknown argument: " + arg);
                return;
            }
            launchJconsole = true;
        }
        if (launchJconsole) {
            String pid = MBeanReceiver.getPid();
            String[] argv = new String[]{"jconsole", pid};
            System.err.println("exec(jconsole, " + pid + ")");
            try {
                Process p = Runtime.getRuntime().exec(argv);
                p.waitFor();
                System.err.println("jconsole exited");
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        } else {
            lt.join();
        }
    }
}

