/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.collectd.api.Notification;
import org.collectd.api.ValueList;
import org.collectd.mx.MBeanCollector;
import org.collectd.mx.MBeanConfig;
import org.collectd.protocol.Dispatcher;
import org.collectd.protocol.Network;
import org.collectd.protocol.Sender;
import org.collectd.protocol.UdpSender;

public class MBeanSender
implements Dispatcher {
    private static final Logger _log = Logger.getLogger(MBeanSender.class.getName());
    private static final String UDP = "udp";
    private static final String PSEP = "://";
    private static final String RUNTIME_NAME = "java.lang:type=Runtime";
    private MBeanServerConnection _bs = ManagementFactory.getPlatformMBeanServer();
    private ScheduledExecutorService _scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable task) {
            Thread thread = new Thread(task);
            thread.setName("jcollectd");
            thread.setDaemon(true);
            return thread;
        }
    });
    private Map<String, Sender> _senders = new HashMap<String, Sender>();
    private MBeanConfig _config = new MBeanConfig();
    private String _instanceName;

    public void setMBeanServerConnection(MBeanServerConnection server) {
        this._bs = server;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this._bs;
    }

    private String getRuntimeName() {
        try {
            ObjectName name = new ObjectName(RUNTIME_NAME);
            return (String)this.getMBeanServerConnection().getAttribute(name, "Name");
        }
        catch (Exception e) {
            return ManagementFactory.getRuntimeMXBean().getName();
        }
    }

    public String getInstanceName() {
        if (this._instanceName == null) {
            this._instanceName = Network.getProperty("jcd.instance", this.getRuntimeName());
        }
        return this._instanceName;
    }

    public void setInstanceName(String instanceName) {
        this._instanceName = instanceName;
    }

    public void schedule(MBeanCollector collector) {
        collector.setSender(this);
        this._scheduler.scheduleAtFixedRate(collector, 0L, collector.getInterval(), TimeUnit.SECONDS);
    }

    public void addSender(String protocol, Sender sender) {
        this._senders.put(protocol, sender);
    }

    public void addDestination(String url) {
        int ix = url.indexOf(PSEP);
        if (ix == -1) {
            throw new IllegalArgumentException("Malformed url: " + url);
        }
        String protocol = url.substring(0, ix);
        String server = url.substring(ix + PSEP.length());
        Sender sender = this._senders.get(protocol);
        if (sender == null) {
            if (protocol.equals(UDP)) {
                sender = new UdpSender();
                this.addSender(UDP, sender);
            } else {
                throw new IllegalArgumentException("Unsupported protocol: " + protocol);
            }
        }
        sender.addServer(server);
    }

    public MBeanCollector scheduleTemplate(String name, Long sendInterval) {
        MBeanCollector collector = null;
        try {
            collector = this._config.add(name);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "add template " + name + ": " + e.getMessage(), e);
        }
        if (collector != null) {
            if (sendInterval != null) {
                collector.setInterval(sendInterval);
            }
            this.schedule(collector);
        }
        return collector;
    }

    public MBeanCollector scheduleMBean(String name, Long sendInterval) {
        try {
            new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            _log.log(Level.WARNING, "add MBean " + name + ": " + e.getMessage(), e);
            return null;
        }
        MBeanCollector collector = new MBeanCollector();
        if (sendInterval != null) {
            collector.setInterval(sendInterval);
        }
        collector.addMBean(name);
        this.schedule(collector);
        return collector;
    }

    public MBeanCollector schedule(String name) {
        MBeanCollector collector = this.scheduleTemplate(name, null);
        if (collector == null) {
            collector = this.scheduleMBean(name, null);
        }
        return collector;
    }

    @Override
    public void dispatch(Notification notification) {
        for (Sender sender : this._senders.values()) {
            sender.dispatch(notification);
        }
    }

    @Override
    public void dispatch(ValueList values) {
        for (Sender sender : this._senders.values()) {
            sender.dispatch(values);
        }
    }

    public void flush() throws IOException {
        for (Sender sender : this._senders.values()) {
            sender.flush();
        }
    }

    public void shutdown() {
        this._scheduler.shutdownNow();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MBeanSender.this.shutdown();
            }
        });
    }

    public void configure() {
        String beans;
        String tmpl;
        String dest = Network.getProperty("jcd.dest");
        if (dest != null) {
            this.addDestination(dest);
        }
        String intervalProp = Network.getProperty("jcd.sendinterval", "");
        Long sendInterval = null;
        if (!intervalProp.isEmpty()) {
            sendInterval = Long.parseLong(intervalProp);
        }
        if ((tmpl = Network.getProperty("jcd.tmpl")) != null) {
            for (String t : tmpl.split(",")) {
                this.scheduleTemplate(t, sendInterval);
            }
        }
        if ((beans = Network.getProperty("jcd.beans")) != null) {
            for (String b : beans.split("#")) {
                this.scheduleMBean(b, sendInterval);
            }
        }
    }

    protected void init(String args) {
        if (args == null) {
            return;
        }
        String[] argv = args.split("#");
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.indexOf(PSEP) != -1) {
                this.addDestination(arg);
                continue;
            }
            this.schedule(arg);
        }
    }

    protected void premainConfigure(String args) {
        _log.fine("[jcollectd] MBeanServerConnection:" + this._bs);
        this.addShutdownHook();
        this.configure();
        this.init(args);
        if (this._senders.size() == 0) {
            String dest = "udp://239.192.74.66";
            _log.fine("[jcollectd] Adding default destination: " + dest);
            this.addDestination(dest);
        }
    }

    public static void premain(String args, Instrumentation instr) {
        MBeanSender sender = new MBeanSender();
        sender.premainConfigure(args);
    }
}

