/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.logging.Logger;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.collectd.mx.MBeanSender;
import org.collectd.protocol.Network;

public class RemoteMBeanSender
extends MBeanSender {
    private static final Logger _log = Logger.getLogger(RemoteMBeanSender.class.getName());

    public void setMBeanServerConnection(JMXServiceURL url) throws IOException {
        JMXConnector connector = JMXConnectorFactory.connect(url);
        this.setMBeanServerConnection(connector.getMBeanServerConnection());
    }

    public void setMBeanServerConnection(String url) throws IOException {
        if (url.indexOf(47) == -1) {
            url = "service:jmx:rmi:///jndi/rmi://" + url + "/jmxrmi";
        }
        _log.fine("URL=" + url);
        this.setMBeanServerConnection(new JMXServiceURL(url));
    }

    @Override
    public void configure() {
        String url = Network.getProperty("jcd.mx.url");
        if (url != null) {
            try {
                this.setMBeanServerConnection(url);
            }
            catch (IOException e) {
                _log.warning(url + ": " + e);
            }
        }
        super.configure();
    }

    public static void premain(String args, Instrumentation instr) {
        RemoteMBeanSender sender = new RemoteMBeanSender();
        sender.premainConfigure(args);
    }
}

