/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.protocol;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class Network {
    public static final int DEFAULT_PORT = 25826;
    public static final String DEFAULT_V4_ADDR = "239.192.74.66";
    public static final String DEFAULT_V6_ADDR = "ff18::efc0:4a42";
    public static final int TYPE_HOST = 0;
    public static final int TYPE_TIME = 1;
    public static final int TYPE_PLUGIN = 2;
    public static final int TYPE_PLUGIN_INSTANCE = 3;
    public static final int TYPE_TYPE = 4;
    public static final int TYPE_TYPE_INSTANCE = 5;
    public static final int TYPE_VALUES = 6;
    public static final int TYPE_INTERVAL = 7;
    public static final int TYPE_MESSAGE = 256;
    public static final int TYPE_SEVERITY = 257;
    public static final int DS_TYPE_COUNTER = 0;
    public static final int DS_TYPE_GAUGE = 1;
    static final int UINT8_LEN = 1;
    static final int UINT16_LEN = 2;
    static final int UINT32_LEN = 4;
    static final int UINT64_LEN = 8;
    static final int HEADER_LEN = 4;
    static final int BUFFER_SIZE = 1024;
    private static final Properties _props = new Properties();

    public static Properties getProperties() {
        return _props;
    }

    public static String getProperty(String name, String defval) {
        return _props.getProperty(name, System.getProperty(name, defval));
    }

    public static String getProperty(String name) {
        return Network.getProperty(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        String fname = "jcd.properties";
        String file = System.getProperty(fname, fname);
        String absolute = new File(file).getAbsolutePath();
        if (new File(file).exists()) {
            Logger log = Logger.getLogger(Network.class.getName());
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                _props.load(is);
                log.fine("[jcollectd] Loaded " + absolute);
            }
            catch (IOException e) {
                log.fine("[jcollectd] Unable to load " + file + ": " + e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void logProperties() {
        Logger log = Logger.getLogger(Network.class.getName());
        for (Object key : _props.keySet()) {
            String val = Network.getProperty((String)key);
            log.info("[jcollectd] " + key + "=" + val);
        }
    }

    static {
        Network.loadProperties();
        Network.logProperties();
    }
}

