/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.collectd.api.DataSource;
import org.collectd.api.PluginData;
import org.collectd.api.ValueList;
import org.collectd.protocol.TypesDB;

public class PacketWriter {
    private ByteArrayOutputStream _bos;
    private DataOutputStream _os;
    private final TypesDB _types = TypesDB.getInstance();

    public PacketWriter() {
        this(new ByteArrayOutputStream(1024));
    }

    public PacketWriter(ByteArrayOutputStream bos) {
        this._bos = bos;
        this._os = new DataOutputStream(this._bos);
    }

    public int getSize() {
        return this._bos.size();
    }

    public byte[] getBytes() {
        return this._bos.toByteArray();
    }

    public boolean isFull() {
        return this.getSize() >= 1024;
    }

    public void reset() {
        this._bos.reset();
    }

    public void write(PluginData data) throws IOException {
        String type = data.getType();
        this.writeString(0, data.getHost());
        this.writeNumber(1, data.getTime() / 1000L);
        this.writeString(2, data.getPlugin());
        this.writeString(3, data.getPluginInstance());
        this.writeString(4, type);
        this.writeString(5, data.getTypeInstance());
        if (data instanceof ValueList) {
            ValueList vl = (ValueList)data;
            List<DataSource> ds = this._types.getType(type);
            List<Number> values = vl.getValues();
            if (ds != null && ds.size() != values.size()) {
                String msg = type + " datasource mismatch, expecting " + ds.size() + ", given " + values.size();
                throw new IOException(msg);
            }
            this.writeNumber(7, vl.getInterval());
            this.writeValues(ds, values);
        }
    }

    private void writeHeader(int type, int len) throws IOException {
        this._os.writeShort(type);
        this._os.writeShort(len);
    }

    private void writeValues(List<DataSource> ds, List<Number> values) throws IOException {
        int i;
        int num = values.size();
        int len = 6 + num * 1 + num * 8;
        byte[] types = new byte[num];
        int ds_len = ds == null ? 0 : ds.size();
        for (i = 0; i < num; ++i) {
            if (ds_len == 0) {
                if (values.get(i) instanceof Double) {
                    types[i] = 1;
                    continue;
                }
                types[i] = 0;
                continue;
            }
            types[i] = (byte)ds.get(i).getType();
        }
        this.writeHeader(6, len);
        this._os.writeShort(num);
        this._os.write(types);
        for (i = 0; i < num; ++i) {
            Number value = values.get(i);
            if (types[i] == 0) {
                this._os.writeLong(value.longValue());
                continue;
            }
            this.writeDouble(value.doubleValue());
        }
    }

    private void writeDouble(double val) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putDouble(val);
        this._os.write(bb.array());
    }

    private void writeString(int type, String val) throws IOException {
        if (val == null || val.length() == 0) {
            return;
        }
        int len = 4 + val.length() + 1;
        this.writeHeader(type, len);
        this._os.write(val.getBytes());
        this._os.write(0);
    }

    private void writeNumber(int type, long val) throws IOException {
        int len = 12;
        this.writeHeader(type, len);
        this._os.writeLong(val);
    }
}

