/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.protocol;

import java.io.IOException;
import java.net.InetAddress;
import org.collectd.api.Notification;
import org.collectd.api.PluginData;
import org.collectd.api.ValueList;
import org.collectd.protocol.Dispatcher;
import org.collectd.protocol.Network;

public abstract class Sender
implements Dispatcher {
    private String _host = Network.getProperty("jcd.hostalias", Network.getProperty("host", Network.getProperty("hostname")));

    protected abstract void write(PluginData var1) throws IOException;

    public abstract void flush() throws IOException;

    public abstract void addServer(String var1);

    public String getHost() {
        if (this._host == null) {
            try {
                this._host = InetAddress.getLocalHost().getHostName();
            }
            catch (IOException e) {
                this._host = "unknown";
            }
        }
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    protected void setDefaults(PluginData data) {
        if (data.getHost() == null) {
            data.setHost(this.getHost());
        }
        if (data.getTime() <= 0L) {
            data.setTime(System.currentTimeMillis());
        }
    }

    @Override
    public void dispatch(ValueList values) {
        try {
            this.setDefaults(values);
            this.write(values);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispatch(Notification notification) {
        try {
            this.setDefaults(notification);
            this.write(notification);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

