/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.protocol;

import java.util.ArrayList;
import java.util.List;
import org.collectd.api.DataSource;
import org.collectd.api.Notification;
import org.collectd.api.ValueList;
import org.collectd.protocol.Dispatcher;
import org.collectd.protocol.Network;
import org.collectd.protocol.TypesDB;

public class StdoutDispatcher
implements Dispatcher {
    private boolean namesOnly = "true".equals(Network.getProperty("jcd.namesOnly"));

    @Override
    public void dispatch(ValueList vl) {
        if (this.namesOnly) {
            System.out.print("plugin=" + vl.getPlugin());
            System.out.print(",pluginInstance=" + vl.getPluginInstance());
            System.out.print(",type=" + vl.getType());
            System.out.print(",typeInstance=" + vl.getTypeInstance());
            List<DataSource> ds = vl.getDataSource();
            if (ds == null) {
                ds = TypesDB.getInstance().getType(vl.getType());
            }
            if (ds != null) {
                ArrayList<String> names = new ArrayList<String>();
                for (int i = 0; i < ds.size(); ++i) {
                    names.add(ds.get(i).getName());
                }
                System.out.print("-->" + names);
            }
            System.out.println();
        } else {
            System.out.println(vl);
        }
    }

    @Override
    public void dispatch(Notification notification) {
        System.out.println(notification);
    }
}

