/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.protocol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.collectd.api.DataSet;
import org.collectd.api.DataSource;
import org.collectd.protocol.Network;

public class TypesDB {
    public static final String NAME_COUNTER = "counter";
    public static final String NAME_GAUGE = "gauge";
    private Map<String, List<DataSource>> _types = new HashMap<String, List<DataSource>>();
    private static TypesDB _instance;

    public Map<String, List<DataSource>> getTypes() {
        return this._types;
    }

    public List<DataSource> getType(String name) {
        return this._types.get(name);
    }

    public static synchronized TypesDB getInstance() {
        if (_instance == null) {
            _instance = new TypesDB();
            try {
                _instance.load();
                _instance.load(Network.getProperty("typesdb"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return _instance;
    }

    public void load(String files) throws IOException {
        if (files == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(files, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File file = new File(tok.nextToken());
            if (!file.exists()) continue;
            this.load(file);
        }
    }

    public void load() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("META-INF/types.db");
        try {
            this.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void load(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            this.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public void load(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            DataSet ds = DataSet.parseDataSet(line);
            if (ds == null) continue;
            String type = ds.getType();
            List<DataSource> dsrc = ds.getDataSources();
            this._types.put(type, dsrc);
        }
    }

    public static void main(String[] args) throws Exception {
        TypesDB tl = new TypesDB();
        if (args.length == 0) {
            tl.load();
        } else {
            for (int i = 0; i < args.length; ++i) {
                tl.load(new File(args[i]));
            }
        }
        Map<String, List<DataSource>> types = tl.getTypes();
        for (Map.Entry<String, List<DataSource>> entry : types.entrySet()) {
            System.out.println(entry.getKey() + "=" + entry.getValue());
        }
    }
}

