/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.protocol;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.collectd.api.Notification;
import org.collectd.api.PluginData;
import org.collectd.api.ValueList;
import org.collectd.protocol.Dispatcher;
import org.collectd.protocol.Network;
import org.collectd.protocol.StdoutDispatcher;

public class UdpReceiver {
    private static final Logger _log = Logger.getLogger(UdpReceiver.class.getName());
    private Dispatcher _dispatcher;
    private DatagramSocket _socket;
    private int _port = 25826;
    private String _bindAddress;
    private String _ifAddress;
    private boolean _isShutdown = false;

    protected UdpReceiver() {
        String addr = Network.getProperty("laddr", "239.192.74.66");
        if (addr != null) {
            int ix = addr.indexOf(58);
            if (ix == -1) {
                this._bindAddress = addr;
            } else {
                this._bindAddress = addr.substring(0, ix);
                this._port = Integer.parseInt(addr.substring(ix + 1));
            }
        }
        if ((addr = Network.getProperty("ifaddr")) != null) {
            try {
                this._ifAddress = NetworkInterface.getByName(addr).getInetAddresses().nextElement().getHostAddress();
            }
            catch (Exception e) {
                this._ifAddress = addr;
            }
            _log.fine("Using interface address=" + this._ifAddress);
        }
    }

    public UdpReceiver(Dispatcher dispatcher) {
        this();
        this.setDispatcher(dispatcher);
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String getListenAddress() {
        return this._bindAddress;
    }

    public void setListenAddress(String address) {
        this._bindAddress = address;
    }

    public String getInterfaceAddress() {
        return this._ifAddress;
    }

    public void setInterfaceAddress(String address) {
        this._ifAddress = address;
    }

    public DatagramSocket getSocket() throws IOException {
        if (this._socket == null) {
            if (this._bindAddress == null) {
                this._socket = new DatagramSocket(this._port);
            } else {
                InetAddress addr = InetAddress.getByName(this._bindAddress);
                if (addr.isMulticastAddress()) {
                    MulticastSocket mcast = new MulticastSocket(this._port);
                    if (this._ifAddress != null) {
                        mcast.setInterface(InetAddress.getByName(this._ifAddress));
                    }
                    mcast.joinGroup(addr);
                    this._socket = mcast;
                } else {
                    this._socket = new DatagramSocket(this._port, addr);
                }
            }
        }
        return this._socket;
    }

    public void setSocket(DatagramSocket socket) {
        this._socket = socket;
    }

    private String readString(DataInputStream is, int len) throws IOException {
        byte[] buf = new byte[len];
        is.read(buf, 0, len);
        return new String(buf, 0, len - 1);
    }

    private void readValues(DataInputStream is, ValueList vl) throws IOException {
        int i;
        byte[] dbuff = new byte[8];
        int nvalues = is.readUnsignedShort();
        int[] types = new int[nvalues];
        for (i = 0; i < nvalues; ++i) {
            types[i] = is.readByte();
        }
        for (i = 0; i < nvalues; ++i) {
            Number val;
            if (types[i] == 0) {
                val = new Long(is.readLong());
            } else {
                is.read(dbuff);
                ByteBuffer bb = ByteBuffer.wrap(dbuff);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                val = new Double(bb.getDouble());
            }
            vl.addValue(val);
        }
        if (this._dispatcher != null) {
            this._dispatcher.dispatch(vl);
        }
        vl.clearValues();
    }

    public void parse(byte[] packet) throws IOException {
        int total = packet.length;
        ByteArrayInputStream buffer = new ByteArrayInputStream(packet);
        DataInputStream is = new DataInputStream(buffer);
        PacketObject obj = new PacketObject();
        while (0 < total && total > 4) {
            int type = is.readUnsignedShort();
            int len = is.readUnsignedShort();
            if (len < 4) break;
            total -= len;
            len -= 4;
            if (type == 6) {
                this.readValues(is, obj.getValueList());
                continue;
            }
            if (type == 1) {
                obj.pd.setTime(is.readLong() * 1000L);
                continue;
            }
            if (type == 7) {
                obj.getValueList().setInterval(is.readLong());
                continue;
            }
            if (type == 0) {
                obj.pd.setHost(this.readString(is, len));
                continue;
            }
            if (type == 2) {
                obj.pd.setPlugin(this.readString(is, len));
                continue;
            }
            if (type == 3) {
                obj.pd.setPluginInstance(this.readString(is, len));
                continue;
            }
            if (type == 4) {
                obj.pd.setType(this.readString(is, len));
                continue;
            }
            if (type == 5) {
                obj.pd.setTypeInstance(this.readString(is, len));
                continue;
            }
            if (type == 256) {
                Notification notif = obj.getNotification();
                notif.setMessage(this.readString(is, len));
                if (this._dispatcher == null) continue;
                this._dispatcher.dispatch(notif);
                continue;
            }
            if (type != 257) break;
            obj.getNotification().setSeverity((int)is.readLong());
        }
    }

    public void listen() throws Exception {
        this.listen(this.getSocket());
    }

    public void listen(DatagramSocket socket) throws IOException {
        while (true) {
            byte[] buf = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            try {
                socket.receive(packet);
            }
            catch (SocketException e) {
                if (this._isShutdown) break;
                throw e;
            }
            this.parse(packet.getData());
        }
    }

    public void shutdown() {
        if (this._socket != null) {
            this._isShutdown = true;
            this._socket.close();
            this._socket = null;
        }
    }

    public static void main(String[] args) throws Exception {
        new UdpReceiver(new StdoutDispatcher()).listen();
    }

    private static class PacketObject {
        ValueList vl;
        Notification notif;
        PluginData pd = new PluginData();

        private PacketObject() {
        }

        ValueList getValueList() {
            if (this.vl == null) {
                this.vl = new ValueList(this.pd);
                this.pd = this.vl;
            }
            return this.vl;
        }

        Notification getNotification() {
            if (this.notif == null) {
                this.notif = new Notification(this.pd);
                this.pd = this.notif;
            }
            return this.notif;
        }
    }
}

