/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.protocol;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.collectd.api.PluginData;
import org.collectd.protocol.PacketWriter;
import org.collectd.protocol.Sender;

public class UdpSender
extends Sender {
    private static final Logger _log = Logger.getLogger(UdpSender.class.getName());
    private List<InetSocketAddress> _servers = new ArrayList<InetSocketAddress>();
    private DatagramSocket _socket;
    private MulticastSocket _mcast;
    private PacketWriter _writer = new PacketWriter();

    @Override
    public void addServer(String server) {
        int port;
        String ip;
        int ix = server.indexOf(58);
        if (ix == -1) {
            ip = server;
            port = 25826;
        } else {
            ip = server.substring(0, ix);
            port = Integer.parseInt(server.substring(ix + 1));
        }
        this.addServer(new InetSocketAddress(ip, port));
    }

    public void addServer(InetSocketAddress server) {
        this._servers.add(server);
    }

    private DatagramSocket getSocket() throws SocketException {
        if (this._socket == null) {
            this._socket = new DatagramSocket();
        }
        return this._socket;
    }

    private MulticastSocket getMulticastSocket() throws IOException {
        if (this._mcast == null) {
            this._mcast = new MulticastSocket();
            this._mcast.setTimeToLive(1);
        }
        return this._mcast;
    }

    @Override
    protected void write(PluginData data) throws IOException {
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("[jcollectd] sending plugin data:" + data);
        }
        this.setDefaults(data);
        int len = this._writer.getSize();
        this._writer.write(data);
        if (this._writer.getSize() >= 1024) {
            this.send(this._writer.getBytes(), len);
            this._writer.reset();
            this._writer.write(data);
        }
    }

    private void send(byte[] buffer, int len) throws IOException {
        for (InetSocketAddress address : this._servers) {
            DatagramPacket packet = new DatagramPacket(buffer, len, address);
            if (address.getAddress().isMulticastAddress()) {
                this.getMulticastSocket().send(packet);
                continue;
            }
            this.getSocket().send(packet);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._writer.getSize() == 0) {
            return;
        }
        byte[] buffer = this._writer.getBytes();
        this.send(buffer, buffer.length);
        this._writer.reset();
    }
}

