/*
 * Decompiled with CFR 0.152.
 */
package com.harium.database;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseFieldConfig;

public class Column {
    private DatabaseFieldConfig config;

    protected Column(DatabaseFieldConfig config) {
        this.config = config;
    }

    public static Column create() {
        return new Column(new DatabaseFieldConfig());
    }

    public Column id() {
        this.config.setId(true);
        return this;
    }

    public Column idAutoIncrement() {
        this.config.setId(false);
        this.config.setGeneratedId(true);
        this.config.setAllowGeneratedIdInsert(true);
        this.config.setDataType(DataType.INTEGER);
        return this;
    }

    public Column field(String name) {
        this.config.setFieldName(name);
        return this;
    }

    public Column columnName(String name) {
        this.config.setColumnName(name);
        return this;
    }

    public Column nullable(boolean nullable) {
        this.config.setCanBeNull(nullable);
        return this;
    }

    public Column notNull() {
        return this.nullable(false);
    }

    public Column defaultValue(String value) {
        this.config.setDefaultValue(value);
        return this;
    }

    public Column index(String name) {
        this.config.setIndex(true);
        this.config.setIndexName(name);
        return this;
    }

    public Column unique() {
        this.config.setUnique(true);
        return this;
    }

    public Column readOnly() {
        this.config.setReadOnly(true);
        return this;
    }

    public Column typeBoolean() {
        this.config.setDataType(DataType.BOOLEAN);
        return this;
    }

    public Column typeByte() {
        this.config.setDataType(DataType.BYTE);
        return this;
    }

    public Column typeChar() {
        this.config.setDataType(DataType.CHAR);
        return this;
    }

    public Column typeDate() {
        this.config.setDataType(DataType.DATE);
        return this;
    }

    public Column typeDouble() {
        this.config.setDataType(DataType.DOUBLE);
        return this;
    }

    public Column typeFloat() {
        this.config.setDataType(DataType.FLOAT);
        return this;
    }

    public Column typeInteger() {
        this.config.setDataType(DataType.INTEGER);
        return this;
    }

    public Column typeLong() {
        this.config.setDataType(DataType.LONG);
        return this;
    }

    public Column typeShort() {
        this.config.setDataType(DataType.SHORT);
        return this;
    }

    public Column typeSQLDate() {
        this.config.setDataType(DataType.SQL_DATE);
        return this;
    }

    public Column typeString() {
        this.config.setDataType(DataType.STRING);
        return this;
    }

    public Column typeUUID() {
        this.config.setDataType(DataType.UUID);
        return this;
    }

    public Column type(DataType type) {
        this.config.setDataType(type);
        return this;
    }

    public DatabaseFieldConfig config() {
        return this.config;
    }
}

