/*
 * Decompiled with CFR 0.152.
 */
package com.harium.database;

import com.harium.database.Column;
import com.harium.database.model.BaseDAO;
import com.harium.database.module.OrmLiteDatabaseModule;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Table<T> {
    private Class<T> klass;
    private OrmLiteDatabaseModule module;
    private DatabaseTableConfig<T> config;
    private Map<String, Column> fields;

    public Table(Class<T> klass) {
        this.klass = klass;
        this.fields = new HashMap<String, Column>();
        this.config = new DatabaseTableConfig();
        this.config.setTableName(klass.getSimpleName().toLowerCase());
        this.config.setDataClass(klass);
    }

    public Column createColumn(String name) {
        Column column = Column.create().field(name).columnName(name);
        this.fields.put(name, column);
        return column;
    }

    public Column getColumn(String name) {
        return this.fields.get(name);
    }

    public void register(OrmLiteDatabaseModule module) {
        this.module = module;
        ArrayList<DatabaseFieldConfig> list = new ArrayList<DatabaseFieldConfig>();
        for (Column column : this.fields.values()) {
            list.add(column.config());
        }
        this.config.setFieldConfigs(list);
        module.register(this.klass, this.config);
    }

    public BaseDAO getDAO(Class klass) {
        return this.module.getDAO(klass);
    }
}

