/*
 * Decompiled with CFR 0.152.
 */
package com.harium.database.dao;

import com.harium.database.model.BaseDAO;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OrmLiteBaseDAOImpl<T, ID>
implements BaseDAO<T, ConnectionSource> {
    private Class<T> klass;
    protected Dao<T, ID> dao;

    public OrmLiteBaseDAOImpl() {
    }

    public OrmLiteBaseDAOImpl(Class<T> klass) {
        this.klass = klass;
    }

    public void init(ConnectionSource connectionSource) {
        try {
            this.dao = DaoManager.createDao((ConnectionSource)connectionSource, this.klass);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void init(ConnectionSource connectionSource, DatabaseTableConfig<T> config) {
        try {
            this.dao = DaoManager.createDao((ConnectionSource)connectionSource, config);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<T> queryForEq(String column, Object o) throws SQLException {
        return this.dao.queryForEq(column, o);
    }

    public T queryForId(ID id) {
        try {
            return (T)this.dao.queryForId(id);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<T> queryAll() {
        try {
            return this.dao.queryForAll();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    public int create(T item) {
        try {
            return this.dao.create(item);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int update(T item) {
        try {
            return this.dao.update(item);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -2;
        }
    }

    public int createOrUpdate(T item) {
        Dao.CreateOrUpdateStatus status = null;
        try {
            status = this.dao.createOrUpdate(item);
            return status.getNumLinesChanged();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (status.isCreated()) {
                return -2;
            }
            return -1;
        }
    }

    public int delete(T model) {
        try {
            return this.dao.delete(model);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -3;
        }
    }

    public long count() {
        try {
            return this.dao.countOf();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Class<T> getKlass() {
        return this.klass;
    }
}

