/*
 * Decompiled with CFR 0.152.
 */
package com.harium.database.module;

import com.harium.database.dao.OrmLiteBaseDAOImpl;
import com.harium.database.model.BaseDAO;
import com.harium.database.module.DatabaseModule;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OrmLiteDatabaseModule<ID>
implements DatabaseModule<ConnectionSource> {
    protected boolean ignoreErrors = true;
    protected ConnectionSource connectionSource;
    protected Map<Class<?>, BaseDAO<?, ConnectionSource>> daos = new HashMap();
    protected List<BaseDAO<?, ConnectionSource>> entities = new ArrayList();
    protected Map<Class<?>, DatabaseTableConfig<?>> configEntities = new HashMap();

    public void init() {
        this.init(false);
    }

    public void init(boolean clearDatabase) {
        try {
            this.connectionSource = this.initConnection();
            if (clearDatabase) {
                this.clear();
            }
            this.setupDatabase(this.connectionSource);
            this.initDAOs(this.connectionSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract ConnectionSource initConnection() throws SQLException;

    public void clear() throws Exception {
        for (BaseDAO<?, ConnectionSource> baseDAO : this.entities) {
            TableUtils.dropTable((ConnectionSource)this.connectionSource, (Class)baseDAO.getKlass(), (boolean)this.ignoreErrors);
        }
        for (Map.Entry entry : this.configEntities.entrySet()) {
            TableUtils.dropTable((ConnectionSource)this.connectionSource, (DatabaseTableConfig)((DatabaseTableConfig)entry.getValue()), (boolean)this.ignoreErrors);
        }
    }

    private void setupDatabase(ConnectionSource connectionSource) throws SQLException {
        for (BaseDAO<?, ConnectionSource> baseDAO : this.entities) {
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, (Class)baseDAO.getKlass());
        }
        for (DatabaseTableConfig databaseTableConfig : this.configEntities.values()) {
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, (DatabaseTableConfig)databaseTableConfig);
        }
    }

    protected void initDAOs(ConnectionSource connectionSource) {
        for (BaseDAO<?, ConnectionSource> baseDAO : this.entities) {
            this.initDAO(connectionSource, baseDAO);
        }
        for (Map.Entry entry : this.configEntities.entrySet()) {
            this.initDAO(connectionSource, (Class)entry.getKey(), (DatabaseTableConfig)entry.getValue());
        }
    }

    private void initDAO(ConnectionSource connectionSource, BaseDAO<?, ConnectionSource> dao) {
        dao.init((Object)connectionSource);
        this.addDAO(dao);
    }

    private void initDAO(ConnectionSource connectionSource, Class<?> klass, DatabaseTableConfig<?> config) {
        OrmLiteBaseDAOImpl dao = new OrmLiteBaseDAOImpl(klass);
        dao.init(connectionSource, config);
        this.addDAO(klass, dao);
    }

    private BaseDAO addDAO(BaseDAO<?, ConnectionSource> baseDAO) {
        this.daos.put(baseDAO.getKlass(), baseDAO);
        return baseDAO;
    }

    private BaseDAO addDAO(Class<?> klass, BaseDAO<?, ConnectionSource> baseDAO) {
        this.daos.put(klass, baseDAO);
        return baseDAO;
    }

    public BaseDAO getDAO(Class klass) {
        return this.daos.get(klass);
    }

    public void register(BaseDAO<?, ConnectionSource> dao) {
        this.entities.add(dao);
    }

    public void register(Class<?> klass, DatabaseTableConfig<?> dao) {
        this.configEntities.put(klass, dao);
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public static void logLevel(Log.Level level) {
        System.setProperty("com.j256.ormlite.logger.level", level.name());
    }

    public static void disableLogs() {
        OrmLiteDatabaseModule.logLevel(Log.Level.FATAL);
    }
}

