/*
 * Decompiled with CFR 0.152.
 */
package com.harium.etyl.sound;

import com.harium.etyl.loader.LoaderImpl;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.codecs.CodecJLayerMP3;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryJavaSound;

public class MultimediaLoader
extends LoaderImpl {
    private SoundSystem soundSystem;
    private static MultimediaLoader instance = null;

    public static MultimediaLoader getInstance() {
        if (instance == null) {
            instance = new MultimediaLoader();
        }
        return instance;
    }

    public MultimediaLoader() {
        this.folder = "assets/sounds/";
        try {
            SoundSystemConfig.setCodec("wav", CodecWav.class);
            SoundSystemConfig.setCodec("ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec("mp3", CodecJLayerMP3.class);
            SoundSystemConfig.addLibrary(LibraryJavaSound.class);
            this.soundSystem = new SoundSystem(LibraryJavaSound.class);
        }
        catch (SoundSystemException e) {
            System.err.println("Error on " + ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    public void setSoundLibrary(Class<? extends Library> library) {
        try {
            this.soundSystem = new SoundSystem(library);
        }
        catch (SoundSystemException e) {
            e.printStackTrace();
        }
    }

    public boolean isPlaying(String path) {
        return this.soundSystem.playing(path);
    }

    public void loadSound(String path) {
        this.soundSystem.loadSound(this.fullPath(path));
    }

    public void playSound(String path) {
        this.soundSystem.quickPlay(false, this.fullPath(path), false, 0.0f, 0.0f, 0.0f, 0, SoundSystemConfig.getDefaultRolloff());
    }

    public void loadMusic(String path) {
        this.soundSystem.loadSound(this.fullPath(path));
    }

    public void playMusic(String path, boolean loop) {
        this.soundSystem.backgroundMusic(this.fullPath(path), this.fullPath(path), loop);
    }

    public void playMusicStream(String path) {
        this.playMusicStream(path, false);
    }

    public void playMusicStream(String path, boolean loop) {
        this.playMusic(path, loop);
    }

    public void stop(String path) {
        this.soundSystem.stop(this.fullPath(path));
    }

    public void dispose(String path) {
        if (!this.soundSystem.playing(path)) {
            return;
        }
        this.stop(path);
    }

    public boolean canLoad(String extension) {
        return SoundSystemConfig.getCodec(extension) != null;
    }
}

