/*
 * Decompiled with CFR 0.152.
 */
package com.harium.etyl.sound.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class AudioHandler {
    private boolean recording = false;
    private ByteArrayOutputStream inputBuffer;
    private static AudioHandler instance = null;
    private TargetDataLine line;

    public static AudioHandler getInstance() {
        if (instance == null) {
            instance = new AudioHandler();
        }
        return instance;
    }

    public synchronized void captureAudio() {
        try {
            final AudioFormat format = this.getFormat();
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open(format);
            this.line.start();
            Runnable record = new Runnable(){
                int bufferSize;
                byte[] buffer;
                {
                    this.bufferSize = (int)format.getSampleRate() * format.getFrameSize();
                    this.buffer = new byte[this.bufferSize];
                }

                @Override
                public void run() {
                    AudioHandler.this.inputBuffer = new ByteArrayOutputStream();
                    AudioHandler.this.recording = true;
                    try {
                        while (AudioHandler.this.recording) {
                            int count = AudioHandler.this.line.read(this.buffer, 0, this.buffer.length);
                            if (count <= 0) continue;
                            AudioHandler.this.inputBuffer.write(this.buffer, 0, count);
                        }
                        AudioHandler.this.inputBuffer.close();
                    }
                    catch (IOException e) {
                        System.err.println("I/O problems: " + e);
                        System.exit(-1);
                    }
                }
            };
            Thread captureThread = new Thread(record);
            captureThread.start();
        }
        catch (LineUnavailableException e) {
            System.err.println("Line unavailable: " + e);
        }
    }

    public synchronized void stopCapture() {
        this.recording = false;
    }

    public synchronized void playAudio() {
        byte[] audio = this.inputBuffer.toByteArray();
        this.playAudio(audio, this.getFormat());
    }

    public synchronized void playAudio(byte[] audio, final AudioFormat format) {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(audio);
            final AudioInputStream ais = new AudioInputStream(input, format, audio.length / format.getFrameSize());
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            final SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            line.start();
            Runnable runner = new Runnable(){
                int bufferSize;
                byte[] buffer;
                {
                    this.bufferSize = (int)format.getSampleRate() * format.getFrameSize();
                    this.buffer = new byte[this.bufferSize];
                }

                @Override
                public void run() {
                    try {
                        int count;
                        while ((count = ais.read(this.buffer, 0, this.buffer.length)) != -1) {
                            if (count <= 0) continue;
                            line.write(this.buffer, 0, count);
                        }
                        line.drain();
                        line.close();
                    }
                    catch (IOException e) {
                        System.err.println("I/O problems: " + e);
                    }
                }
            };
            Thread playThread = new Thread(runner);
            playThread.start();
        }
        catch (LineUnavailableException e) {
            System.err.println("Line unavailable: " + e);
        }
    }

    public int[][] getWaveformSamples() {
        byte[] buffer = this.inputBuffer.toByteArray();
        AudioInputStream audioInputStream = new AudioInputStream(this.line);
        int numChannels = audioInputStream.getFormat().getChannels();
        int frameLength = buffer.length;
        int[][] waveSamples = new int[numChannels][frameLength];
        int sampleIndex = 0;
        int t = 0;
        while (t < buffer.length) {
            for (int channel = 0; channel < numChannels; ++channel) {
                int sample;
                byte low = buffer[t];
                byte high = buffer[++t];
                ++t;
                waveSamples[channel][sampleIndex] = sample = this.getSixteenBitSample(high, low);
            }
            ++sampleIndex;
        }
        return waveSamples;
    }

    private int getSixteenBitSample(int high, int low) {
        return (high << 8) + (low & 0xFF);
    }

    private AudioFormat getFormat() {
        float sampleRate = 8000.0f;
        int sampleSizeInBits = 8;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        return format;
    }

    public ByteArrayOutputStream getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(ByteArrayOutputStream inputBuffer) {
        this.inputBuffer = inputBuffer;
    }
}

