/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.util.audio;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;

public class FadeableAudioInputStream
extends AudioInputStream {
    private AudioInputStream stream;
    private boolean fading = false;
    private double phi = 0.0;

    public FadeableAudioInputStream(AudioInputStream stream) throws IOException {
        super(stream, stream.getFormat(), -1L);
    }

    public void fadeOut() {
        this.fading = true;
        this.phi = 0.0;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int read = super.read(b, offset, length);
        if (this.fading) {
            int j = 0;
            int l = 0;
            int r = 0;
            double gain = 0.0;
            for (int i = offset; i < offset + read; i += 4) {
                j = i;
                l = b[j++] & 0xFF;
                l |= b[j++] << 8;
                r = b[j++] & 0xFF;
                r |= b[j] << 8;
                if (this.phi < 1.5707963267948966) {
                    this.phi += 1.5E-5;
                }
                gain = Math.cos(this.phi);
                l = (int)((double)l * gain);
                r = (int)((double)r * gain);
                j = i;
                b[j++] = (byte)(l & 0xFF);
                b[j++] = (byte)(l >> 8 & 0xFF);
                b[j++] = (byte)(r & 0xFF);
                b[j++] = (byte)(r >> 8 & 0xFF);
            }
        }
        return read;
    }
}

