/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.util.io.HuffmanNode;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import java.util.Arrays;

public class CodeBook {
    private HuffmanNode huffmanRoot;
    private int dimensions;
    private int entries;
    private int[] entryLengths;
    private float[][] valueVector;
    private static long totalTime = 0L;

    protected CodeBook(BitInputStream source) throws VorbisFormatException, IOException {
        int i;
        if (source.getInt(24) != 5653314) {
            throw new VorbisFormatException("The code book sync pattern is not correct.");
        }
        this.dimensions = source.getInt(16);
        this.entries = source.getInt(24);
        this.entryLengths = new int[this.entries];
        boolean ordered = source.getBit();
        if (ordered) {
            int num;
            int cl = source.getInt(5) + 1;
            for (i = 0; i < this.entryLengths.length; i += num) {
                num = source.getInt(Util.ilog(this.entryLengths.length - i));
                if (i + num > this.entryLengths.length) {
                    throw new VorbisFormatException("The codebook entry length list is longer than the actual number of entry lengths.");
                }
                Arrays.fill(this.entryLengths, i, i + num, cl);
                ++cl;
            }
        } else {
            boolean sparse = source.getBit();
            if (sparse) {
                for (i = 0; i < this.entryLengths.length; ++i) {
                    this.entryLengths[i] = source.getBit() ? source.getInt(5) + 1 : -1;
                }
            } else {
                for (i = 0; i < this.entryLengths.length; ++i) {
                    this.entryLengths[i] = source.getInt(5) + 1;
                }
            }
        }
        if (!this.createHuffmanTree(this.entryLengths)) {
            throw new VorbisFormatException("An exception was thrown when building the codebook Huffman tree.");
        }
        int codeBookLookupType = source.getInt(4);
        switch (codeBookLookupType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                int i2;
                float codeBookMinimumValue = Util.float32unpack(source.getInt(32));
                float codeBookDeltaValue = Util.float32unpack(source.getInt(32));
                int codeBookValueBits = source.getInt(4) + 1;
                boolean codeBookSequenceP = source.getBit();
                int codeBookLookupValues = 0;
                codeBookLookupValues = codeBookLookupType == 1 ? Util.lookup1Values(this.entries, this.dimensions) : this.entries * this.dimensions;
                int[] codeBookMultiplicands = new int[codeBookLookupValues];
                for (i2 = 0; i2 < codeBookMultiplicands.length; ++i2) {
                    codeBookMultiplicands[i2] = source.getInt(codeBookValueBits);
                }
                this.valueVector = new float[this.entries][this.dimensions];
                if (codeBookLookupType == 1) {
                    for (i2 = 0; i2 < this.entries; ++i2) {
                        float last = 0.0f;
                        int indexDivisor = 1;
                        for (int j = 0; j < this.dimensions; ++j) {
                            int multiplicandOffset = i2 / indexDivisor % codeBookLookupValues;
                            this.valueVector[i2][j] = (float)codeBookMultiplicands[multiplicandOffset] * codeBookDeltaValue + codeBookMinimumValue + last;
                            if (codeBookSequenceP) {
                                last = this.valueVector[i2][j];
                            }
                            indexDivisor *= codeBookLookupValues;
                        }
                    }
                    break;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new VorbisFormatException("Unsupported codebook lookup type: " + codeBookLookupType);
            }
        }
    }

    private boolean createHuffmanTree(int[] entryLengths) {
        this.huffmanRoot = new HuffmanNode();
        for (int i = 0; i < entryLengths.length; ++i) {
            int el = entryLengths[i];
            if (el <= 0 || this.huffmanRoot.setNewValue(el, i)) continue;
            return false;
        }
        return true;
    }

    protected int getDimensions() {
        return this.dimensions;
    }

    protected int getEntries() {
        return this.entries;
    }

    protected HuffmanNode getHuffmanRoot() {
        return this.huffmanRoot;
    }

    protected int readInt(BitInputStream source) throws IOException {
        return source.getInt(this.huffmanRoot);
    }

    protected void readVvAdd(float[][] a, BitInputStream source, int offset, int length) throws VorbisFormatException, IOException {
        int chptr = 0;
        int ch = a.length;
        if (ch == 0) {
            return;
        }
        int lim = (offset + length) / ch;
        int i = offset / ch;
        while (i < lim) {
            float[] ve = this.valueVector[source.getInt(this.huffmanRoot)];
            for (int j = 0; j < this.dimensions; ++j) {
                float[] fArray = a[chptr++];
                int n = i++;
                fArray[n] = fArray[n] + ve[j];
                if (chptr != ch) continue;
                chptr = 0;
            }
        }
    }
}

