/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class CommentHeader {
    public static final String TITLE = "TITLE";
    public static final String ARTIST = "ARTIST";
    public static final String ALBUM = "ALBUM";
    public static final String TRACKNUMBER = "TRACKNUMBER";
    public static final String VERSION = "VERSION";
    public static final String PERFORMER = "PERFORMER";
    public static final String COPYRIGHT = "COPYRIGHT";
    public static final String LICENSE = "LICENSE";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String GENRE = "GENRE";
    public static final String DATE = "DATE";
    public static final String LOCATION = "LOCATION";
    public static final String CONTACT = "CONTACT";
    public static final String ISRC = "ISRC";
    private String vendor;
    private HashMap<String, ArrayList<String>> comments = new HashMap();
    private boolean framingBit;
    private static final long HEADER = 126896460427126L;

    public CommentHeader(BitInputStream source) throws VorbisFormatException, IOException {
        if (source.getLong(48) != 126896460427126L) {
            throw new VorbisFormatException("The identification header has an illegal leading.");
        }
        this.vendor = this.getString(source);
        int ucLength = source.getInt(32);
        for (int i = 0; i < ucLength; ++i) {
            String comment = this.getString(source);
            int ix = comment.indexOf(61);
            String key = comment.substring(0, ix);
            String value = comment.substring(ix + 1);
            this.addComment(key, value);
        }
        this.framingBit = source.getInt(8) != 0;
    }

    private void addComment(String key, String value) {
        ArrayList<String> al = this.comments.get(key);
        if (al == null) {
            al = new ArrayList();
            this.comments.put(key, al);
        }
        al.add(value);
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getComment(String key) {
        ArrayList<String> al = this.comments.get(key);
        return al == null ? (String)null : al.get(0);
    }

    public String[] getComments(String key) {
        ArrayList<String> al = this.comments.get(key);
        return al == null ? new String[]{} : al.toArray(new String[al.size()]);
    }

    public String getTitle() {
        return this.getComment(TITLE);
    }

    public String[] getTitles() {
        return this.getComments(TITLE);
    }

    public String getVersion() {
        return this.getComment(VERSION);
    }

    public String[] getVersions() {
        return this.getComments(VERSION);
    }

    public String getAlbum() {
        return this.getComment(ALBUM);
    }

    public String[] getAlbums() {
        return this.getComments(ALBUM);
    }

    public String getTrackNumber() {
        return this.getComment(TRACKNUMBER);
    }

    public String[] getTrackNumbers() {
        return this.getComments(TRACKNUMBER);
    }

    public String getArtist() {
        return this.getComment(ARTIST);
    }

    public String[] getArtists() {
        return this.getComments(ARTIST);
    }

    public String getPerformer() {
        return this.getComment(PERFORMER);
    }

    public String[] getPerformers() {
        return this.getComments(PERFORMER);
    }

    public String getCopyright() {
        return this.getComment(COPYRIGHT);
    }

    public String[] getCopyrights() {
        return this.getComments(COPYRIGHT);
    }

    public String getLicense() {
        return this.getComment(LICENSE);
    }

    public String[] getLicenses() {
        return this.getComments(LICENSE);
    }

    public String getOrganization() {
        return this.getComment(ORGANIZATION);
    }

    public String[] getOrganizations() {
        return this.getComments(ORGANIZATION);
    }

    public String getDescription() {
        return this.getComment(DESCRIPTION);
    }

    public String[] getDescriptions() {
        return this.getComments(DESCRIPTION);
    }

    public String getGenre() {
        return this.getComment(GENRE);
    }

    public String[] getGenres() {
        return this.getComments(GENRE);
    }

    public String getDate() {
        return this.getComment(DATE);
    }

    public String[] getDates() {
        return this.getComments(DATE);
    }

    public String getLocation() {
        return this.getComment(LOCATION);
    }

    public String[] getLocations() {
        return this.getComments(LOCATION);
    }

    public String getContact() {
        return this.getComment(CONTACT);
    }

    public String[] getContacts() {
        return this.getComments(CONTACT);
    }

    public String getIsrc() {
        return this.getComment(ISRC);
    }

    public String[] getIsrcs() {
        return this.getComments(ISRC);
    }

    private String getString(BitInputStream source) throws IOException, VorbisFormatException {
        int length = source.getInt(32);
        byte[] strArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            strArray[i] = (byte)source.getInt(8);
        }
        return new String(strArray, "UTF-8");
    }
}

