/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Mapping;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

public class Mapping0
extends Mapping {
    private int[] magnitudes;
    private int[] angles;
    private int[] mux;
    private int[] submapFloors;
    private int[] submapResidues;

    protected Mapping0(VorbisStream vorbis, BitInputStream source, SetupHeader header) throws VorbisFormatException, IOException {
        int i;
        int submaps = 1;
        if (source.getBit()) {
            submaps = source.getInt(4) + 1;
        }
        int channels = vorbis.getIdentificationHeader().getChannels();
        int ilogChannels = Util.ilog(channels - 1);
        if (source.getBit()) {
            int couplingSteps = source.getInt(8) + 1;
            this.magnitudes = new int[couplingSteps];
            this.angles = new int[couplingSteps];
            for (int i2 = 0; i2 < couplingSteps; ++i2) {
                this.magnitudes[i2] = source.getInt(ilogChannels);
                this.angles[i2] = source.getInt(ilogChannels);
                if (this.magnitudes[i2] != this.angles[i2] && this.magnitudes[i2] < channels && this.angles[i2] < channels) continue;
                System.err.println(this.magnitudes[i2]);
                System.err.println(this.angles[i2]);
                throw new VorbisFormatException("The channel magnitude and/or angle mismatch.");
            }
        } else {
            this.magnitudes = new int[0];
            this.angles = new int[0];
        }
        if (source.getInt(2) != 0) {
            throw new VorbisFormatException("A reserved mapping field has an invalid value.");
        }
        this.mux = new int[channels];
        if (submaps > 1) {
            for (i = 0; i < channels; ++i) {
                this.mux[i] = source.getInt(4);
                if (this.mux[i] <= submaps) continue;
                throw new VorbisFormatException("A mapping mux value is higher than the number of submaps");
            }
        } else {
            for (i = 0; i < channels; ++i) {
                this.mux[i] = 0;
            }
        }
        this.submapFloors = new int[submaps];
        this.submapResidues = new int[submaps];
        int floorCount = header.getFloors().length;
        int residueCount = header.getResidues().length;
        for (int i3 = 0; i3 < submaps; ++i3) {
            source.getInt(8);
            this.submapFloors[i3] = source.getInt(8);
            this.submapResidues[i3] = source.getInt(8);
            if (this.submapFloors[i3] > floorCount) {
                throw new VorbisFormatException("A mapping floor value is higher than the number of floors.");
            }
            if (this.submapResidues[i3] <= residueCount) continue;
            throw new VorbisFormatException("A mapping residue value is higher than the number of residues.");
        }
    }

    @Override
    protected int getType() {
        return 0;
    }

    @Override
    protected int[] getAngles() {
        return this.angles;
    }

    @Override
    protected int[] getMagnitudes() {
        return this.magnitudes;
    }

    @Override
    protected int[] getMux() {
        return this.mux;
    }

    @Override
    protected int[] getSubmapFloors() {
        return this.submapFloors;
    }

    @Override
    protected int[] getSubmapResidues() {
        return this.submapResidues;
    }

    @Override
    protected int getCouplingSteps() {
        return this.angles.length;
    }

    @Override
    protected int getSubmaps() {
        return this.submapFloors.length;
    }
}

