/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.CodeBook;
import de.jarnbjo.vorbis.Mode;
import de.jarnbjo.vorbis.Residue;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

public class Residue2
extends Residue {
    private double[][] decodedVectors;

    private Residue2() {
    }

    protected Residue2(BitInputStream source, SetupHeader header) throws VorbisFormatException, IOException {
        super(source, header);
    }

    @Override
    protected int getType() {
        return 2;
    }

    @Override
    protected void decodeResidue(VorbisStream vorbis, BitInputStream source, Mode mode, int ch, boolean[] doNotDecodeFlags, float[][] vectors) throws VorbisFormatException, IOException {
        Residue.Look look = this.getLook(vorbis, mode);
        CodeBook codeBook = vorbis.getSetupHeader().getCodeBooks()[this.getClassBook()];
        int classvalsPerCodeword = codeBook.getDimensions();
        int nToRead = this.getEnd() - this.getBegin();
        int partitionsToRead = nToRead / this.getPartitionSize();
        int samplesPerPartition = this.getPartitionSize();
        int partitionsPerWord = look.getPhraseBook().getDimensions();
        int partWords = (partitionsToRead + partitionsPerWord - 1) / partitionsPerWord;
        int realCh = 0;
        for (int i = 0; i < doNotDecodeFlags.length; ++i) {
            if (doNotDecodeFlags[i]) continue;
            ++realCh;
        }
        float[][] realVectors = new float[realCh][];
        realCh = 0;
        for (int i = 0; i < doNotDecodeFlags.length; ++i) {
            if (doNotDecodeFlags[i]) continue;
            realVectors[realCh++] = vectors[i];
        }
        int[][] partword = new int[partWords][];
        for (int s = 0; s < look.getStages(); ++s) {
            int i = 0;
            int l = 0;
            while (i < partitionsToRead) {
                if (s == 0) {
                    int temp = source.getInt(look.getPhraseBook().getHuffmanRoot());
                    if (temp == -1) {
                        throw new VorbisFormatException("");
                    }
                    partword[l] = look.getDecodeMap()[temp];
                    if (partword[l] == null) {
                        throw new VorbisFormatException("");
                    }
                }
                for (int k = 0; k < partitionsPerWord && i < partitionsToRead; ++k, ++i) {
                    CodeBook stagebook;
                    int offset = this.begin + i * samplesPerPartition;
                    if ((this.cascade[partword[l][k]] & 1 << s) == 0 || (stagebook = vorbis.getSetupHeader().getCodeBooks()[look.getPartBooks()[partword[l][k]][s]]) == null) continue;
                    stagebook.readVvAdd(realVectors, source, offset, samplesPerPartition);
                }
                ++l;
            }
        }
    }

    public Object clone() {
        Residue2 clone = new Residue2();
        this.fill(clone);
        return clone;
    }

    protected double[][] getDecodedVectors() {
        return this.decodedVectors;
    }
}

