/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound;

import com.badlogic.gdx.math.Vector3;

public class ListenerData {
    public Vector3 position;
    public Vector3 lookAt;
    public Vector3 up;
    public Vector3 velocity;
    public float angle = 0.0f;

    public ListenerData() {
        this.position = new Vector3(0.0f, 0.0f, 0.0f);
        this.lookAt = new Vector3(0.0f, 0.0f, -1.0f);
        this.up = new Vector3(0.0f, 1.0f, 0.0f);
        this.velocity = new Vector3(0.0f, 0.0f, 0.0f);
        this.angle = 0.0f;
    }

    public ListenerData(float pX, float pY, float pZ, float lX, float lY, float lZ, float uX, float uY, float uZ, float a) {
        this.position = new Vector3(pX, pY, pZ);
        this.lookAt = new Vector3(lX, lY, lZ);
        this.up = new Vector3(uX, uY, uZ);
        this.velocity = new Vector3(0.0f, 0.0f, 0.0f);
        this.angle = a;
    }

    public ListenerData(Vector3 p, Vector3 l, Vector3 u, float a) {
        this.position = p.cpy();
        this.lookAt = l.cpy();
        this.up = u.cpy();
        this.velocity = new Vector3(0.0f, 0.0f, 0.0f);
        this.angle = a;
    }

    public void setData(float pX, float pY, float pZ, float lX, float lY, float lZ, float uX, float uY, float uZ, float a) {
        this.position.x = pX;
        this.position.y = pY;
        this.position.z = pZ;
        this.lookAt.x = lX;
        this.lookAt.y = lY;
        this.lookAt.z = lZ;
        this.up.x = uX;
        this.up.y = uY;
        this.up.z = uZ;
        this.angle = a;
    }

    public void setData(Vector3 p, Vector3 l, Vector3 u, float a) {
        this.position.x = p.x;
        this.position.y = p.y;
        this.position.z = p.z;
        this.lookAt.x = l.x;
        this.lookAt.y = l.y;
        this.lookAt.z = l.z;
        this.up.x = u.x;
        this.up.y = u.y;
        this.up.z = u.z;
        this.angle = a;
    }

    public void setData(ListenerData l) {
        this.position.x = l.position.x;
        this.position.y = l.position.y;
        this.position.z = l.position.z;
        this.lookAt.x = l.lookAt.x;
        this.lookAt.y = l.lookAt.y;
        this.lookAt.z = l.lookAt.z;
        this.up.x = l.up.x;
        this.up.y = l.up.y;
        this.up.z = l.up.z;
        this.angle = l.angle;
    }

    public void setPosition(float x, float y, float z) {
        this.position.x = x;
        this.position.y = y;
        this.position.z = z;
    }

    public void setPosition(Vector3 p) {
        this.position.x = p.x;
        this.position.y = p.y;
        this.position.z = p.z;
    }

    public void setOrientation(float lX, float lY, float lZ, float uX, float uY, float uZ) {
        this.lookAt.x = lX;
        this.lookAt.y = lY;
        this.lookAt.z = lZ;
        this.up.x = uX;
        this.up.y = uY;
        this.up.z = uZ;
    }

    public void setOrientation(Vector3 l, Vector3 u) {
        this.lookAt.x = l.x;
        this.lookAt.y = l.y;
        this.lookAt.z = l.z;
        this.up.x = u.x;
        this.up.y = u.y;
        this.up.z = u.z;
    }

    public void setVelocity(Vector3 v) {
        this.velocity.x = v.x;
        this.velocity.y = v.y;
        this.velocity.z = v.z;
    }

    public void setVelocity(float x, float y, float z) {
        this.velocity.x = x;
        this.velocity.y = y;
        this.velocity.z = z;
    }

    public void setAngle(float a) {
        this.angle = a;
        this.lookAt.x = -1.0f * (float)Math.sin(this.angle);
        this.lookAt.z = -1.0f * (float)Math.cos(this.angle);
    }
}

