/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.libraries;

import com.badlogic.gdx.math.Vector3;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ListenerData;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;
import paulscode.sound.libraries.ChannelJavaSound;
import paulscode.sound.libraries.LibraryJavaSound;

public class SourceJavaSound
extends Source {
    protected ChannelJavaSound channelJavaSound;
    public ListenerData listener;
    private float pan;

    public SourceJavaSound(ListenerData listener, boolean priority, boolean toStream, boolean toLoop, String sourcename, FilenameURL filenameURL, SoundBuffer soundBuffer, float x, float y, float z, int attModel, float distOrRoll, boolean temporary) {
        super(priority, toStream, toLoop, sourcename, filenameURL, soundBuffer, x, y, z, attModel, distOrRoll, temporary);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listener;
        this.positionChanged();
    }

    public SourceJavaSound(ListenerData listener, Source old, SoundBuffer soundBuffer) {
        super(old, soundBuffer);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listener;
        this.positionChanged();
    }

    public SourceJavaSound(ListenerData listener, AudioFormat audioFormat, boolean priority, String sourcename, float x, float y, float z, int attModel, float distOrRoll) {
        super(audioFormat, priority, sourcename, x, y, z, attModel, distOrRoll);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        this.pan = 0.0f;
        this.libraryType = LibraryJavaSound.class;
        this.listener = listener;
        this.positionChanged();
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public void changeSource(boolean priority, boolean toStream, boolean toLoop, String sourcename, FilenameURL filenameURL, SoundBuffer soundBuffer, float x, float y, float z, int attModel, float distOrRoll, boolean temporary) {
        super.changeSource(priority, toStream, toLoop, sourcename, filenameURL, soundBuffer, x, y, z, attModel, distOrRoll, temporary);
        if (this.channelJavaSound != null) {
            this.channelJavaSound.setLooping(toLoop);
        }
        this.positionChanged();
    }

    @Override
    public void listenerMoved() {
        this.positionChanged();
    }

    @Override
    public void setVelocity(float x, float y, float z) {
        super.setVelocity(x, y, z);
        this.positionChanged();
    }

    @Override
    public void setPosition(float x, float y, float z) {
        super.setPosition(x, y, z);
        this.positionChanged();
    }

    @Override
    public void positionChanged() {
        this.calculateGain();
        this.calculatePan();
        this.calculatePitch();
    }

    @Override
    public void setPitch(float value) {
        super.setPitch(value);
        this.calculatePitch();
    }

    @Override
    public void setAttenuation(int model) {
        super.setAttenuation(model);
        this.calculateGain();
    }

    @Override
    public void setDistOrRoll(float dr) {
        super.setDistOrRoll(dr);
        this.calculateGain();
    }

    @Override
    public void play(Channel c) {
        boolean newChannel;
        if (!this.active()) {
            if (this.toLoop) {
                this.toPlay = true;
            }
            return;
        }
        if (c == null) {
            this.errorMessage("Unable to play source, because channel was null");
            return;
        }
        boolean bl = newChannel = this.channel != c;
        if (this.channel != null && this.channel.attachedSource != this) {
            newChannel = true;
        }
        boolean wasPaused = this.paused();
        boolean wasStopped = this.stopped();
        super.play(c);
        this.channelJavaSound = (ChannelJavaSound)this.channel;
        if (newChannel) {
            if (this.channelJavaSound != null) {
                this.channelJavaSound.setLooping(this.toLoop);
            }
            if (!this.toStream) {
                if (this.soundBuffer == null) {
                    this.errorMessage("No sound buffer to play");
                    return;
                }
                this.channelJavaSound.attachBuffer(this.soundBuffer);
            }
        }
        this.positionChanged();
        if (wasStopped || !this.playing()) {
            if (this.toStream && !wasPaused) {
                this.preLoad = true;
            }
            this.channel.play();
        }
    }

    @Override
    public boolean preLoad() {
        if (this.codec == null) {
            return false;
        }
        this.codec.initialize(this.filenameURL.getURL());
        LinkedList<byte[]> preLoadBuffers = new LinkedList<byte[]>();
        for (int i = 0; i < SoundSystemConfig.getNumberStreamingBuffers(); ++i) {
            this.soundBuffer = this.codec.read();
            if (this.soundBuffer == null || this.soundBuffer.audioData == null) break;
            preLoadBuffers.add(this.soundBuffer.audioData);
        }
        this.channelJavaSound.resetStream(this.codec.getAudioFormat());
        this.positionChanged();
        this.channel.preLoadBuffers(preLoadBuffers);
        this.preLoad = false;
        return true;
    }

    public void calculateGain() {
        float distX = this.position.x - this.listener.position.x;
        float distY = this.position.y - this.listener.position.y;
        float distZ = this.position.z - this.listener.position.z;
        this.distanceFromListener = (float)Math.sqrt(distX * distX + distY * distY + distZ * distZ);
        switch (this.attModel) {
            case 2: {
                if (this.distanceFromListener <= 0.0f) {
                    this.gain = 1.0f;
                    break;
                }
                if (this.distanceFromListener >= this.distOrRoll) {
                    this.gain = 0.0f;
                    break;
                }
                this.gain = 1.0f - this.distanceFromListener / this.distOrRoll;
                break;
            }
            case 1: {
                if (this.distanceFromListener <= 0.0f) {
                    this.gain = 1.0f;
                    break;
                }
                float tweakFactor = 5.0E-4f;
                float attenuationFactor = this.distOrRoll * this.distanceFromListener * this.distanceFromListener * tweakFactor;
                if (attenuationFactor < 0.0f) {
                    attenuationFactor = 0.0f;
                }
                this.gain = 1.0f / (1.0f + attenuationFactor);
                break;
            }
            default: {
                this.gain = 1.0f;
            }
        }
        if (this.gain > 1.0f) {
            this.gain = 1.0f;
        }
        if (this.gain < 0.0f) {
            this.gain = 0.0f;
        }
        this.gain *= this.sourceVolume * SoundSystemConfig.getMasterGain() * Math.abs(this.fadeOutGain) * this.fadeInGain;
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            this.channelJavaSound.setGain(this.gain);
        }
    }

    public void calculatePan() {
        Vector3 side = this.listener.up.crs(this.listener.lookAt);
        side.nor();
        Vector3 deltaPosition = this.position.cpy().sub(this.listener.position);
        float x = deltaPosition.dot(side);
        float z = deltaPosition.dot(this.listener.lookAt);
        side = null;
        float angle = (float)Math.atan2(x, z);
        this.pan = (float)(-Math.sin(angle));
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            if (this.attModel == 0) {
                this.channelJavaSound.setPan(0.0f);
            } else {
                this.channelJavaSound.setPan(this.pan);
            }
        }
    }

    public void calculatePitch() {
        if (this.channel != null && this.channel.attachedSource == this && this.channelJavaSound != null) {
            if (SoundSystemConfig.getDopplerFactor() == 0.0f) {
                this.channelJavaSound.setPitch(this.pitch);
            } else {
                float SS = 343.3f;
                Vector3 SV = this.velocity;
                Vector3 LV = this.listener.velocity;
                float DV = SoundSystemConfig.getDopplerVelocity();
                float DF = SoundSystemConfig.getDopplerFactor();
                Vector3 SL = this.listener.position.cpy().sub(this.position);
                float vls = SL.dot(LV) / SL.len();
                float vss = SL.dot(SV) / SL.len();
                vss = this.min(vss, SS / DF);
                float newPitch = this.pitch * (SS * DV - DF * (vls = this.min(vls, SS / DF))) / (SS * DV - DF * vss);
                if (newPitch < 0.5f) {
                    newPitch = 0.5f;
                } else if (newPitch > 2.0f) {
                    newPitch = 2.0f;
                }
                this.channelJavaSound.setPitch(newPitch);
            }
        }
    }

    public float min(float a, float b) {
        if (a < b) {
            return a;
        }
        return b;
    }
}

