/*
 * Decompiled with CFR 0.152.
 */
package com.harium.etyl.loader;

import com.harium.etyl.loader.LoaderImpl;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class FontLoader
extends LoaderImpl {
    public static String DEFAULT_FONT = "Dialog.plain";
    private static FontLoader instance = null;
    private String[] systemFonts;
    protected Map<String, com.harium.etyl.core.graphics.Font> fonts = new HashMap<String, com.harium.etyl.core.graphics.Font>();

    private FontLoader() {
        this.folder = "assets/fonts/";
        this.loadSystemFont(DEFAULT_FONT);
    }

    public static FontLoader getInstance() {
        if (instance == null) {
            instance = new FontLoader();
        }
        return instance;
    }

    public com.harium.etyl.core.graphics.Font getFont(String fontName, float size) {
        com.harium.etyl.core.graphics.Font font = this.loadFont(fontName);
        font.getFont().deriveFont(size);
        return font;
    }

    public com.harium.etyl.core.graphics.Font loadFont(String path, boolean absolute) {
        com.harium.etyl.core.graphics.Font f;
        String fullPath = this.fullPath(path, absolute);
        if (!this.fonts.containsKey(fullPath)) {
            URL dir = null;
            if (!absolute) {
                try {
                    dir = new URL(this.url, fullPath);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            } else {
                if (!fullPath.startsWith("file:///")) {
                    fullPath = "file:///" + fullPath;
                }
                try {
                    dir = new URL(fullPath);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            try {
                Font font = Font.createFont(0, dir.openStream());
                com.harium.etyl.core.graphics.Font f2 = new com.harium.etyl.core.graphics.Font(font);
                this.fonts.put(fullPath, f2);
                return f2;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (FontFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((f = this.fonts.get(fullPath)) != null) {
            return f;
        }
        return this.fonts.get(DEFAULT_FONT);
    }

    public String[] getSystemFonts() {
        return this.systemFonts;
    }

    public void setSystemFonts(String[] systemFonts) {
        this.systemFonts = systemFonts;
    }

    public void disposeFont(String fontName) {
        String fullPath = this.fullPath(fontName, false);
        this.fonts.remove(fullPath);
    }

    public com.harium.etyl.core.graphics.Font loadFont(String path) {
        return this.loadFont(path, false);
    }

    public com.harium.etyl.core.graphics.Font loadSystemFont(String name) {
        Font[] allFonts;
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : allFonts = e.getAllFonts()) {
            if (!name.equals(font.getFontName())) continue;
            com.harium.etyl.core.graphics.Font f = new com.harium.etyl.core.graphics.Font(font);
            this.fonts.put(name, f);
            return f;
        }
        return this.fonts.get(DEFAULT_FONT);
    }
}

