package com.hashicorp.cdktf.providers.google.alloydb_instance;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-17T04:17:38.537Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.alloydbInstance.AlloydbInstanceConfig")
@software.amazon.jsii.Jsii.Proxy(AlloydbInstanceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlloydbInstanceConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Identifies the alloydb cluster. Must be in the format 'projects/{project}/locations/{location}/clusters/{cluster_id}'.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#cluster AlloydbInstance#cluster}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCluster();

    /**
     * The ID of the alloydb instance.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#instance_id AlloydbInstance#instance_id}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceId();

    /**
     * The type of the instance.
     * <p>
     * If the instance type is READ_POOL, provide the associated PRIMARY/SECONDARY instance in the 'depends_on' meta-data attribute.
     * If the instance type is SECONDARY, point to the cluster_type of the associated secondary cluster instead of mentioning SECONDARY.
     * Example: {instance_type = google_alloydb_cluster.<secondary_cluster_name>.cluster_type} instead of {instance_type = SECONDARY}
     * If the instance type is SECONDARY, the terraform delete instance operation does not delete the secondary instance but abandons it instead.
     * Use deletion_policy = "FORCE" in the associated secondary cluster and delete the cluster forcefully to delete the secondary cluster as well its associated secondary instance.
     * Users can undo the delete secondary instance action by importing the deleted secondary instance by calling terraform import. Possible values: ["PRIMARY", "READ_POOL", "SECONDARY"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#instance_type AlloydbInstance#instance_type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
     * <p>
     * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
     * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#annotations AlloydbInstance#annotations}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
        return null;
    }

    /**
     * 'Availability type of an Instance.
     * <p>
     * Defaults to REGIONAL for both primary and read instances.
     * Note that primary and read instances can have different availability types.
     * Only READ_POOL instance supports ZONAL type. Users can't specify the zone for READ_POOL instance.
     * Zone is automatically chosen from the list of zones in the region specified.
     * Read pool of size 1 can only have zonal availability. Read pools with node count of 2 or more
     * can have regional availability (nodes are present in 2 or more zones in a region).' Possible values: ["AVAILABILITY_TYPE_UNSPECIFIED", "ZONAL", "REGIONAL"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#availability_type AlloydbInstance#availability_type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityType() {
        return null;
    }

    /**
     * client_connection_config block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#client_connection_config AlloydbInstance#client_connection_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceClientConnectionConfig getClientConnectionConfig() {
        return null;
    }

    /**
     * Database flags.
     * <p>
     * Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#database_flags AlloydbInstance#database_flags}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDatabaseFlags() {
        return null;
    }

    /**
     * User-settable and human-readable display name for the Instance.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#display_name AlloydbInstance#display_name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#gce_zone AlloydbInstance#gce_zone}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGceZone() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#id AlloydbInstance#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * User-defined labels for the alloydb instance.
     * <p>
     * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
     * Please refer to the field 'effective_labels' for all of the labels present on the resource.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#labels AlloydbInstance#labels}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * machine_config block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#machine_config AlloydbInstance#machine_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceMachineConfig getMachineConfig() {
        return null;
    }

    /**
     * query_insights_config block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#query_insights_config AlloydbInstance#query_insights_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceQueryInsightsConfig getQueryInsightsConfig() {
        return null;
    }

    /**
     * read_pool_config block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#read_pool_config AlloydbInstance#read_pool_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceReadPoolConfig getReadPoolConfig() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#timeouts AlloydbInstance#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AlloydbInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlloydbInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlloydbInstanceConfig> {
        java.lang.String cluster;
        java.lang.String instanceId;
        java.lang.String instanceType;
        java.util.Map<java.lang.String, java.lang.String> annotations;
        java.lang.String availabilityType;
        com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceClientConnectionConfig clientConnectionConfig;
        java.util.Map<java.lang.String, java.lang.String> databaseFlags;
        java.lang.String displayName;
        java.lang.String gceZone;
        java.lang.String id;
        java.util.Map<java.lang.String, java.lang.String> labels;
        com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceMachineConfig machineConfig;
        com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceQueryInsightsConfig queryInsightsConfig;
        com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceReadPoolConfig readPoolConfig;
        com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Object count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getCluster}
         * @param cluster Identifies the alloydb cluster. Must be in the format 'projects/{project}/locations/{location}/clusters/{cluster_id}'. This parameter is required.
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#cluster AlloydbInstance#cluster}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(java.lang.String cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getInstanceId}
         * @param instanceId The ID of the alloydb instance. This parameter is required.
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#instance_id AlloydbInstance#instance_id}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getInstanceType}
         * @param instanceType The type of the instance. This parameter is required.
         *                     If the instance type is READ_POOL, provide the associated PRIMARY/SECONDARY instance in the 'depends_on' meta-data attribute.
         *                     If the instance type is SECONDARY, point to the cluster_type of the associated secondary cluster instead of mentioning SECONDARY.
         *                     Example: {instance_type = google_alloydb_cluster.<secondary_cluster_name>.cluster_type} instead of {instance_type = SECONDARY}
         *                     If the instance type is SECONDARY, the terraform delete instance operation does not delete the secondary instance but abandons it instead.
         *                     Use deletion_policy = "FORCE" in the associated secondary cluster and delete the cluster forcefully to delete the secondary cluster as well its associated secondary instance.
         *                     Users can undo the delete secondary instance action by importing the deleted secondary instance by calling terraform import. Possible values: ["PRIMARY", "READ_POOL", "SECONDARY"]
         *                     
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#instance_type AlloydbInstance#instance_type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getAnnotations}
         * @param annotations Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
         *                    **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
         *                    Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
         *                    
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#annotations AlloydbInstance#annotations}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder annotations(java.util.Map<java.lang.String, java.lang.String> annotations) {
            this.annotations = annotations;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getAvailabilityType}
         * @param availabilityType 'Availability type of an Instance.
         *                         Defaults to REGIONAL for both primary and read instances.
         *                         Note that primary and read instances can have different availability types.
         *                         Only READ_POOL instance supports ZONAL type. Users can't specify the zone for READ_POOL instance.
         *                         Zone is automatically chosen from the list of zones in the region specified.
         *                         Read pool of size 1 can only have zonal availability. Read pools with node count of 2 or more
         *                         can have regional availability (nodes are present in 2 or more zones in a region).' Possible values: ["AVAILABILITY_TYPE_UNSPECIFIED", "ZONAL", "REGIONAL"]
         *                         
         *                         Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#availability_type AlloydbInstance#availability_type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityType(java.lang.String availabilityType) {
            this.availabilityType = availabilityType;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getClientConnectionConfig}
         * @param clientConnectionConfig client_connection_config block.
         *                               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#client_connection_config AlloydbInstance#client_connection_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientConnectionConfig(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceClientConnectionConfig clientConnectionConfig) {
            this.clientConnectionConfig = clientConnectionConfig;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getDatabaseFlags}
         * @param databaseFlags Database flags.
         *                      Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
         *                      
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#database_flags AlloydbInstance#database_flags}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseFlags(java.util.Map<java.lang.String, java.lang.String> databaseFlags) {
            this.databaseFlags = databaseFlags;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getDisplayName}
         * @param displayName User-settable and human-readable display name for the Instance.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#display_name AlloydbInstance#display_name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getGceZone}
         * @param gceZone The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#gce_zone AlloydbInstance#gce_zone}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gceZone(java.lang.String gceZone) {
            this.gceZone = gceZone;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#id AlloydbInstance#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getLabels}
         * @param labels User-defined labels for the alloydb instance.
         *               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
         *               Please refer to the field 'effective_labels' for all of the labels present on the resource.
         *               
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#labels AlloydbInstance#labels}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getMachineConfig}
         * @param machineConfig machine_config block.
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#machine_config AlloydbInstance#machine_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineConfig(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceMachineConfig machineConfig) {
            this.machineConfig = machineConfig;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getQueryInsightsConfig}
         * @param queryInsightsConfig query_insights_config block.
         *                            Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#query_insights_config AlloydbInstance#query_insights_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryInsightsConfig(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceQueryInsightsConfig queryInsightsConfig) {
            this.queryInsightsConfig = queryInsightsConfig;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getReadPoolConfig}
         * @param readPoolConfig read_pool_config block.
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#read_pool_config AlloydbInstance#read_pool_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readPoolConfig(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceReadPoolConfig readPoolConfig) {
            this.readPoolConfig = readPoolConfig;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/alloydb_instance#timeouts AlloydbInstance#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(com.hashicorp.cdktf.TerraformCount count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link AlloydbInstanceConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlloydbInstanceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlloydbInstanceConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlloydbInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlloydbInstanceConfig {
        private final java.lang.String cluster;
        private final java.lang.String instanceId;
        private final java.lang.String instanceType;
        private final java.util.Map<java.lang.String, java.lang.String> annotations;
        private final java.lang.String availabilityType;
        private final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceClientConnectionConfig clientConnectionConfig;
        private final java.util.Map<java.lang.String, java.lang.String> databaseFlags;
        private final java.lang.String displayName;
        private final java.lang.String gceZone;
        private final java.lang.String id;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceMachineConfig machineConfig;
        private final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceQueryInsightsConfig queryInsightsConfig;
        private final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceReadPoolConfig readPoolConfig;
        private final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Object count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.annotations = software.amazon.jsii.Kernel.get(this, "annotations", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.availabilityType = software.amazon.jsii.Kernel.get(this, "availabilityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientConnectionConfig = software.amazon.jsii.Kernel.get(this, "clientConnectionConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceClientConnectionConfig.class));
            this.databaseFlags = software.amazon.jsii.Kernel.get(this, "databaseFlags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gceZone = software.amazon.jsii.Kernel.get(this, "gceZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.machineConfig = software.amazon.jsii.Kernel.get(this, "machineConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceMachineConfig.class));
            this.queryInsightsConfig = software.amazon.jsii.Kernel.get(this, "queryInsightsConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceQueryInsightsConfig.class));
            this.readPoolConfig = software.amazon.jsii.Kernel.get(this, "readPoolConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceReadPoolConfig.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.instanceId = java.util.Objects.requireNonNull(builder.instanceId, "instanceId is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.annotations = builder.annotations;
            this.availabilityType = builder.availabilityType;
            this.clientConnectionConfig = builder.clientConnectionConfig;
            this.databaseFlags = builder.databaseFlags;
            this.displayName = builder.displayName;
            this.gceZone = builder.gceZone;
            this.id = builder.id;
            this.labels = builder.labels;
            this.machineConfig = builder.machineConfig;
            this.queryInsightsConfig = builder.queryInsightsConfig;
            this.readPoolConfig = builder.readPoolConfig;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
            return this.annotations;
        }

        @Override
        public final java.lang.String getAvailabilityType() {
            return this.availabilityType;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceClientConnectionConfig getClientConnectionConfig() {
            return this.clientConnectionConfig;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDatabaseFlags() {
            return this.databaseFlags;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getGceZone() {
            return this.gceZone;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceMachineConfig getMachineConfig() {
            return this.machineConfig;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceQueryInsightsConfig getQueryInsightsConfig() {
            return this.queryInsightsConfig;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceReadPoolConfig getReadPoolConfig() {
            return this.readPoolConfig;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.alloydb_instance.AlloydbInstanceTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Object getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("instanceId", om.valueToTree(this.getInstanceId()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAnnotations() != null) {
                data.set("annotations", om.valueToTree(this.getAnnotations()));
            }
            if (this.getAvailabilityType() != null) {
                data.set("availabilityType", om.valueToTree(this.getAvailabilityType()));
            }
            if (this.getClientConnectionConfig() != null) {
                data.set("clientConnectionConfig", om.valueToTree(this.getClientConnectionConfig()));
            }
            if (this.getDatabaseFlags() != null) {
                data.set("databaseFlags", om.valueToTree(this.getDatabaseFlags()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getGceZone() != null) {
                data.set("gceZone", om.valueToTree(this.getGceZone()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getMachineConfig() != null) {
                data.set("machineConfig", om.valueToTree(this.getMachineConfig()));
            }
            if (this.getQueryInsightsConfig() != null) {
                data.set("queryInsightsConfig", om.valueToTree(this.getQueryInsightsConfig()));
            }
            if (this.getReadPoolConfig() != null) {
                data.set("readPoolConfig", om.valueToTree(this.getReadPoolConfig()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.alloydbInstance.AlloydbInstanceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlloydbInstanceConfig.Jsii$Proxy that = (AlloydbInstanceConfig.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!instanceId.equals(that.instanceId)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) return false;
            if (this.availabilityType != null ? !this.availabilityType.equals(that.availabilityType) : that.availabilityType != null) return false;
            if (this.clientConnectionConfig != null ? !this.clientConnectionConfig.equals(that.clientConnectionConfig) : that.clientConnectionConfig != null) return false;
            if (this.databaseFlags != null ? !this.databaseFlags.equals(that.databaseFlags) : that.databaseFlags != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.gceZone != null ? !this.gceZone.equals(that.gceZone) : that.gceZone != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.machineConfig != null ? !this.machineConfig.equals(that.machineConfig) : that.machineConfig != null) return false;
            if (this.queryInsightsConfig != null ? !this.queryInsightsConfig.equals(that.queryInsightsConfig) : that.queryInsightsConfig != null) return false;
            if (this.readPoolConfig != null ? !this.readPoolConfig.equals(that.readPoolConfig) : that.readPoolConfig != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.instanceId.hashCode());
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
            result = 31 * result + (this.availabilityType != null ? this.availabilityType.hashCode() : 0);
            result = 31 * result + (this.clientConnectionConfig != null ? this.clientConnectionConfig.hashCode() : 0);
            result = 31 * result + (this.databaseFlags != null ? this.databaseFlags.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.gceZone != null ? this.gceZone.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.machineConfig != null ? this.machineConfig.hashCode() : 0);
            result = 31 * result + (this.queryInsightsConfig != null ? this.queryInsightsConfig.hashCode() : 0);
            result = 31 * result + (this.readPoolConfig != null ? this.readPoolConfig.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
