package com.hashicorp.cdktf.providers.google.compute_backend_service;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-17T04:17:39.371Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.computeBackendService.ComputeBackendServiceBackend")
@software.amazon.jsii.Jsii.Proxy(ComputeBackendServiceBackend.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeBackendServiceBackend extends software.amazon.jsii.JsiiSerializable {

    /**
     * The fully-qualified URL of an Instance Group or Network Endpoint Group resource.
     * <p>
     * In case of instance group this defines the list
     * of instances that serve traffic. Member virtual machine
     * instances from each instance group must live in the same zone as
     * the instance group itself. No two backends in a backend service
     * are allowed to use same Instance Group resource.
     * For Network Endpoint Groups this defines list of endpoints. All
     * endpoints of Network Endpoint Group must be hosted on instances
     * located in the same zone as the Network Endpoint Group.
     * Backend services cannot mix Instance Group and
     * Network Endpoint Group backends.
     * Note that you must specify an Instance Group or Network Endpoint
     * Group resource using the fully-qualified URL, rather than a
     * partial URL.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#group ComputeBackendService#group}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroup();

    /**
     * Specifies the balancing mode for this backend.
     * <p>
     * For global HTTP(S) or TCP/SSL load balancing, the default is
     * UTILIZATION. Valid values are UTILIZATION, RATE (for HTTP(S))
     * and CONNECTION (for TCP/SSL).
     * See the [Backend Services Overview](https://cloud.google.com/load-balancing/docs/backend-service#balancing-mode)
     * for an explanation of load balancing modes. Default value: "UTILIZATION" Possible values: ["UTILIZATION", "RATE", "CONNECTION"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#balancing_mode ComputeBackendService#balancing_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBalancingMode() {
        return null;
    }

    /**
     * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION).
     * <p>
     * Default value is 1, which means the group will serve up to 100%
     * of its configured capacity (depending on balancingMode). A
     * setting of 0 means the group is completely drained, offering
     * 0% of its available Capacity. Valid range is [0.0,1.0].
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#capacity_scaler ComputeBackendService#capacity_scaler}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCapacityScaler() {
        return null;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#description ComputeBackendService#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The max number of simultaneous connections for the group. Can be used with either CONNECTION or UTILIZATION balancing modes.
     * <p>
     * For CONNECTION mode, either maxConnections or one
     * of maxConnectionsPerInstance or maxConnectionsPerEndpoint,
     * as appropriate for group type, must be set.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_connections ComputeBackendService#max_connections}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConnections() {
        return null;
    }

    /**
     * The max number of simultaneous connections that a single backend network endpoint can handle.
     * <p>
     * This is used to calculate the
     * capacity of the group. Can be used in either CONNECTION or
     * UTILIZATION balancing modes.
     * For CONNECTION mode, either
     * maxConnections or maxConnectionsPerEndpoint must be set.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_connections_per_endpoint ComputeBackendService#max_connections_per_endpoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConnectionsPerEndpoint() {
        return null;
    }

    /**
     * The max number of simultaneous connections that a single backend instance can handle.
     * <p>
     * This is used to calculate the
     * capacity of the group. Can be used in either CONNECTION or
     * UTILIZATION balancing modes.
     * For CONNECTION mode, either maxConnections or
     * maxConnectionsPerInstance must be set.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_connections_per_instance ComputeBackendService#max_connections_per_instance}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConnectionsPerInstance() {
        return null;
    }

    /**
     * The max requests per second (RPS) of the group.
     * <p>
     * Can be used with either RATE or UTILIZATION balancing modes,
     * but required if RATE mode. For RATE mode, either maxRate or one
     * of maxRatePerInstance or maxRatePerEndpoint, as appropriate for
     * group type, must be set.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_rate ComputeBackendService#max_rate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRate() {
        return null;
    }

    /**
     * The max requests per second (RPS) that a single backend network endpoint can handle.
     * <p>
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerEndpoint must be set.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_rate_per_endpoint ComputeBackendService#max_rate_per_endpoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRatePerEndpoint() {
        return null;
    }

    /**
     * The max requests per second (RPS) that a single backend instance can handle.
     * <p>
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerInstance must be set.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_rate_per_instance ComputeBackendService#max_rate_per_instance}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRatePerInstance() {
        return null;
    }

    /**
     * Used when balancingMode is UTILIZATION. This ratio defines the CPU utilization target for the group. Valid range is [0.0, 1.0].
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_utilization ComputeBackendService#max_utilization}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxUtilization() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeBackendServiceBackend}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeBackendServiceBackend}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeBackendServiceBackend> {
        java.lang.String group;
        java.lang.String balancingMode;
        java.lang.Number capacityScaler;
        java.lang.String description;
        java.lang.Number maxConnections;
        java.lang.Number maxConnectionsPerEndpoint;
        java.lang.Number maxConnectionsPerInstance;
        java.lang.Number maxRate;
        java.lang.Number maxRatePerEndpoint;
        java.lang.Number maxRatePerInstance;
        java.lang.Number maxUtilization;

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getGroup}
         * @param group The fully-qualified URL of an Instance Group or Network Endpoint Group resource. This parameter is required.
         *              In case of instance group this defines the list
         *              of instances that serve traffic. Member virtual machine
         *              instances from each instance group must live in the same zone as
         *              the instance group itself. No two backends in a backend service
         *              are allowed to use same Instance Group resource.
         *              
         *              For Network Endpoint Groups this defines list of endpoints. All
         *              endpoints of Network Endpoint Group must be hosted on instances
         *              located in the same zone as the Network Endpoint Group.
         *              
         *              Backend services cannot mix Instance Group and
         *              Network Endpoint Group backends.
         *              
         *              Note that you must specify an Instance Group or Network Endpoint
         *              Group resource using the fully-qualified URL, rather than a
         *              partial URL.
         *              
         *              Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#group ComputeBackendService#group}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder group(java.lang.String group) {
            this.group = group;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getBalancingMode}
         * @param balancingMode Specifies the balancing mode for this backend.
         *                      For global HTTP(S) or TCP/SSL load balancing, the default is
         *                      UTILIZATION. Valid values are UTILIZATION, RATE (for HTTP(S))
         *                      and CONNECTION (for TCP/SSL).
         *                      
         *                      See the [Backend Services Overview](https://cloud.google.com/load-balancing/docs/backend-service#balancing-mode)
         *                      for an explanation of load balancing modes. Default value: "UTILIZATION" Possible values: ["UTILIZATION", "RATE", "CONNECTION"]
         *                      
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#balancing_mode ComputeBackendService#balancing_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder balancingMode(java.lang.String balancingMode) {
            this.balancingMode = balancingMode;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getCapacityScaler}
         * @param capacityScaler A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION).
         *                       Default value is 1, which means the group will serve up to 100%
         *                       of its configured capacity (depending on balancingMode). A
         *                       setting of 0 means the group is completely drained, offering
         *                       0% of its available Capacity. Valid range is [0.0,1.0].
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#capacity_scaler ComputeBackendService#capacity_scaler}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityScaler(java.lang.Number capacityScaler) {
            this.capacityScaler = capacityScaler;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getDescription}
         * @param description An optional description of this resource. Provide this property when you create the resource.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#description ComputeBackendService#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getMaxConnections}
         * @param maxConnections The max number of simultaneous connections for the group. Can be used with either CONNECTION or UTILIZATION balancing modes.
         *                       For CONNECTION mode, either maxConnections or one
         *                       of maxConnectionsPerInstance or maxConnectionsPerEndpoint,
         *                       as appropriate for group type, must be set.
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_connections ComputeBackendService#max_connections}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConnections(java.lang.Number maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getMaxConnectionsPerEndpoint}
         * @param maxConnectionsPerEndpoint The max number of simultaneous connections that a single backend network endpoint can handle.
         *                                  This is used to calculate the
         *                                  capacity of the group. Can be used in either CONNECTION or
         *                                  UTILIZATION balancing modes.
         *                                  
         *                                  For CONNECTION mode, either
         *                                  maxConnections or maxConnectionsPerEndpoint must be set.
         *                                  
         *                                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_connections_per_endpoint ComputeBackendService#max_connections_per_endpoint}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConnectionsPerEndpoint(java.lang.Number maxConnectionsPerEndpoint) {
            this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getMaxConnectionsPerInstance}
         * @param maxConnectionsPerInstance The max number of simultaneous connections that a single backend instance can handle.
         *                                  This is used to calculate the
         *                                  capacity of the group. Can be used in either CONNECTION or
         *                                  UTILIZATION balancing modes.
         *                                  
         *                                  For CONNECTION mode, either maxConnections or
         *                                  maxConnectionsPerInstance must be set.
         *                                  
         *                                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_connections_per_instance ComputeBackendService#max_connections_per_instance}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConnectionsPerInstance(java.lang.Number maxConnectionsPerInstance) {
            this.maxConnectionsPerInstance = maxConnectionsPerInstance;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getMaxRate}
         * @param maxRate The max requests per second (RPS) of the group.
         *                Can be used with either RATE or UTILIZATION balancing modes,
         *                but required if RATE mode. For RATE mode, either maxRate or one
         *                of maxRatePerInstance or maxRatePerEndpoint, as appropriate for
         *                group type, must be set.
         *                
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_rate ComputeBackendService#max_rate}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRate(java.lang.Number maxRate) {
            this.maxRate = maxRate;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getMaxRatePerEndpoint}
         * @param maxRatePerEndpoint The max requests per second (RPS) that a single backend network endpoint can handle.
         *                           This is used to calculate the capacity of
         *                           the group. Can be used in either balancing mode. For RATE mode,
         *                           either maxRate or maxRatePerEndpoint must be set.
         *                           
         *                           Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_rate_per_endpoint ComputeBackendService#max_rate_per_endpoint}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRatePerEndpoint(java.lang.Number maxRatePerEndpoint) {
            this.maxRatePerEndpoint = maxRatePerEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getMaxRatePerInstance}
         * @param maxRatePerInstance The max requests per second (RPS) that a single backend instance can handle.
         *                           This is used to calculate the capacity of
         *                           the group. Can be used in either balancing mode. For RATE mode,
         *                           either maxRate or maxRatePerInstance must be set.
         *                           
         *                           Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_rate_per_instance ComputeBackendService#max_rate_per_instance}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRatePerInstance(java.lang.Number maxRatePerInstance) {
            this.maxRatePerInstance = maxRatePerInstance;
            return this;
        }

        /**
         * Sets the value of {@link ComputeBackendServiceBackend#getMaxUtilization}
         * @param maxUtilization Used when balancingMode is UTILIZATION. This ratio defines the CPU utilization target for the group. Valid range is [0.0, 1.0].
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_backend_service#max_utilization ComputeBackendService#max_utilization}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUtilization(java.lang.Number maxUtilization) {
            this.maxUtilization = maxUtilization;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeBackendServiceBackend}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeBackendServiceBackend build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeBackendServiceBackend}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeBackendServiceBackend {
        private final java.lang.String group;
        private final java.lang.String balancingMode;
        private final java.lang.Number capacityScaler;
        private final java.lang.String description;
        private final java.lang.Number maxConnections;
        private final java.lang.Number maxConnectionsPerEndpoint;
        private final java.lang.Number maxConnectionsPerInstance;
        private final java.lang.Number maxRate;
        private final java.lang.Number maxRatePerEndpoint;
        private final java.lang.Number maxRatePerInstance;
        private final java.lang.Number maxUtilization;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.balancingMode = software.amazon.jsii.Kernel.get(this, "balancingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.capacityScaler = software.amazon.jsii.Kernel.get(this, "capacityScaler", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConnections = software.amazon.jsii.Kernel.get(this, "maxConnections", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxConnectionsPerEndpoint = software.amazon.jsii.Kernel.get(this, "maxConnectionsPerEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxConnectionsPerInstance = software.amazon.jsii.Kernel.get(this, "maxConnectionsPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRate = software.amazon.jsii.Kernel.get(this, "maxRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRatePerEndpoint = software.amazon.jsii.Kernel.get(this, "maxRatePerEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRatePerInstance = software.amazon.jsii.Kernel.get(this, "maxRatePerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxUtilization = software.amazon.jsii.Kernel.get(this, "maxUtilization", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.group = java.util.Objects.requireNonNull(builder.group, "group is required");
            this.balancingMode = builder.balancingMode;
            this.capacityScaler = builder.capacityScaler;
            this.description = builder.description;
            this.maxConnections = builder.maxConnections;
            this.maxConnectionsPerEndpoint = builder.maxConnectionsPerEndpoint;
            this.maxConnectionsPerInstance = builder.maxConnectionsPerInstance;
            this.maxRate = builder.maxRate;
            this.maxRatePerEndpoint = builder.maxRatePerEndpoint;
            this.maxRatePerInstance = builder.maxRatePerInstance;
            this.maxUtilization = builder.maxUtilization;
        }

        @Override
        public final java.lang.String getGroup() {
            return this.group;
        }

        @Override
        public final java.lang.String getBalancingMode() {
            return this.balancingMode;
        }

        @Override
        public final java.lang.Number getCapacityScaler() {
            return this.capacityScaler;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getMaxConnections() {
            return this.maxConnections;
        }

        @Override
        public final java.lang.Number getMaxConnectionsPerEndpoint() {
            return this.maxConnectionsPerEndpoint;
        }

        @Override
        public final java.lang.Number getMaxConnectionsPerInstance() {
            return this.maxConnectionsPerInstance;
        }

        @Override
        public final java.lang.Number getMaxRate() {
            return this.maxRate;
        }

        @Override
        public final java.lang.Number getMaxRatePerEndpoint() {
            return this.maxRatePerEndpoint;
        }

        @Override
        public final java.lang.Number getMaxRatePerInstance() {
            return this.maxRatePerInstance;
        }

        @Override
        public final java.lang.Number getMaxUtilization() {
            return this.maxUtilization;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("group", om.valueToTree(this.getGroup()));
            if (this.getBalancingMode() != null) {
                data.set("balancingMode", om.valueToTree(this.getBalancingMode()));
            }
            if (this.getCapacityScaler() != null) {
                data.set("capacityScaler", om.valueToTree(this.getCapacityScaler()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMaxConnections() != null) {
                data.set("maxConnections", om.valueToTree(this.getMaxConnections()));
            }
            if (this.getMaxConnectionsPerEndpoint() != null) {
                data.set("maxConnectionsPerEndpoint", om.valueToTree(this.getMaxConnectionsPerEndpoint()));
            }
            if (this.getMaxConnectionsPerInstance() != null) {
                data.set("maxConnectionsPerInstance", om.valueToTree(this.getMaxConnectionsPerInstance()));
            }
            if (this.getMaxRate() != null) {
                data.set("maxRate", om.valueToTree(this.getMaxRate()));
            }
            if (this.getMaxRatePerEndpoint() != null) {
                data.set("maxRatePerEndpoint", om.valueToTree(this.getMaxRatePerEndpoint()));
            }
            if (this.getMaxRatePerInstance() != null) {
                data.set("maxRatePerInstance", om.valueToTree(this.getMaxRatePerInstance()));
            }
            if (this.getMaxUtilization() != null) {
                data.set("maxUtilization", om.valueToTree(this.getMaxUtilization()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.computeBackendService.ComputeBackendServiceBackend"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeBackendServiceBackend.Jsii$Proxy that = (ComputeBackendServiceBackend.Jsii$Proxy) o;

            if (!group.equals(that.group)) return false;
            if (this.balancingMode != null ? !this.balancingMode.equals(that.balancingMode) : that.balancingMode != null) return false;
            if (this.capacityScaler != null ? !this.capacityScaler.equals(that.capacityScaler) : that.capacityScaler != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.maxConnections != null ? !this.maxConnections.equals(that.maxConnections) : that.maxConnections != null) return false;
            if (this.maxConnectionsPerEndpoint != null ? !this.maxConnectionsPerEndpoint.equals(that.maxConnectionsPerEndpoint) : that.maxConnectionsPerEndpoint != null) return false;
            if (this.maxConnectionsPerInstance != null ? !this.maxConnectionsPerInstance.equals(that.maxConnectionsPerInstance) : that.maxConnectionsPerInstance != null) return false;
            if (this.maxRate != null ? !this.maxRate.equals(that.maxRate) : that.maxRate != null) return false;
            if (this.maxRatePerEndpoint != null ? !this.maxRatePerEndpoint.equals(that.maxRatePerEndpoint) : that.maxRatePerEndpoint != null) return false;
            if (this.maxRatePerInstance != null ? !this.maxRatePerInstance.equals(that.maxRatePerInstance) : that.maxRatePerInstance != null) return false;
            return this.maxUtilization != null ? this.maxUtilization.equals(that.maxUtilization) : that.maxUtilization == null;
        }

        @Override
        public final int hashCode() {
            int result = this.group.hashCode();
            result = 31 * result + (this.balancingMode != null ? this.balancingMode.hashCode() : 0);
            result = 31 * result + (this.capacityScaler != null ? this.capacityScaler.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.maxConnections != null ? this.maxConnections.hashCode() : 0);
            result = 31 * result + (this.maxConnectionsPerEndpoint != null ? this.maxConnectionsPerEndpoint.hashCode() : 0);
            result = 31 * result + (this.maxConnectionsPerInstance != null ? this.maxConnectionsPerInstance.hashCode() : 0);
            result = 31 * result + (this.maxRate != null ? this.maxRate.hashCode() : 0);
            result = 31 * result + (this.maxRatePerEndpoint != null ? this.maxRatePerEndpoint.hashCode() : 0);
            result = 31 * result + (this.maxRatePerInstance != null ? this.maxRatePerInstance.hashCode() : 0);
            result = 31 * result + (this.maxUtilization != null ? this.maxUtilization.hashCode() : 0);
            return result;
        }
    }
}
