package com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-17T04:17:39.456Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.computeGlobalForwardingRule.ComputeGlobalForwardingRuleConfig")
@software.amazon.jsii.Jsii.Proxy(ComputeGlobalForwardingRuleConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeGlobalForwardingRuleConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Name of the resource;
     * <p>
     * provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression '[a-z](%5B-a-z0-9%5D*%5Ba-z0-9%5D)?' which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     * For Private Service Connect forwarding rules that forward traffic to Google
     * APIs, the forwarding rule name must be a 1-20 characters string with
     * lowercase letters and numbers and must start with a letter.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#name ComputeGlobalForwardingRule#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The URL of the target resource to receive the matched traffic.
     * <p>
     * For
     * regional forwarding rules, this target must be in the same region as the
     * forwarding rule. For global forwarding rules, this target must be a global
     * load balancing resource.
     * The forwarded traffic must be of a type appropriate to the target object.
     * * For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     * * For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
     * * 'vpc-sc' - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
     * * 'all-apis' - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
     * For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#target ComputeGlobalForwardingRule#target}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTarget();

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#description ComputeGlobalForwardingRule#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#id ComputeGlobalForwardingRule#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * IP address for which this forwarding rule accepts traffic.
     * <p>
     * When a client
     * sends traffic to this IP address, the forwarding rule directs the traffic
     * to the referenced 'target'.
     * While creating a forwarding rule, specifying an 'IPAddress' is
     * required under the following circumstances:
     * * When the 'target' is set to 'targetGrpcProxy' and
     *   'validateForProxyless' is set to 'true', the
     *   'IPAddress' should be set to '0.0.0.0'.
     * * When the 'target' is a Private Service Connect Google APIs
     *   bundle, you must specify an 'IPAddress'.
     * Otherwise, you can optionally specify an IP address that references an
     * existing static (reserved) IP address resource. When omitted, Google Cloud
     * assigns an ephemeral IP address.
     * Use one of the following formats to specify an IP address while creating a
     * forwarding rule:
     * * IP address number, as in '100.1.2.3'
     * * IPv6 address range, as in '2600:1234::/96'
     * * Full resource URL, as in
     *   'https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name'
     * * Partial URL or by name, as in:
     *   * 'projects/project_id/regions/region/addresses/address-name'
     *   * 'regions/region/addresses/address-name'
     *   * 'global/addresses/address-name'
     *   * 'address-name'
     * The forwarding rule's 'target',
     * and in most cases, also the 'loadBalancingScheme', determine the
     * type of IP address that you can use. For detailed information, see
     * [IP address
     * specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     * When reading an 'IPAddress', the API always returns the IP
     * address number.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#ip_address ComputeGlobalForwardingRule#ip_address}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
        return null;
    }

    /**
     * The IP protocol to which this rule applies.
     * <p>
     * For protocol forwarding, valid
     * options are 'TCP', 'UDP', 'ESP',
     * 'AH', 'SCTP', 'ICMP' and
     * 'L3_DEFAULT'.
     * The valid IP protocols are different for different load balancing products
     * as described in [Load balancing
     * features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends). Possible values: ["TCP", "UDP", "ESP", "AH", "SCTP", "ICMP"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#ip_protocol ComputeGlobalForwardingRule#ip_protocol}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpProtocol() {
        return null;
    }

    /**
     * The IP Version that will be used by this global forwarding rule. Possible values: ["IPV4", "IPV6"].
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#ip_version ComputeGlobalForwardingRule#ip_version}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpVersion() {
        return null;
    }

    /**
     * Labels to apply to this forwarding rule.  A list of key-&gt;value pairs.
     * <p>
     * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
     * Please refer to the field 'effective_labels' for all of the labels present on the resource.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#labels ComputeGlobalForwardingRule#labels}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * Specifies the forwarding rule type.
     * <p>
     * For more information about forwarding rules, refer to
     * [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts). Default value: "EXTERNAL" Possible values: ["EXTERNAL", "EXTERNAL_MANAGED", "INTERNAL_MANAGED", "INTERNAL_SELF_MANAGED"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#load_balancing_scheme ComputeGlobalForwardingRule#load_balancing_scheme}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancingScheme() {
        return null;
    }

    /**
     * metadata_filters block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#metadata_filters ComputeGlobalForwardingRule#metadata_filters}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataFilters() {
        return null;
    }

    /**
     * This field is not used for external load balancing.
     * <p>
     * For Internal TCP/UDP Load Balancing, this field identifies the network that
     * the load balanced IP should belong to for this Forwarding Rule.
     * If the subnetwork is specified, the network of the subnetwork will be used.
     * If neither subnetwork nor this field is specified, the default network will
     * be used.
     * For Private Service Connect forwarding rules that forward traffic to Google
     * APIs, a network must be provided.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#network ComputeGlobalForwardingRule#network}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetwork() {
        return null;
    }

    /**
     * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not.
     * <p>
     * Non-PSC forwarding rules do not use this field.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#no_automate_dns_zone ComputeGlobalForwardingRule#no_automate_dns_zone}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNoAutomateDnsZone() {
        return null;
    }

    /**
     * The 'portRange' field has the following limitations: * It requires that the forwarding rule 'IPProtocol' be TCP, UDP, or SCTP, and * It's applicable only to the following products: external passthrough Network Load Balancers, internal and external proxy Network Load Balancers, internal and external Application Load Balancers, external protocol forwarding, and Classic VPN.
     * <p>
     * <ul>
     * <li>Some products have restrictions on what ports can be used. See
     * <a href="https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications">port specifications</a>
     * for details.</li>
     * </ul>
     * <p>
     * For external forwarding rules, two or more forwarding rules cannot use the
     * same '[IPAddress, IPProtocol]' pair, and cannot have overlapping
     * 'portRange's.
     * <p>
     * For internal forwarding rules within the same VPC network, two or more
     * forwarding rules cannot use the same '[IPAddress, IPProtocol]' pair, and
     * cannot have overlapping 'portRange's.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPortRange() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#project ComputeGlobalForwardingRule#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * service_directory_registrations block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#service_directory_registrations ComputeGlobalForwardingRule#service_directory_registrations}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleServiceDirectoryRegistrations getServiceDirectoryRegistrations() {
        return null;
    }

    /**
     * If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here.
     * <p>
     * Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#source_ip_ranges ComputeGlobalForwardingRule#source_ip_ranges}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceIpRanges() {
        return null;
    }

    /**
     * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6.
     * <p>
     * If the network specified is in auto subnet mode, this field is optional.
     * However, a subnetwork must be specified if the network is in custom subnet
     * mode or when creating external forwarding rule with IPv6.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#subnetwork ComputeGlobalForwardingRule#subnetwork}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetwork() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#timeouts ComputeGlobalForwardingRule#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeGlobalForwardingRuleConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeGlobalForwardingRuleConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeGlobalForwardingRuleConfig> {
        java.lang.String name;
        java.lang.String target;
        java.lang.String description;
        java.lang.String id;
        java.lang.String ipAddress;
        java.lang.String ipProtocol;
        java.lang.String ipVersion;
        java.util.Map<java.lang.String, java.lang.String> labels;
        java.lang.String loadBalancingScheme;
        java.lang.Object metadataFilters;
        java.lang.String network;
        java.lang.Object noAutomateDnsZone;
        java.lang.String portRange;
        java.lang.String project;
        com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleServiceDirectoryRegistrations serviceDirectoryRegistrations;
        java.util.List<java.lang.String> sourceIpRanges;
        java.lang.String subnetwork;
        com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Object count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getName}
         * @param name Name of the resource;. This parameter is required.
         *             provided by the client when the resource is created.
         *             The name must be 1-63 characters long, and comply with
         *             [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
         *             
         *             Specifically, the name must be 1-63 characters long and match the regular
         *             expression '[a-z](%5B-a-z0-9%5D*%5Ba-z0-9%5D)?' which means the first
         *             character must be a lowercase letter, and all following characters must
         *             be a dash, lowercase letter, or digit, except the last character, which
         *             cannot be a dash.
         *             
         *             For Private Service Connect forwarding rules that forward traffic to Google
         *             APIs, the forwarding rule name must be a 1-20 characters string with
         *             lowercase letters and numbers and must start with a letter.
         *             
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#name ComputeGlobalForwardingRule#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getTarget}
         * @param target The URL of the target resource to receive the matched traffic. This parameter is required.
         *               For
         *               regional forwarding rules, this target must be in the same region as the
         *               forwarding rule. For global forwarding rules, this target must be a global
         *               load balancing resource.
         *               
         *               The forwarded traffic must be of a type appropriate to the target object.
         *               
         *               * For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
         *               * For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
         *               * 'vpc-sc' - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
         *               * 'all-apis' - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
         *               
         *               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
         *               
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#target ComputeGlobalForwardingRule#target}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getDescription}
         * @param description An optional description of this resource. Provide this property when you create the resource.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#description ComputeGlobalForwardingRule#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#id ComputeGlobalForwardingRule#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getIpAddress}
         * @param ipAddress IP address for which this forwarding rule accepts traffic.
         *                  When a client
         *                  sends traffic to this IP address, the forwarding rule directs the traffic
         *                  to the referenced 'target'.
         *                  
         *                  While creating a forwarding rule, specifying an 'IPAddress' is
         *                  required under the following circumstances:
         *                  
         *                  * When the 'target' is set to 'targetGrpcProxy' and
         *                    'validateForProxyless' is set to 'true', the
         *                    'IPAddress' should be set to '0.0.0.0'.
         *                  * When the 'target' is a Private Service Connect Google APIs
         *                    bundle, you must specify an 'IPAddress'.
         *                  
         *                  Otherwise, you can optionally specify an IP address that references an
         *                  existing static (reserved) IP address resource. When omitted, Google Cloud
         *                  assigns an ephemeral IP address.
         *                  
         *                  Use one of the following formats to specify an IP address while creating a
         *                  forwarding rule:
         *                  
         *                  * IP address number, as in '100.1.2.3'
         *                  * IPv6 address range, as in '2600:1234::/96'
         *                  * Full resource URL, as in
         *                    'https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name'
         *                  * Partial URL or by name, as in:
         *                  
         *                    * 'projects/project_id/regions/region/addresses/address-name'
         *                    * 'regions/region/addresses/address-name'
         *                    * 'global/addresses/address-name'
         *                    * 'address-name'
         *                  
         *                  The forwarding rule's 'target',
         *                  and in most cases, also the 'loadBalancingScheme', determine the
         *                  type of IP address that you can use. For detailed information, see
         *                  [IP address
         *                  specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
         *                  
         *                  When reading an 'IPAddress', the API always returns the IP
         *                  address number.
         *                  
         *                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#ip_address ComputeGlobalForwardingRule#ip_address}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getIpProtocol}
         * @param ipProtocol The IP protocol to which this rule applies.
         *                   For protocol forwarding, valid
         *                   options are 'TCP', 'UDP', 'ESP',
         *                   'AH', 'SCTP', 'ICMP' and
         *                   'L3_DEFAULT'.
         *                   
         *                   The valid IP protocols are different for different load balancing products
         *                   as described in [Load balancing
         *                   features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends). Possible values: ["TCP", "UDP", "ESP", "AH", "SCTP", "ICMP"]
         *                   
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#ip_protocol ComputeGlobalForwardingRule#ip_protocol}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipProtocol(java.lang.String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getIpVersion}
         * @param ipVersion The IP Version that will be used by this global forwarding rule. Possible values: ["IPV4", "IPV6"].
         *                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#ip_version ComputeGlobalForwardingRule#ip_version}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipVersion(java.lang.String ipVersion) {
            this.ipVersion = ipVersion;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getLabels}
         * @param labels Labels to apply to this forwarding rule.  A list of key-&gt;value pairs.
         *               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
         *               Please refer to the field 'effective_labels' for all of the labels present on the resource.
         *               
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#labels ComputeGlobalForwardingRule#labels}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getLoadBalancingScheme}
         * @param loadBalancingScheme Specifies the forwarding rule type.
         *                            For more information about forwarding rules, refer to
         *                            [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts). Default value: "EXTERNAL" Possible values: ["EXTERNAL", "EXTERNAL_MANAGED", "INTERNAL_MANAGED", "INTERNAL_SELF_MANAGED"]
         *                            
         *                            Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#load_balancing_scheme ComputeGlobalForwardingRule#load_balancing_scheme}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancingScheme(java.lang.String loadBalancingScheme) {
            this.loadBalancingScheme = loadBalancingScheme;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getMetadataFilters}
         * @param metadataFilters metadata_filters block.
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#metadata_filters ComputeGlobalForwardingRule#metadata_filters}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataFilters(com.hashicorp.cdktf.IResolvable metadataFilters) {
            this.metadataFilters = metadataFilters;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getMetadataFilters}
         * @param metadataFilters metadata_filters block.
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#metadata_filters ComputeGlobalForwardingRule#metadata_filters}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataFilters(java.util.List<? extends com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleMetadataFilters> metadataFilters) {
            this.metadataFilters = metadataFilters;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getNetwork}
         * @param network This field is not used for external load balancing.
         *                For Internal TCP/UDP Load Balancing, this field identifies the network that
         *                the load balanced IP should belong to for this Forwarding Rule.
         *                If the subnetwork is specified, the network of the subnetwork will be used.
         *                If neither subnetwork nor this field is specified, the default network will
         *                be used.
         *                
         *                For Private Service Connect forwarding rules that forward traffic to Google
         *                APIs, a network must be provided.
         *                
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#network ComputeGlobalForwardingRule#network}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder network(java.lang.String network) {
            this.network = network;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getNoAutomateDnsZone}
         * @param noAutomateDnsZone This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not.
         *                          Non-PSC forwarding rules do not use this field.
         *                          
         *                          Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#no_automate_dns_zone ComputeGlobalForwardingRule#no_automate_dns_zone}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noAutomateDnsZone(java.lang.Boolean noAutomateDnsZone) {
            this.noAutomateDnsZone = noAutomateDnsZone;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getNoAutomateDnsZone}
         * @param noAutomateDnsZone This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not.
         *                          Non-PSC forwarding rules do not use this field.
         *                          
         *                          Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#no_automate_dns_zone ComputeGlobalForwardingRule#no_automate_dns_zone}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noAutomateDnsZone(com.hashicorp.cdktf.IResolvable noAutomateDnsZone) {
            this.noAutomateDnsZone = noAutomateDnsZone;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getPortRange}
         * @param portRange The 'portRange' field has the following limitations: * It requires that the forwarding rule 'IPProtocol' be TCP, UDP, or SCTP, and * It's applicable only to the following products: external passthrough Network Load Balancers, internal and external proxy Network Load Balancers, internal and external Application Load Balancers, external protocol forwarding, and Classic VPN.
         *                  <ul>
         *                  <li>Some products have restrictions on what ports can be used. See
         *                  <a href="https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications">port specifications</a>
         *                  for details.</li>
         *                  </ul>
         *                  <p>
         *                  For external forwarding rules, two or more forwarding rules cannot use the
         *                  same '[IPAddress, IPProtocol]' pair, and cannot have overlapping
         *                  'portRange's.
         *                  <p>
         *                  For internal forwarding rules within the same VPC network, two or more
         *                  forwarding rules cannot use the same '[IPAddress, IPProtocol]' pair, and
         *                  cannot have overlapping 'portRange's.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portRange(java.lang.String portRange) {
            this.portRange = portRange;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#project ComputeGlobalForwardingRule#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getServiceDirectoryRegistrations}
         * @param serviceDirectoryRegistrations service_directory_registrations block.
         *                                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#service_directory_registrations ComputeGlobalForwardingRule#service_directory_registrations}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceDirectoryRegistrations(com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleServiceDirectoryRegistrations serviceDirectoryRegistrations) {
            this.serviceDirectoryRegistrations = serviceDirectoryRegistrations;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getSourceIpRanges}
         * @param sourceIpRanges If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here.
         *                       Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#source_ip_ranges ComputeGlobalForwardingRule#source_ip_ranges}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIpRanges(java.util.List<java.lang.String> sourceIpRanges) {
            this.sourceIpRanges = sourceIpRanges;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getSubnetwork}
         * @param subnetwork This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6.
         *                   If the network specified is in auto subnet mode, this field is optional.
         *                   However, a subnetwork must be specified if the network is in custom subnet
         *                   mode or when creating external forwarding rule with IPv6.
         *                   
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#subnetwork ComputeGlobalForwardingRule#subnetwork}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetwork(java.lang.String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_global_forwarding_rule#timeouts ComputeGlobalForwardingRule#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(com.hashicorp.cdktf.TerraformCount count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link ComputeGlobalForwardingRuleConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeGlobalForwardingRuleConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeGlobalForwardingRuleConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeGlobalForwardingRuleConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeGlobalForwardingRuleConfig {
        private final java.lang.String name;
        private final java.lang.String target;
        private final java.lang.String description;
        private final java.lang.String id;
        private final java.lang.String ipAddress;
        private final java.lang.String ipProtocol;
        private final java.lang.String ipVersion;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final java.lang.String loadBalancingScheme;
        private final java.lang.Object metadataFilters;
        private final java.lang.String network;
        private final java.lang.Object noAutomateDnsZone;
        private final java.lang.String portRange;
        private final java.lang.String project;
        private final com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleServiceDirectoryRegistrations serviceDirectoryRegistrations;
        private final java.util.List<java.lang.String> sourceIpRanges;
        private final java.lang.String subnetwork;
        private final com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Object count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipProtocol = software.amazon.jsii.Kernel.get(this, "ipProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipVersion = software.amazon.jsii.Kernel.get(this, "ipVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.loadBalancingScheme = software.amazon.jsii.Kernel.get(this, "loadBalancingScheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metadataFilters = software.amazon.jsii.Kernel.get(this, "metadataFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.network = software.amazon.jsii.Kernel.get(this, "network", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.noAutomateDnsZone = software.amazon.jsii.Kernel.get(this, "noAutomateDnsZone", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.portRange = software.amazon.jsii.Kernel.get(this, "portRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceDirectoryRegistrations = software.amazon.jsii.Kernel.get(this, "serviceDirectoryRegistrations", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleServiceDirectoryRegistrations.class));
            this.sourceIpRanges = software.amazon.jsii.Kernel.get(this, "sourceIpRanges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetwork = software.amazon.jsii.Kernel.get(this, "subnetwork", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.description = builder.description;
            this.id = builder.id;
            this.ipAddress = builder.ipAddress;
            this.ipProtocol = builder.ipProtocol;
            this.ipVersion = builder.ipVersion;
            this.labels = builder.labels;
            this.loadBalancingScheme = builder.loadBalancingScheme;
            this.metadataFilters = builder.metadataFilters;
            this.network = builder.network;
            this.noAutomateDnsZone = builder.noAutomateDnsZone;
            this.portRange = builder.portRange;
            this.project = builder.project;
            this.serviceDirectoryRegistrations = builder.serviceDirectoryRegistrations;
            this.sourceIpRanges = builder.sourceIpRanges;
            this.subnetwork = builder.subnetwork;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final java.lang.String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final java.lang.String getIpVersion() {
            return this.ipVersion;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getLoadBalancingScheme() {
            return this.loadBalancingScheme;
        }

        @Override
        public final java.lang.Object getMetadataFilters() {
            return this.metadataFilters;
        }

        @Override
        public final java.lang.String getNetwork() {
            return this.network;
        }

        @Override
        public final java.lang.Object getNoAutomateDnsZone() {
            return this.noAutomateDnsZone;
        }

        @Override
        public final java.lang.String getPortRange() {
            return this.portRange;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleServiceDirectoryRegistrations getServiceDirectoryRegistrations() {
            return this.serviceDirectoryRegistrations;
        }

        @Override
        public final java.util.List<java.lang.String> getSourceIpRanges() {
            return this.sourceIpRanges;
        }

        @Override
        public final java.lang.String getSubnetwork() {
            return this.subnetwork;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.compute_global_forwarding_rule.ComputeGlobalForwardingRuleTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Object getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getIpAddress() != null) {
                data.set("ipAddress", om.valueToTree(this.getIpAddress()));
            }
            if (this.getIpProtocol() != null) {
                data.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
            }
            if (this.getIpVersion() != null) {
                data.set("ipVersion", om.valueToTree(this.getIpVersion()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getLoadBalancingScheme() != null) {
                data.set("loadBalancingScheme", om.valueToTree(this.getLoadBalancingScheme()));
            }
            if (this.getMetadataFilters() != null) {
                data.set("metadataFilters", om.valueToTree(this.getMetadataFilters()));
            }
            if (this.getNetwork() != null) {
                data.set("network", om.valueToTree(this.getNetwork()));
            }
            if (this.getNoAutomateDnsZone() != null) {
                data.set("noAutomateDnsZone", om.valueToTree(this.getNoAutomateDnsZone()));
            }
            if (this.getPortRange() != null) {
                data.set("portRange", om.valueToTree(this.getPortRange()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getServiceDirectoryRegistrations() != null) {
                data.set("serviceDirectoryRegistrations", om.valueToTree(this.getServiceDirectoryRegistrations()));
            }
            if (this.getSourceIpRanges() != null) {
                data.set("sourceIpRanges", om.valueToTree(this.getSourceIpRanges()));
            }
            if (this.getSubnetwork() != null) {
                data.set("subnetwork", om.valueToTree(this.getSubnetwork()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.computeGlobalForwardingRule.ComputeGlobalForwardingRuleConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeGlobalForwardingRuleConfig.Jsii$Proxy that = (ComputeGlobalForwardingRuleConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!target.equals(that.target)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) return false;
            if (this.ipProtocol != null ? !this.ipProtocol.equals(that.ipProtocol) : that.ipProtocol != null) return false;
            if (this.ipVersion != null ? !this.ipVersion.equals(that.ipVersion) : that.ipVersion != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.loadBalancingScheme != null ? !this.loadBalancingScheme.equals(that.loadBalancingScheme) : that.loadBalancingScheme != null) return false;
            if (this.metadataFilters != null ? !this.metadataFilters.equals(that.metadataFilters) : that.metadataFilters != null) return false;
            if (this.network != null ? !this.network.equals(that.network) : that.network != null) return false;
            if (this.noAutomateDnsZone != null ? !this.noAutomateDnsZone.equals(that.noAutomateDnsZone) : that.noAutomateDnsZone != null) return false;
            if (this.portRange != null ? !this.portRange.equals(that.portRange) : that.portRange != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.serviceDirectoryRegistrations != null ? !this.serviceDirectoryRegistrations.equals(that.serviceDirectoryRegistrations) : that.serviceDirectoryRegistrations != null) return false;
            if (this.sourceIpRanges != null ? !this.sourceIpRanges.equals(that.sourceIpRanges) : that.sourceIpRanges != null) return false;
            if (this.subnetwork != null ? !this.subnetwork.equals(that.subnetwork) : that.subnetwork != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
            result = 31 * result + (this.ipProtocol != null ? this.ipProtocol.hashCode() : 0);
            result = 31 * result + (this.ipVersion != null ? this.ipVersion.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.loadBalancingScheme != null ? this.loadBalancingScheme.hashCode() : 0);
            result = 31 * result + (this.metadataFilters != null ? this.metadataFilters.hashCode() : 0);
            result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
            result = 31 * result + (this.noAutomateDnsZone != null ? this.noAutomateDnsZone.hashCode() : 0);
            result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.serviceDirectoryRegistrations != null ? this.serviceDirectoryRegistrations.hashCode() : 0);
            result = 31 * result + (this.sourceIpRanges != null ? this.sourceIpRanges.hashCode() : 0);
            result = 31 * result + (this.subnetwork != null ? this.subnetwork.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
