package com.hashicorp.cdktf.providers.google.compute_region_autoscaler;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-17T04:17:39.744Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.computeRegionAutoscaler.ComputeRegionAutoscalerAutoscalingPolicy")
@software.amazon.jsii.Jsii.Proxy(ComputeRegionAutoscalerAutoscalingPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeRegionAutoscalerAutoscalingPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of instances that the autoscaler can scale up to.
     * <p>
     * This is required when creating or updating an autoscaler. The
     * maximum number of replicas should not be lower than minimal number
     * of replicas.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#max_replicas ComputeRegionAutoscaler#max_replicas}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxReplicas();

    /**
     * The minimum number of replicas that the autoscaler can scale down to.
     * <p>
     * This cannot be less than 0. If not provided, autoscaler will
     * choose a default value depending on maximum number of instances
     * allowed.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#min_replicas ComputeRegionAutoscaler#min_replicas}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinReplicas();

    /**
     * The number of seconds that the autoscaler should wait before it starts collecting information from a new instance.
     * <p>
     * This prevents
     * the autoscaler from collecting information when the instance is
     * initializing, during which the collected usage would not be
     * reliable. The default time autoscaler waits is 60 seconds.
     * Virtual machine initialization times might vary because of
     * numerous factors. We recommend that you test how long an
     * instance may take to initialize. To do this, create an instance
     * and time the startup process.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#cooldown_period ComputeRegionAutoscaler#cooldown_period}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCooldownPeriod() {
        return null;
    }

    /**
     * cpu_utilization block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#cpu_utilization ComputeRegionAutoscaler#cpu_utilization}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization getCpuUtilization() {
        return null;
    }

    /**
     * load_balancing_utilization block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#load_balancing_utilization ComputeRegionAutoscaler#load_balancing_utilization}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization getLoadBalancingUtilization() {
        return null;
    }

    /**
     * metric block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#metric ComputeRegionAutoscaler#metric}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetric() {
        return null;
    }

    /**
     * Defines operating mode for this policy.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#mode ComputeRegionAutoscaler#mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
        return null;
    }

    /**
     * scale_in_control block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#scale_in_control ComputeRegionAutoscaler#scale_in_control}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyScaleInControl getScaleInControl() {
        return null;
    }

    /**
     * scaling_schedules block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#scaling_schedules ComputeRegionAutoscaler#scaling_schedules}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScalingSchedules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeRegionAutoscalerAutoscalingPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeRegionAutoscalerAutoscalingPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeRegionAutoscalerAutoscalingPolicy> {
        java.lang.Number maxReplicas;
        java.lang.Number minReplicas;
        java.lang.Number cooldownPeriod;
        com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization cpuUtilization;
        com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization;
        java.lang.Object metric;
        java.lang.String mode;
        com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyScaleInControl scaleInControl;
        java.lang.Object scalingSchedules;

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getMaxReplicas}
         * @param maxReplicas The maximum number of instances that the autoscaler can scale up to. This parameter is required.
         *                    This is required when creating or updating an autoscaler. The
         *                    maximum number of replicas should not be lower than minimal number
         *                    of replicas.
         *                    
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#max_replicas ComputeRegionAutoscaler#max_replicas}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReplicas(java.lang.Number maxReplicas) {
            this.maxReplicas = maxReplicas;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getMinReplicas}
         * @param minReplicas The minimum number of replicas that the autoscaler can scale down to. This parameter is required.
         *                    This cannot be less than 0. If not provided, autoscaler will
         *                    choose a default value depending on maximum number of instances
         *                    allowed.
         *                    
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#min_replicas ComputeRegionAutoscaler#min_replicas}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minReplicas(java.lang.Number minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getCooldownPeriod}
         * @param cooldownPeriod The number of seconds that the autoscaler should wait before it starts collecting information from a new instance.
         *                       This prevents
         *                       the autoscaler from collecting information when the instance is
         *                       initializing, during which the collected usage would not be
         *                       reliable. The default time autoscaler waits is 60 seconds.
         *                       
         *                       Virtual machine initialization times might vary because of
         *                       numerous factors. We recommend that you test how long an
         *                       instance may take to initialize. To do this, create an instance
         *                       and time the startup process.
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#cooldown_period ComputeRegionAutoscaler#cooldown_period}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldownPeriod(java.lang.Number cooldownPeriod) {
            this.cooldownPeriod = cooldownPeriod;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getCpuUtilization}
         * @param cpuUtilization cpu_utilization block.
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#cpu_utilization ComputeRegionAutoscaler#cpu_utilization}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuUtilization(com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getLoadBalancingUtilization}
         * @param loadBalancingUtilization load_balancing_utilization block.
         *                                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#load_balancing_utilization ComputeRegionAutoscaler#load_balancing_utilization}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancingUtilization(com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization) {
            this.loadBalancingUtilization = loadBalancingUtilization;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getMetric}
         * @param metric metric block.
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#metric ComputeRegionAutoscaler#metric}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(com.hashicorp.cdktf.IResolvable metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getMetric}
         * @param metric metric block.
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#metric ComputeRegionAutoscaler#metric}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(java.util.List<? extends com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyMetric> metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getMode}
         * @param mode Defines operating mode for this policy.
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#mode ComputeRegionAutoscaler#mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getScaleInControl}
         * @param scaleInControl scale_in_control block.
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#scale_in_control ComputeRegionAutoscaler#scale_in_control}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleInControl(com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyScaleInControl scaleInControl) {
            this.scaleInControl = scaleInControl;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getScalingSchedules}
         * @param scalingSchedules scaling_schedules block.
         *                         Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#scaling_schedules ComputeRegionAutoscaler#scaling_schedules}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingSchedules(com.hashicorp.cdktf.IResolvable scalingSchedules) {
            this.scalingSchedules = scalingSchedules;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionAutoscalerAutoscalingPolicy#getScalingSchedules}
         * @param scalingSchedules scaling_schedules block.
         *                         Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/compute_region_autoscaler#scaling_schedules ComputeRegionAutoscaler#scaling_schedules}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingSchedules(java.util.List<? extends com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyScalingSchedules> scalingSchedules) {
            this.scalingSchedules = scalingSchedules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeRegionAutoscalerAutoscalingPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeRegionAutoscalerAutoscalingPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeRegionAutoscalerAutoscalingPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeRegionAutoscalerAutoscalingPolicy {
        private final java.lang.Number maxReplicas;
        private final java.lang.Number minReplicas;
        private final java.lang.Number cooldownPeriod;
        private final com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization cpuUtilization;
        private final com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization;
        private final java.lang.Object metric;
        private final java.lang.String mode;
        private final com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyScaleInControl scaleInControl;
        private final java.lang.Object scalingSchedules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxReplicas = software.amazon.jsii.Kernel.get(this, "maxReplicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minReplicas = software.amazon.jsii.Kernel.get(this, "minReplicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.cooldownPeriod = software.amazon.jsii.Kernel.get(this, "cooldownPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.cpuUtilization = software.amazon.jsii.Kernel.get(this, "cpuUtilization", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization.class));
            this.loadBalancingUtilization = software.amazon.jsii.Kernel.get(this, "loadBalancingUtilization", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization.class));
            this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scaleInControl = software.amazon.jsii.Kernel.get(this, "scaleInControl", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyScaleInControl.class));
            this.scalingSchedules = software.amazon.jsii.Kernel.get(this, "scalingSchedules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxReplicas = java.util.Objects.requireNonNull(builder.maxReplicas, "maxReplicas is required");
            this.minReplicas = java.util.Objects.requireNonNull(builder.minReplicas, "minReplicas is required");
            this.cooldownPeriod = builder.cooldownPeriod;
            this.cpuUtilization = builder.cpuUtilization;
            this.loadBalancingUtilization = builder.loadBalancingUtilization;
            this.metric = builder.metric;
            this.mode = builder.mode;
            this.scaleInControl = builder.scaleInControl;
            this.scalingSchedules = builder.scalingSchedules;
        }

        @Override
        public final java.lang.Number getMaxReplicas() {
            return this.maxReplicas;
        }

        @Override
        public final java.lang.Number getMinReplicas() {
            return this.minReplicas;
        }

        @Override
        public final java.lang.Number getCooldownPeriod() {
            return this.cooldownPeriod;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization getCpuUtilization() {
            return this.cpuUtilization;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization getLoadBalancingUtilization() {
            return this.loadBalancingUtilization;
        }

        @Override
        public final java.lang.Object getMetric() {
            return this.metric;
        }

        @Override
        public final java.lang.String getMode() {
            return this.mode;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.compute_region_autoscaler.ComputeRegionAutoscalerAutoscalingPolicyScaleInControl getScaleInControl() {
            return this.scaleInControl;
        }

        @Override
        public final java.lang.Object getScalingSchedules() {
            return this.scalingSchedules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxReplicas", om.valueToTree(this.getMaxReplicas()));
            data.set("minReplicas", om.valueToTree(this.getMinReplicas()));
            if (this.getCooldownPeriod() != null) {
                data.set("cooldownPeriod", om.valueToTree(this.getCooldownPeriod()));
            }
            if (this.getCpuUtilization() != null) {
                data.set("cpuUtilization", om.valueToTree(this.getCpuUtilization()));
            }
            if (this.getLoadBalancingUtilization() != null) {
                data.set("loadBalancingUtilization", om.valueToTree(this.getLoadBalancingUtilization()));
            }
            if (this.getMetric() != null) {
                data.set("metric", om.valueToTree(this.getMetric()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getScaleInControl() != null) {
                data.set("scaleInControl", om.valueToTree(this.getScaleInControl()));
            }
            if (this.getScalingSchedules() != null) {
                data.set("scalingSchedules", om.valueToTree(this.getScalingSchedules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.computeRegionAutoscaler.ComputeRegionAutoscalerAutoscalingPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeRegionAutoscalerAutoscalingPolicy.Jsii$Proxy that = (ComputeRegionAutoscalerAutoscalingPolicy.Jsii$Proxy) o;

            if (!maxReplicas.equals(that.maxReplicas)) return false;
            if (!minReplicas.equals(that.minReplicas)) return false;
            if (this.cooldownPeriod != null ? !this.cooldownPeriod.equals(that.cooldownPeriod) : that.cooldownPeriod != null) return false;
            if (this.cpuUtilization != null ? !this.cpuUtilization.equals(that.cpuUtilization) : that.cpuUtilization != null) return false;
            if (this.loadBalancingUtilization != null ? !this.loadBalancingUtilization.equals(that.loadBalancingUtilization) : that.loadBalancingUtilization != null) return false;
            if (this.metric != null ? !this.metric.equals(that.metric) : that.metric != null) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            if (this.scaleInControl != null ? !this.scaleInControl.equals(that.scaleInControl) : that.scaleInControl != null) return false;
            return this.scalingSchedules != null ? this.scalingSchedules.equals(that.scalingSchedules) : that.scalingSchedules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxReplicas.hashCode();
            result = 31 * result + (this.minReplicas.hashCode());
            result = 31 * result + (this.cooldownPeriod != null ? this.cooldownPeriod.hashCode() : 0);
            result = 31 * result + (this.cpuUtilization != null ? this.cpuUtilization.hashCode() : 0);
            result = 31 * result + (this.loadBalancingUtilization != null ? this.loadBalancingUtilization.hashCode() : 0);
            result = 31 * result + (this.metric != null ? this.metric.hashCode() : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.scaleInControl != null ? this.scaleInControl.hashCode() : 0);
            result = 31 * result + (this.scalingSchedules != null ? this.scalingSchedules.hashCode() : 0);
            return result;
        }
    }
}
