package com.hashicorp.cdktf.providers.google.gke_backup_backup_plan;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-17T04:17:41.894Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.gkeBackupBackupPlan.GkeBackupBackupPlanRetentionPolicy")
@software.amazon.jsii.Jsii.Proxy(GkeBackupBackupPlanRetentionPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GkeBackupBackupPlanRetentionPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * Minimum age for a Backup created via this BackupPlan (in days).
     * <p>
     * Must be an integer value between 0-90 (inclusive).
     * A Backup created under this BackupPlan will not be deletable
     * until it reaches Backup's (create time + backup_delete_lock_days).
     * Updating this field of a BackupPlan does not affect existing Backups.
     * Backups created after a successful update will inherit this new value.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/gke_backup_backup_plan#backup_delete_lock_days GkeBackupBackupPlan#backup_delete_lock_days}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackupDeleteLockDays() {
        return null;
    }

    /**
     * The default maximum age of a Backup created via this BackupPlan.
     * <p>
     * This field MUST be an integer value >= 0 and <= 365. If specified,
     * a Backup created under this BackupPlan will be automatically deleted
     * after its age reaches (createTime + backupRetainDays).
     * If not specified, Backups created under this BackupPlan will NOT be
     * subject to automatic deletion. Updating this field does NOT affect
     * existing Backups under it. Backups created AFTER a successful update
     * will automatically pick up the new value.
     * NOTE: backupRetainDays must be >= backupDeleteLockDays.
     * If cronSchedule is defined, then this must be <= 360 * the creation interval.]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/gke_backup_backup_plan#backup_retain_days GkeBackupBackupPlan#backup_retain_days}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetainDays() {
        return null;
    }

    /**
     * This flag denotes whether the retention policy of this BackupPlan is locked.
     * <p>
     * If set to True, no further update is allowed on this policy, including
     * the locked field itself.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/gke_backup_backup_plan#locked GkeBackupBackupPlan#locked}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLocked() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GkeBackupBackupPlanRetentionPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GkeBackupBackupPlanRetentionPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GkeBackupBackupPlanRetentionPolicy> {
        java.lang.Number backupDeleteLockDays;
        java.lang.Number backupRetainDays;
        java.lang.Object locked;

        /**
         * Sets the value of {@link GkeBackupBackupPlanRetentionPolicy#getBackupDeleteLockDays}
         * @param backupDeleteLockDays Minimum age for a Backup created via this BackupPlan (in days).
         *                             Must be an integer value between 0-90 (inclusive).
         *                             A Backup created under this BackupPlan will not be deletable
         *                             until it reaches Backup's (create time + backup_delete_lock_days).
         *                             Updating this field of a BackupPlan does not affect existing Backups.
         *                             Backups created after a successful update will inherit this new value.
         *                             
         *                             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/gke_backup_backup_plan#backup_delete_lock_days GkeBackupBackupPlan#backup_delete_lock_days}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupDeleteLockDays(java.lang.Number backupDeleteLockDays) {
            this.backupDeleteLockDays = backupDeleteLockDays;
            return this;
        }

        /**
         * Sets the value of {@link GkeBackupBackupPlanRetentionPolicy#getBackupRetainDays}
         * @param backupRetainDays The default maximum age of a Backup created via this BackupPlan.
         *                         This field MUST be an integer value >= 0 and <= 365. If specified,
         *                         a Backup created under this BackupPlan will be automatically deleted
         *                         after its age reaches (createTime + backupRetainDays).
         *                         If not specified, Backups created under this BackupPlan will NOT be
         *                         subject to automatic deletion. Updating this field does NOT affect
         *                         existing Backups under it. Backups created AFTER a successful update
         *                         will automatically pick up the new value.
         *                         NOTE: backupRetainDays must be >= backupDeleteLockDays.
         *                         If cronSchedule is defined, then this must be <= 360 * the creation interval.]
         *                         
         *                         Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/gke_backup_backup_plan#backup_retain_days GkeBackupBackupPlan#backup_retain_days}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetainDays(java.lang.Number backupRetainDays) {
            this.backupRetainDays = backupRetainDays;
            return this;
        }

        /**
         * Sets the value of {@link GkeBackupBackupPlanRetentionPolicy#getLocked}
         * @param locked This flag denotes whether the retention policy of this BackupPlan is locked.
         *               If set to True, no further update is allowed on this policy, including
         *               the locked field itself.
         *               
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/gke_backup_backup_plan#locked GkeBackupBackupPlan#locked}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locked(java.lang.Boolean locked) {
            this.locked = locked;
            return this;
        }

        /**
         * Sets the value of {@link GkeBackupBackupPlanRetentionPolicy#getLocked}
         * @param locked This flag denotes whether the retention policy of this BackupPlan is locked.
         *               If set to True, no further update is allowed on this policy, including
         *               the locked field itself.
         *               
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/gke_backup_backup_plan#locked GkeBackupBackupPlan#locked}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locked(com.hashicorp.cdktf.IResolvable locked) {
            this.locked = locked;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GkeBackupBackupPlanRetentionPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GkeBackupBackupPlanRetentionPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GkeBackupBackupPlanRetentionPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GkeBackupBackupPlanRetentionPolicy {
        private final java.lang.Number backupDeleteLockDays;
        private final java.lang.Number backupRetainDays;
        private final java.lang.Object locked;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupDeleteLockDays = software.amazon.jsii.Kernel.get(this, "backupDeleteLockDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.backupRetainDays = software.amazon.jsii.Kernel.get(this, "backupRetainDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.locked = software.amazon.jsii.Kernel.get(this, "locked", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupDeleteLockDays = builder.backupDeleteLockDays;
            this.backupRetainDays = builder.backupRetainDays;
            this.locked = builder.locked;
        }

        @Override
        public final java.lang.Number getBackupDeleteLockDays() {
            return this.backupDeleteLockDays;
        }

        @Override
        public final java.lang.Number getBackupRetainDays() {
            return this.backupRetainDays;
        }

        @Override
        public final java.lang.Object getLocked() {
            return this.locked;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBackupDeleteLockDays() != null) {
                data.set("backupDeleteLockDays", om.valueToTree(this.getBackupDeleteLockDays()));
            }
            if (this.getBackupRetainDays() != null) {
                data.set("backupRetainDays", om.valueToTree(this.getBackupRetainDays()));
            }
            if (this.getLocked() != null) {
                data.set("locked", om.valueToTree(this.getLocked()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.gkeBackupBackupPlan.GkeBackupBackupPlanRetentionPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GkeBackupBackupPlanRetentionPolicy.Jsii$Proxy that = (GkeBackupBackupPlanRetentionPolicy.Jsii$Proxy) o;

            if (this.backupDeleteLockDays != null ? !this.backupDeleteLockDays.equals(that.backupDeleteLockDays) : that.backupDeleteLockDays != null) return false;
            if (this.backupRetainDays != null ? !this.backupRetainDays.equals(that.backupRetainDays) : that.backupRetainDays != null) return false;
            return this.locked != null ? this.locked.equals(that.locked) : that.locked == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backupDeleteLockDays != null ? this.backupDeleteLockDays.hashCode() : 0;
            result = 31 * result + (this.backupRetainDays != null ? this.backupRetainDays.hashCode() : 0);
            result = 31 * result + (this.locked != null ? this.locked.hashCode() : 0);
            return result;
        }
    }
}
