package com.hashicorp.cdktf.providers.google.iam_workload_identity_pool_provider;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-17T04:17:42.171Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.iamWorkloadIdentityPoolProvider.IamWorkloadIdentityPoolProviderOidc")
@software.amazon.jsii.Jsii.Proxy(IamWorkloadIdentityPoolProviderOidc.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IamWorkloadIdentityPoolProviderOidc extends software.amazon.jsii.JsiiSerializable {

    /**
     * The OIDC issuer URL.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/iam_workload_identity_pool_provider#issuer_uri IamWorkloadIdentityPoolProvider#issuer_uri}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIssuerUri();

    /**
     * Acceptable values for the 'aud' field (audience) in the OIDC token.
     * <p>
     * Token exchange
     * requests are rejected if the token audience does not match one of the configured
     * values. Each audience may be at most 256 characters. A maximum of 10 audiences may
     * be configured.
     * If this list is empty, the OIDC token audience must be equal to the full canonical
     * resource name of the WorkloadIdentityPoolProvider, with or without the HTTPS prefix.
     * For example:
     * ```
     * //iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
     * https://iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
     * ```
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/iam_workload_identity_pool_provider#allowed_audiences IamWorkloadIdentityPoolProvider#allowed_audiences}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedAudiences() {
        return null;
    }

    /**
     * OIDC JWKs in JSON String format.
     * <p>
     * For details on definition of a
     * JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
     * use the 'jwks_uri' from the discovery document fetched from the
     * .well-known path for the 'issuer_uri'. Currently, RSA and EC asymmetric
     * keys are supported. The JWK must use following format and include only
     * the following fields:
     * ```
     * {
     *   "keys": [
     *     {
     *           "kty": "RSA/EC",
     *           "alg": "<algorithm>",
     *           "use": "sig",
     *           "kid": "<key-id>",
     *           "n": "",
     *           "e": "",
     *           "x": "",
     *           "y": "",
     *           "crv": ""
     *     }
     *   ]
     * }
     * ```
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/iam_workload_identity_pool_provider#jwks_json IamWorkloadIdentityPoolProvider#jwks_json}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJwksJson() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IamWorkloadIdentityPoolProviderOidc}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IamWorkloadIdentityPoolProviderOidc}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IamWorkloadIdentityPoolProviderOidc> {
        java.lang.String issuerUri;
        java.util.List<java.lang.String> allowedAudiences;
        java.lang.String jwksJson;

        /**
         * Sets the value of {@link IamWorkloadIdentityPoolProviderOidc#getIssuerUri}
         * @param issuerUri The OIDC issuer URL. This parameter is required.
         *                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/iam_workload_identity_pool_provider#issuer_uri IamWorkloadIdentityPoolProvider#issuer_uri}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder issuerUri(java.lang.String issuerUri) {
            this.issuerUri = issuerUri;
            return this;
        }

        /**
         * Sets the value of {@link IamWorkloadIdentityPoolProviderOidc#getAllowedAudiences}
         * @param allowedAudiences Acceptable values for the 'aud' field (audience) in the OIDC token.
         *                         Token exchange
         *                         requests are rejected if the token audience does not match one of the configured
         *                         values. Each audience may be at most 256 characters. A maximum of 10 audiences may
         *                         be configured.
         *                         
         *                         If this list is empty, the OIDC token audience must be equal to the full canonical
         *                         resource name of the WorkloadIdentityPoolProvider, with or without the HTTPS prefix.
         *                         For example:
         *                         
         *                         ```
         *                         //iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
         *                         https://iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
         *                         ```
         *                         
         *                         Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/iam_workload_identity_pool_provider#allowed_audiences IamWorkloadIdentityPoolProvider#allowed_audiences}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedAudiences(java.util.List<java.lang.String> allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            return this;
        }

        /**
         * Sets the value of {@link IamWorkloadIdentityPoolProviderOidc#getJwksJson}
         * @param jwksJson OIDC JWKs in JSON String format.
         *                 For details on definition of a
         *                 JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
         *                 use the 'jwks_uri' from the discovery document fetched from the
         *                 .well-known path for the 'issuer_uri'. Currently, RSA and EC asymmetric
         *                 keys are supported. The JWK must use following format and include only
         *                 the following fields:
         *                 
         *                 ```
         *                 {
         *                   "keys": [
         *                     {
         *                           "kty": "RSA/EC",
         *                           "alg": "<algorithm>",
         *                           "use": "sig",
         *                           "kid": "<key-id>",
         *                           "n": "",
         *                           "e": "",
         *                           "x": "",
         *                           "y": "",
         *                           "crv": ""
         *                     }
         *                   ]
         *                 }
         *                 ```
         *                 
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/iam_workload_identity_pool_provider#jwks_json IamWorkloadIdentityPoolProvider#jwks_json}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jwksJson(java.lang.String jwksJson) {
            this.jwksJson = jwksJson;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IamWorkloadIdentityPoolProviderOidc}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IamWorkloadIdentityPoolProviderOidc build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IamWorkloadIdentityPoolProviderOidc}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamWorkloadIdentityPoolProviderOidc {
        private final java.lang.String issuerUri;
        private final java.util.List<java.lang.String> allowedAudiences;
        private final java.lang.String jwksJson;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.issuerUri = software.amazon.jsii.Kernel.get(this, "issuerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowedAudiences = software.amazon.jsii.Kernel.get(this, "allowedAudiences", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.jwksJson = software.amazon.jsii.Kernel.get(this, "jwksJson", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.issuerUri = java.util.Objects.requireNonNull(builder.issuerUri, "issuerUri is required");
            this.allowedAudiences = builder.allowedAudiences;
            this.jwksJson = builder.jwksJson;
        }

        @Override
        public final java.lang.String getIssuerUri() {
            return this.issuerUri;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedAudiences() {
            return this.allowedAudiences;
        }

        @Override
        public final java.lang.String getJwksJson() {
            return this.jwksJson;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("issuerUri", om.valueToTree(this.getIssuerUri()));
            if (this.getAllowedAudiences() != null) {
                data.set("allowedAudiences", om.valueToTree(this.getAllowedAudiences()));
            }
            if (this.getJwksJson() != null) {
                data.set("jwksJson", om.valueToTree(this.getJwksJson()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.iamWorkloadIdentityPoolProvider.IamWorkloadIdentityPoolProviderOidc"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IamWorkloadIdentityPoolProviderOidc.Jsii$Proxy that = (IamWorkloadIdentityPoolProviderOidc.Jsii$Proxy) o;

            if (!issuerUri.equals(that.issuerUri)) return false;
            if (this.allowedAudiences != null ? !this.allowedAudiences.equals(that.allowedAudiences) : that.allowedAudiences != null) return false;
            return this.jwksJson != null ? this.jwksJson.equals(that.jwksJson) : that.jwksJson == null;
        }

        @Override
        public final int hashCode() {
            int result = this.issuerUri.hashCode();
            result = 31 * result + (this.allowedAudiences != null ? this.allowedAudiences.hashCode() : 0);
            result = 31 * result + (this.jwksJson != null ? this.jwksJson.hashCode() : 0);
            return result;
        }
    }
}
