package com.hashicorp.cdktf.providers.google.sql_database_instance;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-17T04:17:43.061Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.sqlDatabaseInstance.SqlDatabaseInstanceClone")
@software.amazon.jsii.Jsii.Proxy(SqlDatabaseInstanceClone.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SqlDatabaseInstanceClone extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the instance from which the point in time should be restored.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#source_instance_name SqlDatabaseInstance#source_instance_name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceInstanceName();

    /**
     * The name of the allocated ip range for the private ip CloudSQL instance.
     * <p>
     * For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression [a-z](%5B-a-z0-9%5D*%5Ba-z0-9%5D)?.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#allocated_ip_range SqlDatabaseInstance#allocated_ip_range}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllocatedIpRange() {
        return null;
    }

    /**
     * (SQL Server only, use with point_in_time) clone only the specified databases from the source instance.
     * <p>
     * Clone all databases if empty.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#database_names SqlDatabaseInstance#database_names}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDatabaseNames() {
        return null;
    }

    /**
     * The timestamp of the point in time that should be restored.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#point_in_time SqlDatabaseInstance#point_in_time}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPointInTime() {
        return null;
    }

    /**
     * (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone.
     * <p>
     * If no zone is specified, clone to the same zone as the source instance.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#preferred_zone SqlDatabaseInstance#preferred_zone}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SqlDatabaseInstanceClone}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SqlDatabaseInstanceClone}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SqlDatabaseInstanceClone> {
        java.lang.String sourceInstanceName;
        java.lang.String allocatedIpRange;
        java.util.List<java.lang.String> databaseNames;
        java.lang.String pointInTime;
        java.lang.String preferredZone;

        /**
         * Sets the value of {@link SqlDatabaseInstanceClone#getSourceInstanceName}
         * @param sourceInstanceName The name of the instance from which the point in time should be restored. This parameter is required.
         *                           Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#source_instance_name SqlDatabaseInstance#source_instance_name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceInstanceName(java.lang.String sourceInstanceName) {
            this.sourceInstanceName = sourceInstanceName;
            return this;
        }

        /**
         * Sets the value of {@link SqlDatabaseInstanceClone#getAllocatedIpRange}
         * @param allocatedIpRange The name of the allocated ip range for the private ip CloudSQL instance.
         *                         For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression [a-z](%5B-a-z0-9%5D*%5Ba-z0-9%5D)?.
         *                         
         *                         Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#allocated_ip_range SqlDatabaseInstance#allocated_ip_range}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocatedIpRange(java.lang.String allocatedIpRange) {
            this.allocatedIpRange = allocatedIpRange;
            return this;
        }

        /**
         * Sets the value of {@link SqlDatabaseInstanceClone#getDatabaseNames}
         * @param databaseNames (SQL Server only, use with point_in_time) clone only the specified databases from the source instance.
         *                      Clone all databases if empty.
         *                      
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#database_names SqlDatabaseInstance#database_names}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseNames(java.util.List<java.lang.String> databaseNames) {
            this.databaseNames = databaseNames;
            return this;
        }

        /**
         * Sets the value of {@link SqlDatabaseInstanceClone#getPointInTime}
         * @param pointInTime The timestamp of the point in time that should be restored.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#point_in_time SqlDatabaseInstance#point_in_time}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTime(java.lang.String pointInTime) {
            this.pointInTime = pointInTime;
            return this;
        }

        /**
         * Sets the value of {@link SqlDatabaseInstanceClone#getPreferredZone}
         * @param preferredZone (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone.
         *                      If no zone is specified, clone to the same zone as the source instance.
         *                      
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.12.0/docs/resources/sql_database_instance#preferred_zone SqlDatabaseInstance#preferred_zone}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredZone(java.lang.String preferredZone) {
            this.preferredZone = preferredZone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SqlDatabaseInstanceClone}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SqlDatabaseInstanceClone build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SqlDatabaseInstanceClone}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqlDatabaseInstanceClone {
        private final java.lang.String sourceInstanceName;
        private final java.lang.String allocatedIpRange;
        private final java.util.List<java.lang.String> databaseNames;
        private final java.lang.String pointInTime;
        private final java.lang.String preferredZone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceInstanceName = software.amazon.jsii.Kernel.get(this, "sourceInstanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allocatedIpRange = software.amazon.jsii.Kernel.get(this, "allocatedIpRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseNames = software.amazon.jsii.Kernel.get(this, "databaseNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.pointInTime = software.amazon.jsii.Kernel.get(this, "pointInTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredZone = software.amazon.jsii.Kernel.get(this, "preferredZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceInstanceName = java.util.Objects.requireNonNull(builder.sourceInstanceName, "sourceInstanceName is required");
            this.allocatedIpRange = builder.allocatedIpRange;
            this.databaseNames = builder.databaseNames;
            this.pointInTime = builder.pointInTime;
            this.preferredZone = builder.preferredZone;
        }

        @Override
        public final java.lang.String getSourceInstanceName() {
            return this.sourceInstanceName;
        }

        @Override
        public final java.lang.String getAllocatedIpRange() {
            return this.allocatedIpRange;
        }

        @Override
        public final java.util.List<java.lang.String> getDatabaseNames() {
            return this.databaseNames;
        }

        @Override
        public final java.lang.String getPointInTime() {
            return this.pointInTime;
        }

        @Override
        public final java.lang.String getPreferredZone() {
            return this.preferredZone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceInstanceName", om.valueToTree(this.getSourceInstanceName()));
            if (this.getAllocatedIpRange() != null) {
                data.set("allocatedIpRange", om.valueToTree(this.getAllocatedIpRange()));
            }
            if (this.getDatabaseNames() != null) {
                data.set("databaseNames", om.valueToTree(this.getDatabaseNames()));
            }
            if (this.getPointInTime() != null) {
                data.set("pointInTime", om.valueToTree(this.getPointInTime()));
            }
            if (this.getPreferredZone() != null) {
                data.set("preferredZone", om.valueToTree(this.getPreferredZone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.sqlDatabaseInstance.SqlDatabaseInstanceClone"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SqlDatabaseInstanceClone.Jsii$Proxy that = (SqlDatabaseInstanceClone.Jsii$Proxy) o;

            if (!sourceInstanceName.equals(that.sourceInstanceName)) return false;
            if (this.allocatedIpRange != null ? !this.allocatedIpRange.equals(that.allocatedIpRange) : that.allocatedIpRange != null) return false;
            if (this.databaseNames != null ? !this.databaseNames.equals(that.databaseNames) : that.databaseNames != null) return false;
            if (this.pointInTime != null ? !this.pointInTime.equals(that.pointInTime) : that.pointInTime != null) return false;
            return this.preferredZone != null ? this.preferredZone.equals(that.preferredZone) : that.preferredZone == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceInstanceName.hashCode();
            result = 31 * result + (this.allocatedIpRange != null ? this.allocatedIpRange.hashCode() : 0);
            result = 31 * result + (this.databaseNames != null ? this.databaseNames.hashCode() : 0);
            result = 31 * result + (this.pointInTime != null ? this.pointInTime.hashCode() : 0);
            result = 31 * result + (this.preferredZone != null ? this.preferredZone.hashCode() : 0);
            return result;
        }
    }
}
