package com.hashicorp.cdktf.providers.google.compute_router_nat;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:13.921Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.computeRouterNat.ComputeRouterNatRules")
@software.amazon.jsii.Jsii.Proxy(ComputeRouterNatRules.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeRouterNatRules extends software.amazon.jsii.JsiiSerializable {

    /**
     * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against.
     * <p>
     * If it evaluates to true, the corresponding action is enforced.
     * The following examples are valid match expressions for public NAT:
     * "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')"
     * "destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'"
     * The following example is a valid match expression for private NAT:
     * "nexthop.hub == 'https://networkconnectivity.googleapis.com/v1alpha1/projects/my-project/global/hub/hub-1'"
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_nat#match ComputeRouterNat#match}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMatch();

    /**
     * An integer uniquely identifying a rule in the list.
     * <p>
     * The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_nat#rule_number ComputeRouterNat#rule_number}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getRuleNumber();

    /**
     * action block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_nat#action ComputeRouterNat#action}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.compute_router_nat.ComputeRouterNatRulesAction getAction() {
        return null;
    }

    /**
     * An optional description of this rule.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_nat#description ComputeRouterNat#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeRouterNatRules}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeRouterNatRules}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeRouterNatRules> {
        java.lang.String match;
        java.lang.Number ruleNumber;
        com.hashicorp.cdktf.providers.google.compute_router_nat.ComputeRouterNatRulesAction action;
        java.lang.String description;

        /**
         * Sets the value of {@link ComputeRouterNatRules#getMatch}
         * @param match CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. This parameter is required.
         *              If it evaluates to true, the corresponding action is enforced.
         *              
         *              The following examples are valid match expressions for public NAT:
         *              
         *              "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')"
         *              
         *              "destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'"
         *              
         *              The following example is a valid match expression for private NAT:
         *              
         *              "nexthop.hub == 'https://networkconnectivity.googleapis.com/v1alpha1/projects/my-project/global/hub/hub-1'"
         *              
         *              Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_nat#match ComputeRouterNat#match}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder match(java.lang.String match) {
            this.match = match;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatRules#getRuleNumber}
         * @param ruleNumber An integer uniquely identifying a rule in the list. This parameter is required.
         *                   The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
         *                   
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_nat#rule_number ComputeRouterNat#rule_number}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleNumber(java.lang.Number ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatRules#getAction}
         * @param action action block.
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_nat#action ComputeRouterNat#action}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(com.hashicorp.cdktf.providers.google.compute_router_nat.ComputeRouterNatRulesAction action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatRules#getDescription}
         * @param description An optional description of this rule.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_nat#description ComputeRouterNat#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeRouterNatRules}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeRouterNatRules build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeRouterNatRules}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeRouterNatRules {
        private final java.lang.String match;
        private final java.lang.Number ruleNumber;
        private final com.hashicorp.cdktf.providers.google.compute_router_nat.ComputeRouterNatRulesAction action;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleNumber = software.amazon.jsii.Kernel.get(this, "ruleNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.compute_router_nat.ComputeRouterNatRulesAction.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
            this.ruleNumber = java.util.Objects.requireNonNull(builder.ruleNumber, "ruleNumber is required");
            this.action = builder.action;
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getMatch() {
            return this.match;
        }

        @Override
        public final java.lang.Number getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.compute_router_nat.ComputeRouterNatRulesAction getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("match", om.valueToTree(this.getMatch()));
            data.set("ruleNumber", om.valueToTree(this.getRuleNumber()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.computeRouterNat.ComputeRouterNatRules"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeRouterNatRules.Jsii$Proxy that = (ComputeRouterNatRules.Jsii$Proxy) o;

            if (!match.equals(that.match)) return false;
            if (!ruleNumber.equals(that.ruleNumber)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.match.hashCode();
            result = 31 * result + (this.ruleNumber.hashCode());
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
