package com.hashicorp.cdktf.providers.google.compute_router_peer;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:13.926Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.computeRouterPeer.ComputeRouterPeerBfd")
@software.amazon.jsii.Jsii.Proxy(ComputeRouterPeerBfd.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeRouterPeerBfd extends software.amazon.jsii.JsiiSerializable {

    /**
     * The BFD session initialization mode for this BGP peer.
     * <p>
     * If set to 'ACTIVE', the Cloud Router will initiate the BFD session
     * for this BGP peer. If set to 'PASSIVE', the Cloud Router will wait
     * for the peer router to initiate the BFD session for this BGP peer.
     * If set to 'DISABLED', BFD is disabled for this BGP peer. Possible values: ["ACTIVE", "DISABLED", "PASSIVE"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_peer#session_initialization_mode ComputeRouterPeer#session_initialization_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSessionInitializationMode();

    /**
     * The minimum interval, in milliseconds, between BFD control packets received from the peer router.
     * <p>
     * The actual value is negotiated
     * between the two routers and is equal to the greater of this value
     * and the transmit interval of the other router. If set, this value
     * must be between 1000 and 30000.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_peer#min_receive_interval ComputeRouterPeer#min_receive_interval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinReceiveInterval() {
        return null;
    }

    /**
     * The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router.
     * <p>
     * The actual value is negotiated
     * between the two routers and is equal to the greater of this value
     * and the corresponding receive interval of the other router. If set,
     * this value must be between 1000 and 30000.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_peer#min_transmit_interval ComputeRouterPeer#min_transmit_interval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinTransmitInterval() {
        return null;
    }

    /**
     * The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable.
     * <p>
     * If set, the value must
     * be a value between 5 and 16.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_peer#multiplier ComputeRouterPeer#multiplier}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMultiplier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeRouterPeerBfd}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeRouterPeerBfd}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeRouterPeerBfd> {
        java.lang.String sessionInitializationMode;
        java.lang.Number minReceiveInterval;
        java.lang.Number minTransmitInterval;
        java.lang.Number multiplier;

        /**
         * Sets the value of {@link ComputeRouterPeerBfd#getSessionInitializationMode}
         * @param sessionInitializationMode The BFD session initialization mode for this BGP peer. This parameter is required.
         *                                  If set to 'ACTIVE', the Cloud Router will initiate the BFD session
         *                                  for this BGP peer. If set to 'PASSIVE', the Cloud Router will wait
         *                                  for the peer router to initiate the BFD session for this BGP peer.
         *                                  If set to 'DISABLED', BFD is disabled for this BGP peer. Possible values: ["ACTIVE", "DISABLED", "PASSIVE"]
         *                                  
         *                                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_peer#session_initialization_mode ComputeRouterPeer#session_initialization_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionInitializationMode(java.lang.String sessionInitializationMode) {
            this.sessionInitializationMode = sessionInitializationMode;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerBfd#getMinReceiveInterval}
         * @param minReceiveInterval The minimum interval, in milliseconds, between BFD control packets received from the peer router.
         *                           The actual value is negotiated
         *                           between the two routers and is equal to the greater of this value
         *                           and the transmit interval of the other router. If set, this value
         *                           must be between 1000 and 30000.
         *                           
         *                           Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_peer#min_receive_interval ComputeRouterPeer#min_receive_interval}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minReceiveInterval(java.lang.Number minReceiveInterval) {
            this.minReceiveInterval = minReceiveInterval;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerBfd#getMinTransmitInterval}
         * @param minTransmitInterval The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router.
         *                            The actual value is negotiated
         *                            between the two routers and is equal to the greater of this value
         *                            and the corresponding receive interval of the other router. If set,
         *                            this value must be between 1000 and 30000.
         *                            
         *                            Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_peer#min_transmit_interval ComputeRouterPeer#min_transmit_interval}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minTransmitInterval(java.lang.Number minTransmitInterval) {
            this.minTransmitInterval = minTransmitInterval;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerBfd#getMultiplier}
         * @param multiplier The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable.
         *                   If set, the value must
         *                   be a value between 5 and 16.
         *                   
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_router_peer#multiplier ComputeRouterPeer#multiplier}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplier(java.lang.Number multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeRouterPeerBfd}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeRouterPeerBfd build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeRouterPeerBfd}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeRouterPeerBfd {
        private final java.lang.String sessionInitializationMode;
        private final java.lang.Number minReceiveInterval;
        private final java.lang.Number minTransmitInterval;
        private final java.lang.Number multiplier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sessionInitializationMode = software.amazon.jsii.Kernel.get(this, "sessionInitializationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.minReceiveInterval = software.amazon.jsii.Kernel.get(this, "minReceiveInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minTransmitInterval = software.amazon.jsii.Kernel.get(this, "minTransmitInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.multiplier = software.amazon.jsii.Kernel.get(this, "multiplier", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sessionInitializationMode = java.util.Objects.requireNonNull(builder.sessionInitializationMode, "sessionInitializationMode is required");
            this.minReceiveInterval = builder.minReceiveInterval;
            this.minTransmitInterval = builder.minTransmitInterval;
            this.multiplier = builder.multiplier;
        }

        @Override
        public final java.lang.String getSessionInitializationMode() {
            return this.sessionInitializationMode;
        }

        @Override
        public final java.lang.Number getMinReceiveInterval() {
            return this.minReceiveInterval;
        }

        @Override
        public final java.lang.Number getMinTransmitInterval() {
            return this.minTransmitInterval;
        }

        @Override
        public final java.lang.Number getMultiplier() {
            return this.multiplier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sessionInitializationMode", om.valueToTree(this.getSessionInitializationMode()));
            if (this.getMinReceiveInterval() != null) {
                data.set("minReceiveInterval", om.valueToTree(this.getMinReceiveInterval()));
            }
            if (this.getMinTransmitInterval() != null) {
                data.set("minTransmitInterval", om.valueToTree(this.getMinTransmitInterval()));
            }
            if (this.getMultiplier() != null) {
                data.set("multiplier", om.valueToTree(this.getMultiplier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.computeRouterPeer.ComputeRouterPeerBfd"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeRouterPeerBfd.Jsii$Proxy that = (ComputeRouterPeerBfd.Jsii$Proxy) o;

            if (!sessionInitializationMode.equals(that.sessionInitializationMode)) return false;
            if (this.minReceiveInterval != null ? !this.minReceiveInterval.equals(that.minReceiveInterval) : that.minReceiveInterval != null) return false;
            if (this.minTransmitInterval != null ? !this.minTransmitInterval.equals(that.minTransmitInterval) : that.minTransmitInterval != null) return false;
            return this.multiplier != null ? this.multiplier.equals(that.multiplier) : that.multiplier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sessionInitializationMode.hashCode();
            result = 31 * result + (this.minReceiveInterval != null ? this.minReceiveInterval.hashCode() : 0);
            result = 31 * result + (this.minTransmitInterval != null ? this.minTransmitInterval.hashCode() : 0);
            result = 31 * result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            return result;
        }
    }
}
