package com.hashicorp.cdktf.providers.google.compute_target_https_proxy;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:13.995Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.computeTargetHttpsProxy.ComputeTargetHttpsProxyConfig")
@software.amazon.jsii.Jsii.Proxy(ComputeTargetHttpsProxyConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeTargetHttpsProxyConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Name of the resource.
     * <p>
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z](%5B-a-z0-9%5D*%5Ba-z0-9%5D)?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#name ComputeTargetHttpsProxy#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A reference to the UrlMap resource that defines the mapping from URL to the BackendService.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#url_map ComputeTargetHttpsProxy#url_map}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUrlMap();

    /**
     * URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
     * <p>
     * Currently, you may specify up to 15 certificates. Certificate manager certificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
     * sslCertificates and certificateManagerCertificates fields can not be defined together.
     * Accepted format is '//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}' or just the self_link 'projects/{project}/locations/{location}/certificates/{resourceName}'
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#certificate_manager_certificates ComputeTargetHttpsProxy#certificate_manager_certificates}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCertificateManagerCertificates() {
        return null;
    }

    /**
     * A reference to the CertificateMap resource uri that identifies a certificate map associated with the given target proxy.
     * <p>
     * This field can only be set for global target proxies.
     * Accepted format is '//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}'.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#certificate_map ComputeTargetHttpsProxy#certificate_map}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateMap() {
        return null;
    }

    /**
     * An optional description of this resource.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#description ComputeTargetHttpsProxy#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies how long to keep a connection open, after completing a response, while there is no matching traffic (in seconds).
     * <p>
     * If an HTTP keepalive is
     * not specified, a default value (610 seconds) will be used. For Global
     * external HTTP(S) load balancer, the minimum allowed value is 5 seconds and
     * the maximum allowed value is 1200 seconds. For Global external HTTP(S)
     * load balancer (classic), this option is not available publicly.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#http_keep_alive_timeout_sec ComputeTargetHttpsProxy#http_keep_alive_timeout_sec}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpKeepAliveTimeoutSec() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#id ComputeTargetHttpsProxy#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#project ComputeTargetHttpsProxy#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#proxy_bind ComputeTargetHttpsProxy#proxy_bind}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProxyBind() {
        return null;
    }

    /**
     * Specifies the QUIC override policy for this resource.
     * <p>
     * This determines
     * whether the load balancer will attempt to negotiate QUIC with clients
     * or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
     * specified, Google manages whether QUIC is used. Default value: "NONE" Possible values: ["NONE", "ENABLE", "DISABLE"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#quic_override ComputeTargetHttpsProxy#quic_override}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQuicOverride() {
        return null;
    }

    /**
     * A URL referring to a networksecurity.ServerTlsPolicy resource that describes how the proxy should authenticate inbound traffic. serverTlsPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED. For details which ServerTlsPolicy resources are accepted with INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED loadBalancingScheme consult ServerTlsPolicy documentation. If left blank, communications are not encrypted.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#server_tls_policy ComputeTargetHttpsProxy#server_tls_policy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerTlsPolicy() {
        return null;
    }

    /**
     * URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
     * <p>
     * Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
     * sslCertificates and certificateManagerCertificates can not be defined together.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#ssl_certificates ComputeTargetHttpsProxy#ssl_certificates}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSslCertificates() {
        return null;
    }

    /**
     * A reference to the SslPolicy resource that will be associated with the TargetHttpsProxy resource.
     * <p>
     * If not set, the TargetHttpsProxy
     * resource will not have any SSL policy configured.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#ssl_policy ComputeTargetHttpsProxy#ssl_policy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSslPolicy() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#timeouts ComputeTargetHttpsProxy#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.compute_target_https_proxy.ComputeTargetHttpsProxyTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeTargetHttpsProxyConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeTargetHttpsProxyConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeTargetHttpsProxyConfig> {
        java.lang.String name;
        java.lang.String urlMap;
        java.util.List<java.lang.String> certificateManagerCertificates;
        java.lang.String certificateMap;
        java.lang.String description;
        java.lang.Number httpKeepAliveTimeoutSec;
        java.lang.String id;
        java.lang.String project;
        java.lang.Object proxyBind;
        java.lang.String quicOverride;
        java.lang.String serverTlsPolicy;
        java.util.List<java.lang.String> sslCertificates;
        java.lang.String sslPolicy;
        com.hashicorp.cdktf.providers.google.compute_target_https_proxy.ComputeTargetHttpsProxyTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Object count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getName}
         * @param name Name of the resource. This parameter is required.
         *             Provided by the client when the resource is
         *             created. The name must be 1-63 characters long, and comply with
         *             RFC1035. Specifically, the name must be 1-63 characters long and match
         *             the regular expression '[a-z](%5B-a-z0-9%5D*%5Ba-z0-9%5D)?' which means the
         *             first character must be a lowercase letter, and all following
         *             characters must be a dash, lowercase letter, or digit, except the last
         *             character, which cannot be a dash.
         *             
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#name ComputeTargetHttpsProxy#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getUrlMap}
         * @param urlMap A reference to the UrlMap resource that defines the mapping from URL to the BackendService. This parameter is required.
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#url_map ComputeTargetHttpsProxy#url_map}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder urlMap(java.lang.String urlMap) {
            this.urlMap = urlMap;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getCertificateManagerCertificates}
         * @param certificateManagerCertificates URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
         *                                       Currently, you may specify up to 15 certificates. Certificate manager certificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
         *                                       sslCertificates and certificateManagerCertificates fields can not be defined together.
         *                                       Accepted format is '//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}' or just the self_link 'projects/{project}/locations/{location}/certificates/{resourceName}'
         *                                       
         *                                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#certificate_manager_certificates ComputeTargetHttpsProxy#certificate_manager_certificates}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateManagerCertificates(java.util.List<java.lang.String> certificateManagerCertificates) {
            this.certificateManagerCertificates = certificateManagerCertificates;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getCertificateMap}
         * @param certificateMap A reference to the CertificateMap resource uri that identifies a certificate map associated with the given target proxy.
         *                       This field can only be set for global target proxies.
         *                       Accepted format is '//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}'.
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#certificate_map ComputeTargetHttpsProxy#certificate_map}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateMap(java.lang.String certificateMap) {
            this.certificateMap = certificateMap;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getDescription}
         * @param description An optional description of this resource.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#description ComputeTargetHttpsProxy#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getHttpKeepAliveTimeoutSec}
         * @param httpKeepAliveTimeoutSec Specifies how long to keep a connection open, after completing a response, while there is no matching traffic (in seconds).
         *                                If an HTTP keepalive is
         *                                not specified, a default value (610 seconds) will be used. For Global
         *                                external HTTP(S) load balancer, the minimum allowed value is 5 seconds and
         *                                the maximum allowed value is 1200 seconds. For Global external HTTP(S)
         *                                load balancer (classic), this option is not available publicly.
         *                                
         *                                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#http_keep_alive_timeout_sec ComputeTargetHttpsProxy#http_keep_alive_timeout_sec}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpKeepAliveTimeoutSec(java.lang.Number httpKeepAliveTimeoutSec) {
            this.httpKeepAliveTimeoutSec = httpKeepAliveTimeoutSec;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#id ComputeTargetHttpsProxy#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#project ComputeTargetHttpsProxy#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getProxyBind}
         * @param proxyBind This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         *                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#proxy_bind ComputeTargetHttpsProxy#proxy_bind}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyBind(java.lang.Boolean proxyBind) {
            this.proxyBind = proxyBind;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getProxyBind}
         * @param proxyBind This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         *                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#proxy_bind ComputeTargetHttpsProxy#proxy_bind}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyBind(com.hashicorp.cdktf.IResolvable proxyBind) {
            this.proxyBind = proxyBind;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getQuicOverride}
         * @param quicOverride Specifies the QUIC override policy for this resource.
         *                     This determines
         *                     whether the load balancer will attempt to negotiate QUIC with clients
         *                     or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
         *                     specified, Google manages whether QUIC is used. Default value: "NONE" Possible values: ["NONE", "ENABLE", "DISABLE"]
         *                     
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#quic_override ComputeTargetHttpsProxy#quic_override}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quicOverride(java.lang.String quicOverride) {
            this.quicOverride = quicOverride;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getServerTlsPolicy}
         * @param serverTlsPolicy A URL referring to a networksecurity.ServerTlsPolicy resource that describes how the proxy should authenticate inbound traffic. serverTlsPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED. For details which ServerTlsPolicy resources are accepted with INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED loadBalancingScheme consult ServerTlsPolicy documentation. If left blank, communications are not encrypted.
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#server_tls_policy ComputeTargetHttpsProxy#server_tls_policy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverTlsPolicy(java.lang.String serverTlsPolicy) {
            this.serverTlsPolicy = serverTlsPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getSslCertificates}
         * @param sslCertificates URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
         *                        Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
         *                        sslCertificates and certificateManagerCertificates can not be defined together.
         *                        
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#ssl_certificates ComputeTargetHttpsProxy#ssl_certificates}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslCertificates(java.util.List<java.lang.String> sslCertificates) {
            this.sslCertificates = sslCertificates;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getSslPolicy}
         * @param sslPolicy A reference to the SslPolicy resource that will be associated with the TargetHttpsProxy resource.
         *                  If not set, the TargetHttpsProxy
         *                  resource will not have any SSL policy configured.
         *                  
         *                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#ssl_policy ComputeTargetHttpsProxy#ssl_policy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(java.lang.String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/compute_target_https_proxy#timeouts ComputeTargetHttpsProxy#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.compute_target_https_proxy.ComputeTargetHttpsProxyTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(com.hashicorp.cdktf.TerraformCount count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link ComputeTargetHttpsProxyConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeTargetHttpsProxyConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeTargetHttpsProxyConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeTargetHttpsProxyConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeTargetHttpsProxyConfig {
        private final java.lang.String name;
        private final java.lang.String urlMap;
        private final java.util.List<java.lang.String> certificateManagerCertificates;
        private final java.lang.String certificateMap;
        private final java.lang.String description;
        private final java.lang.Number httpKeepAliveTimeoutSec;
        private final java.lang.String id;
        private final java.lang.String project;
        private final java.lang.Object proxyBind;
        private final java.lang.String quicOverride;
        private final java.lang.String serverTlsPolicy;
        private final java.util.List<java.lang.String> sslCertificates;
        private final java.lang.String sslPolicy;
        private final com.hashicorp.cdktf.providers.google.compute_target_https_proxy.ComputeTargetHttpsProxyTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Object count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.urlMap = software.amazon.jsii.Kernel.get(this, "urlMap", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateManagerCertificates = software.amazon.jsii.Kernel.get(this, "certificateManagerCertificates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.certificateMap = software.amazon.jsii.Kernel.get(this, "certificateMap", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpKeepAliveTimeoutSec = software.amazon.jsii.Kernel.get(this, "httpKeepAliveTimeoutSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyBind = software.amazon.jsii.Kernel.get(this, "proxyBind", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.quicOverride = software.amazon.jsii.Kernel.get(this, "quicOverride", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverTlsPolicy = software.amazon.jsii.Kernel.get(this, "serverTlsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sslCertificates = software.amazon.jsii.Kernel.get(this, "sslCertificates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sslPolicy = software.amazon.jsii.Kernel.get(this, "sslPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.compute_target_https_proxy.ComputeTargetHttpsProxyTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.urlMap = java.util.Objects.requireNonNull(builder.urlMap, "urlMap is required");
            this.certificateManagerCertificates = builder.certificateManagerCertificates;
            this.certificateMap = builder.certificateMap;
            this.description = builder.description;
            this.httpKeepAliveTimeoutSec = builder.httpKeepAliveTimeoutSec;
            this.id = builder.id;
            this.project = builder.project;
            this.proxyBind = builder.proxyBind;
            this.quicOverride = builder.quicOverride;
            this.serverTlsPolicy = builder.serverTlsPolicy;
            this.sslCertificates = builder.sslCertificates;
            this.sslPolicy = builder.sslPolicy;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getUrlMap() {
            return this.urlMap;
        }

        @Override
        public final java.util.List<java.lang.String> getCertificateManagerCertificates() {
            return this.certificateManagerCertificates;
        }

        @Override
        public final java.lang.String getCertificateMap() {
            return this.certificateMap;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getHttpKeepAliveTimeoutSec() {
            return this.httpKeepAliveTimeoutSec;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.Object getProxyBind() {
            return this.proxyBind;
        }

        @Override
        public final java.lang.String getQuicOverride() {
            return this.quicOverride;
        }

        @Override
        public final java.lang.String getServerTlsPolicy() {
            return this.serverTlsPolicy;
        }

        @Override
        public final java.util.List<java.lang.String> getSslCertificates() {
            return this.sslCertificates;
        }

        @Override
        public final java.lang.String getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.compute_target_https_proxy.ComputeTargetHttpsProxyTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Object getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("urlMap", om.valueToTree(this.getUrlMap()));
            if (this.getCertificateManagerCertificates() != null) {
                data.set("certificateManagerCertificates", om.valueToTree(this.getCertificateManagerCertificates()));
            }
            if (this.getCertificateMap() != null) {
                data.set("certificateMap", om.valueToTree(this.getCertificateMap()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHttpKeepAliveTimeoutSec() != null) {
                data.set("httpKeepAliveTimeoutSec", om.valueToTree(this.getHttpKeepAliveTimeoutSec()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getProxyBind() != null) {
                data.set("proxyBind", om.valueToTree(this.getProxyBind()));
            }
            if (this.getQuicOverride() != null) {
                data.set("quicOverride", om.valueToTree(this.getQuicOverride()));
            }
            if (this.getServerTlsPolicy() != null) {
                data.set("serverTlsPolicy", om.valueToTree(this.getServerTlsPolicy()));
            }
            if (this.getSslCertificates() != null) {
                data.set("sslCertificates", om.valueToTree(this.getSslCertificates()));
            }
            if (this.getSslPolicy() != null) {
                data.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.computeTargetHttpsProxy.ComputeTargetHttpsProxyConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeTargetHttpsProxyConfig.Jsii$Proxy that = (ComputeTargetHttpsProxyConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!urlMap.equals(that.urlMap)) return false;
            if (this.certificateManagerCertificates != null ? !this.certificateManagerCertificates.equals(that.certificateManagerCertificates) : that.certificateManagerCertificates != null) return false;
            if (this.certificateMap != null ? !this.certificateMap.equals(that.certificateMap) : that.certificateMap != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.httpKeepAliveTimeoutSec != null ? !this.httpKeepAliveTimeoutSec.equals(that.httpKeepAliveTimeoutSec) : that.httpKeepAliveTimeoutSec != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.proxyBind != null ? !this.proxyBind.equals(that.proxyBind) : that.proxyBind != null) return false;
            if (this.quicOverride != null ? !this.quicOverride.equals(that.quicOverride) : that.quicOverride != null) return false;
            if (this.serverTlsPolicy != null ? !this.serverTlsPolicy.equals(that.serverTlsPolicy) : that.serverTlsPolicy != null) return false;
            if (this.sslCertificates != null ? !this.sslCertificates.equals(that.sslCertificates) : that.sslCertificates != null) return false;
            if (this.sslPolicy != null ? !this.sslPolicy.equals(that.sslPolicy) : that.sslPolicy != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.urlMap.hashCode());
            result = 31 * result + (this.certificateManagerCertificates != null ? this.certificateManagerCertificates.hashCode() : 0);
            result = 31 * result + (this.certificateMap != null ? this.certificateMap.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.httpKeepAliveTimeoutSec != null ? this.httpKeepAliveTimeoutSec.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.proxyBind != null ? this.proxyBind.hashCode() : 0);
            result = 31 * result + (this.quicOverride != null ? this.quicOverride.hashCode() : 0);
            result = 31 * result + (this.serverTlsPolicy != null ? this.serverTlsPolicy.hashCode() : 0);
            result = 31 * result + (this.sslCertificates != null ? this.sslCertificates.hashCode() : 0);
            result = 31 * result + (this.sslPolicy != null ? this.sslPolicy.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
