package com.hashicorp.cdktf.providers.google.container_cluster;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:14.210Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling")
@software.amazon.jsii.Jsii.Proxy(ContainerClusterNodePoolAutoscaling.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerClusterNodePoolAutoscaling extends software.amazon.jsii.JsiiSerializable {

    /**
     * Location policy specifies the algorithm used when scaling-up the node pool.
     * <p>
     * "BALANCED" - Is a best effort policy that aims to balance the sizes of available zones. "ANY" - Instructs the cluster autoscaler to prioritize utilization of unused reservations, and reduces preemption risk for Spot VMs.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#location_policy ContainerCluster#location_policy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocationPolicy() {
        return null;
    }

    /**
     * Maximum number of nodes per zone in the node pool.
     * <p>
     * Must be >= min_node_count. Cannot be used with total limits.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#max_node_count ContainerCluster#max_node_count}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxNodeCount() {
        return null;
    }

    /**
     * Minimum number of nodes per zone in the node pool.
     * <p>
     * Must be >=0 and <= max_node_count. Cannot be used with total limits.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#min_node_count ContainerCluster#min_node_count}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinNodeCount() {
        return null;
    }

    /**
     * Maximum number of all nodes in the node pool.
     * <p>
     * Must be >= total_min_node_count. Cannot be used with per zone limits.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#total_max_node_count ContainerCluster#total_max_node_count}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTotalMaxNodeCount() {
        return null;
    }

    /**
     * Minimum number of all nodes in the node pool.
     * <p>
     * Must be >=0 and <= total_max_node_count. Cannot be used with per zone limits.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#total_min_node_count ContainerCluster#total_min_node_count}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTotalMinNodeCount() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerClusterNodePoolAutoscaling}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerClusterNodePoolAutoscaling}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerClusterNodePoolAutoscaling> {
        java.lang.String locationPolicy;
        java.lang.Number maxNodeCount;
        java.lang.Number minNodeCount;
        java.lang.Number totalMaxNodeCount;
        java.lang.Number totalMinNodeCount;

        /**
         * Sets the value of {@link ContainerClusterNodePoolAutoscaling#getLocationPolicy}
         * @param locationPolicy Location policy specifies the algorithm used when scaling-up the node pool.
         *                       "BALANCED" - Is a best effort policy that aims to balance the sizes of available zones. "ANY" - Instructs the cluster autoscaler to prioritize utilization of unused reservations, and reduces preemption risk for Spot VMs.
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#location_policy ContainerCluster#location_policy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationPolicy(java.lang.String locationPolicy) {
            this.locationPolicy = locationPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ContainerClusterNodePoolAutoscaling#getMaxNodeCount}
         * @param maxNodeCount Maximum number of nodes per zone in the node pool.
         *                     Must be >= min_node_count. Cannot be used with total limits.
         *                     
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#max_node_count ContainerCluster#max_node_count}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxNodeCount(java.lang.Number maxNodeCount) {
            this.maxNodeCount = maxNodeCount;
            return this;
        }

        /**
         * Sets the value of {@link ContainerClusterNodePoolAutoscaling#getMinNodeCount}
         * @param minNodeCount Minimum number of nodes per zone in the node pool.
         *                     Must be >=0 and <= max_node_count. Cannot be used with total limits.
         *                     
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#min_node_count ContainerCluster#min_node_count}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minNodeCount(java.lang.Number minNodeCount) {
            this.minNodeCount = minNodeCount;
            return this;
        }

        /**
         * Sets the value of {@link ContainerClusterNodePoolAutoscaling#getTotalMaxNodeCount}
         * @param totalMaxNodeCount Maximum number of all nodes in the node pool.
         *                          Must be >= total_min_node_count. Cannot be used with per zone limits.
         *                          
         *                          Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#total_max_node_count ContainerCluster#total_max_node_count}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalMaxNodeCount(java.lang.Number totalMaxNodeCount) {
            this.totalMaxNodeCount = totalMaxNodeCount;
            return this;
        }

        /**
         * Sets the value of {@link ContainerClusterNodePoolAutoscaling#getTotalMinNodeCount}
         * @param totalMinNodeCount Minimum number of all nodes in the node pool.
         *                          Must be >=0 and <= total_max_node_count. Cannot be used with per zone limits.
         *                          
         *                          Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/container_cluster#total_min_node_count ContainerCluster#total_min_node_count}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalMinNodeCount(java.lang.Number totalMinNodeCount) {
            this.totalMinNodeCount = totalMinNodeCount;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerClusterNodePoolAutoscaling}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerClusterNodePoolAutoscaling build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerClusterNodePoolAutoscaling}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerClusterNodePoolAutoscaling {
        private final java.lang.String locationPolicy;
        private final java.lang.Number maxNodeCount;
        private final java.lang.Number minNodeCount;
        private final java.lang.Number totalMaxNodeCount;
        private final java.lang.Number totalMinNodeCount;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.locationPolicy = software.amazon.jsii.Kernel.get(this, "locationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxNodeCount = software.amazon.jsii.Kernel.get(this, "maxNodeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minNodeCount = software.amazon.jsii.Kernel.get(this, "minNodeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.totalMaxNodeCount = software.amazon.jsii.Kernel.get(this, "totalMaxNodeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.totalMinNodeCount = software.amazon.jsii.Kernel.get(this, "totalMinNodeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.locationPolicy = builder.locationPolicy;
            this.maxNodeCount = builder.maxNodeCount;
            this.minNodeCount = builder.minNodeCount;
            this.totalMaxNodeCount = builder.totalMaxNodeCount;
            this.totalMinNodeCount = builder.totalMinNodeCount;
        }

        @Override
        public final java.lang.String getLocationPolicy() {
            return this.locationPolicy;
        }

        @Override
        public final java.lang.Number getMaxNodeCount() {
            return this.maxNodeCount;
        }

        @Override
        public final java.lang.Number getMinNodeCount() {
            return this.minNodeCount;
        }

        @Override
        public final java.lang.Number getTotalMaxNodeCount() {
            return this.totalMaxNodeCount;
        }

        @Override
        public final java.lang.Number getTotalMinNodeCount() {
            return this.totalMinNodeCount;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLocationPolicy() != null) {
                data.set("locationPolicy", om.valueToTree(this.getLocationPolicy()));
            }
            if (this.getMaxNodeCount() != null) {
                data.set("maxNodeCount", om.valueToTree(this.getMaxNodeCount()));
            }
            if (this.getMinNodeCount() != null) {
                data.set("minNodeCount", om.valueToTree(this.getMinNodeCount()));
            }
            if (this.getTotalMaxNodeCount() != null) {
                data.set("totalMaxNodeCount", om.valueToTree(this.getTotalMaxNodeCount()));
            }
            if (this.getTotalMinNodeCount() != null) {
                data.set("totalMinNodeCount", om.valueToTree(this.getTotalMinNodeCount()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerClusterNodePoolAutoscaling.Jsii$Proxy that = (ContainerClusterNodePoolAutoscaling.Jsii$Proxy) o;

            if (this.locationPolicy != null ? !this.locationPolicy.equals(that.locationPolicy) : that.locationPolicy != null) return false;
            if (this.maxNodeCount != null ? !this.maxNodeCount.equals(that.maxNodeCount) : that.maxNodeCount != null) return false;
            if (this.minNodeCount != null ? !this.minNodeCount.equals(that.minNodeCount) : that.minNodeCount != null) return false;
            if (this.totalMaxNodeCount != null ? !this.totalMaxNodeCount.equals(that.totalMaxNodeCount) : that.totalMaxNodeCount != null) return false;
            return this.totalMinNodeCount != null ? this.totalMinNodeCount.equals(that.totalMinNodeCount) : that.totalMinNodeCount == null;
        }

        @Override
        public final int hashCode() {
            int result = this.locationPolicy != null ? this.locationPolicy.hashCode() : 0;
            result = 31 * result + (this.maxNodeCount != null ? this.maxNodeCount.hashCode() : 0);
            result = 31 * result + (this.minNodeCount != null ? this.minNodeCount.hashCode() : 0);
            result = 31 * result + (this.totalMaxNodeCount != null ? this.totalMaxNodeCount.hashCode() : 0);
            result = 31 * result + (this.totalMinNodeCount != null ? this.totalMinNodeCount.hashCode() : 0);
            return result;
        }
    }
}
