package com.hashicorp.cdktf.providers.google.data_fusion_instance;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:14.310Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.dataFusionInstance.DataFusionInstanceConfig")
@software.amazon.jsii.Jsii.Proxy(DataFusionInstanceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataFusionInstanceConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * The ID of the instance or a fully qualified identifier for the instance.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#name DataFusionInstance#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Represents the type of Data Fusion instance.
     * <p>
     * Each type is configured with
     * the default settings for processing and memory.
     * * BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
     *   using point and click UI. However, there are certain limitations, such as fewer number
     *   of concurrent pipelines, no support for streaming pipelines, etc.
     * * ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
     *   available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
     * * DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
     *   with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
     *   pipelines at low cost. Possible values: ["BASIC", "ENTERPRISE", "DEVELOPER"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#type DataFusionInstance#type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * accelerators block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#accelerators DataFusionInstance#accelerators}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccelerators() {
        return null;
    }

    /**
     * crypto_key_config block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#crypto_key_config DataFusionInstance#crypto_key_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceCryptoKeyConfig getCryptoKeyConfig() {
        return null;
    }

    /**
     * User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#dataproc_service_account DataFusionInstance#dataproc_service_account}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataprocServiceAccount() {
        return null;
    }

    /**
     * An optional description of the instance.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#description DataFusionInstance#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Display name for an instance.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#display_name DataFusionInstance#display_name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * Option to enable granular role-based access control.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_rbac DataFusionInstance#enable_rbac}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableRbac() {
        return null;
    }

    /**
     * Option to enable Stackdriver Logging.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_stackdriver_logging DataFusionInstance#enable_stackdriver_logging}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableStackdriverLogging() {
        return null;
    }

    /**
     * Option to enable Stackdriver Monitoring.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_stackdriver_monitoring DataFusionInstance#enable_stackdriver_monitoring}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableStackdriverMonitoring() {
        return null;
    }

    /**
     * event_publish_config block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#event_publish_config DataFusionInstance#event_publish_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceEventPublishConfig getEventPublishConfig() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#id DataFusionInstance#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * The resource labels for instance to use to annotate any related underlying resources, such as Compute Engine VMs.
     * <p>
     * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
     * Please refer to the field 'effective_labels' for all of the labels present on the resource.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#labels DataFusionInstance#labels}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * network_config block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#network_config DataFusionInstance#network_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceNetworkConfig getNetworkConfig() {
        return null;
    }

    /**
     * Map of additional options used to configure the behavior of Data Fusion instance.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#options DataFusionInstance#options}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getOptions() {
        return null;
    }

    /**
     * Specifies whether the Data Fusion instance should be private.
     * <p>
     * If set to
     * true, all Data Fusion nodes will have private IP addresses and will not be
     * able to access the public internet.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#private_instance DataFusionInstance#private_instance}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateInstance() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#project DataFusionInstance#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * The region of the Data Fusion instance.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#region DataFusionInstance#region}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#timeouts DataFusionInstance#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceTimeouts getTimeouts() {
        return null;
    }

    /**
     * Current version of the Data Fusion.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#version DataFusionInstance#version}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#zone DataFusionInstance#zone}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataFusionInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataFusionInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataFusionInstanceConfig> {
        java.lang.String name;
        java.lang.String type;
        java.lang.Object accelerators;
        com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceCryptoKeyConfig cryptoKeyConfig;
        java.lang.String dataprocServiceAccount;
        java.lang.String description;
        java.lang.String displayName;
        java.lang.Object enableRbac;
        java.lang.Object enableStackdriverLogging;
        java.lang.Object enableStackdriverMonitoring;
        com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceEventPublishConfig eventPublishConfig;
        java.lang.String id;
        java.util.Map<java.lang.String, java.lang.String> labels;
        com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceNetworkConfig networkConfig;
        java.util.Map<java.lang.String, java.lang.String> options;
        java.lang.Object privateInstance;
        java.lang.String project;
        java.lang.String region;
        com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceTimeouts timeouts;
        java.lang.String version;
        java.lang.String zone;
        java.lang.Object connection;
        java.lang.Object count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getName}
         * @param name The ID of the instance or a fully qualified identifier for the instance. This parameter is required.
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#name DataFusionInstance#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getType}
         * @param type Represents the type of Data Fusion instance. This parameter is required.
         *             Each type is configured with
         *             the default settings for processing and memory.
         *             
         *             * BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
         *               using point and click UI. However, there are certain limitations, such as fewer number
         *               of concurrent pipelines, no support for streaming pipelines, etc.
         *             * ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
         *               available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
         *             * DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
         *               with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
         *               pipelines at low cost. Possible values: ["BASIC", "ENTERPRISE", "DEVELOPER"]
         *             
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#type DataFusionInstance#type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getAccelerators}
         * @param accelerators accelerators block.
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#accelerators DataFusionInstance#accelerators}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerators(com.hashicorp.cdktf.IResolvable accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getAccelerators}
         * @param accelerators accelerators block.
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#accelerators DataFusionInstance#accelerators}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerators(java.util.List<? extends com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceAccelerators> accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getCryptoKeyConfig}
         * @param cryptoKeyConfig crypto_key_config block.
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#crypto_key_config DataFusionInstance#crypto_key_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cryptoKeyConfig(com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceCryptoKeyConfig cryptoKeyConfig) {
            this.cryptoKeyConfig = cryptoKeyConfig;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getDataprocServiceAccount}
         * @param dataprocServiceAccount User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
         *                               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#dataproc_service_account DataFusionInstance#dataproc_service_account}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataprocServiceAccount(java.lang.String dataprocServiceAccount) {
            this.dataprocServiceAccount = dataprocServiceAccount;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getDescription}
         * @param description An optional description of the instance.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#description DataFusionInstance#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getDisplayName}
         * @param displayName Display name for an instance.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#display_name DataFusionInstance#display_name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getEnableRbac}
         * @param enableRbac Option to enable granular role-based access control.
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_rbac DataFusionInstance#enable_rbac}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableRbac(java.lang.Boolean enableRbac) {
            this.enableRbac = enableRbac;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getEnableRbac}
         * @param enableRbac Option to enable granular role-based access control.
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_rbac DataFusionInstance#enable_rbac}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableRbac(com.hashicorp.cdktf.IResolvable enableRbac) {
            this.enableRbac = enableRbac;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getEnableStackdriverLogging}
         * @param enableStackdriverLogging Option to enable Stackdriver Logging.
         *                                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_stackdriver_logging DataFusionInstance#enable_stackdriver_logging}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableStackdriverLogging(java.lang.Boolean enableStackdriverLogging) {
            this.enableStackdriverLogging = enableStackdriverLogging;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getEnableStackdriverLogging}
         * @param enableStackdriverLogging Option to enable Stackdriver Logging.
         *                                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_stackdriver_logging DataFusionInstance#enable_stackdriver_logging}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableStackdriverLogging(com.hashicorp.cdktf.IResolvable enableStackdriverLogging) {
            this.enableStackdriverLogging = enableStackdriverLogging;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getEnableStackdriverMonitoring}
         * @param enableStackdriverMonitoring Option to enable Stackdriver Monitoring.
         *                                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_stackdriver_monitoring DataFusionInstance#enable_stackdriver_monitoring}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableStackdriverMonitoring(java.lang.Boolean enableStackdriverMonitoring) {
            this.enableStackdriverMonitoring = enableStackdriverMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getEnableStackdriverMonitoring}
         * @param enableStackdriverMonitoring Option to enable Stackdriver Monitoring.
         *                                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#enable_stackdriver_monitoring DataFusionInstance#enable_stackdriver_monitoring}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableStackdriverMonitoring(com.hashicorp.cdktf.IResolvable enableStackdriverMonitoring) {
            this.enableStackdriverMonitoring = enableStackdriverMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getEventPublishConfig}
         * @param eventPublishConfig event_publish_config block.
         *                           Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#event_publish_config DataFusionInstance#event_publish_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPublishConfig(com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceEventPublishConfig eventPublishConfig) {
            this.eventPublishConfig = eventPublishConfig;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#id DataFusionInstance#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getLabels}
         * @param labels The resource labels for instance to use to annotate any related underlying resources, such as Compute Engine VMs.
         *               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
         *               Please refer to the field 'effective_labels' for all of the labels present on the resource.
         *               
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#labels DataFusionInstance#labels}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getNetworkConfig}
         * @param networkConfig network_config block.
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#network_config DataFusionInstance#network_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getOptions}
         * @param options Map of additional options used to configure the behavior of Data Fusion instance.
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#options DataFusionInstance#options}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(java.util.Map<java.lang.String, java.lang.String> options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getPrivateInstance}
         * @param privateInstance Specifies whether the Data Fusion instance should be private.
         *                        If set to
         *                        true, all Data Fusion nodes will have private IP addresses and will not be
         *                        able to access the public internet.
         *                        
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#private_instance DataFusionInstance#private_instance}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateInstance(java.lang.Boolean privateInstance) {
            this.privateInstance = privateInstance;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getPrivateInstance}
         * @param privateInstance Specifies whether the Data Fusion instance should be private.
         *                        If set to
         *                        true, all Data Fusion nodes will have private IP addresses and will not be
         *                        able to access the public internet.
         *                        
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#private_instance DataFusionInstance#private_instance}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateInstance(com.hashicorp.cdktf.IResolvable privateInstance) {
            this.privateInstance = privateInstance;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#project DataFusionInstance#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getRegion}
         * @param region The region of the Data Fusion instance.
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#region DataFusionInstance#region}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#timeouts DataFusionInstance#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getVersion}
         * @param version Current version of the Data Fusion.
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#version DataFusionInstance#version}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getZone}
         * @param zone Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/data_fusion_instance#zone DataFusionInstance#zone}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(java.lang.String zone) {
            this.zone = zone;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(com.hashicorp.cdktf.TerraformCount count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link DataFusionInstanceConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataFusionInstanceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataFusionInstanceConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataFusionInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataFusionInstanceConfig {
        private final java.lang.String name;
        private final java.lang.String type;
        private final java.lang.Object accelerators;
        private final com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceCryptoKeyConfig cryptoKeyConfig;
        private final java.lang.String dataprocServiceAccount;
        private final java.lang.String description;
        private final java.lang.String displayName;
        private final java.lang.Object enableRbac;
        private final java.lang.Object enableStackdriverLogging;
        private final java.lang.Object enableStackdriverMonitoring;
        private final com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceEventPublishConfig eventPublishConfig;
        private final java.lang.String id;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceNetworkConfig networkConfig;
        private final java.util.Map<java.lang.String, java.lang.String> options;
        private final java.lang.Object privateInstance;
        private final java.lang.String project;
        private final java.lang.String region;
        private final com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceTimeouts timeouts;
        private final java.lang.String version;
        private final java.lang.String zone;
        private final java.lang.Object connection;
        private final java.lang.Object count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accelerators = software.amazon.jsii.Kernel.get(this, "accelerators", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cryptoKeyConfig = software.amazon.jsii.Kernel.get(this, "cryptoKeyConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceCryptoKeyConfig.class));
            this.dataprocServiceAccount = software.amazon.jsii.Kernel.get(this, "dataprocServiceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableRbac = software.amazon.jsii.Kernel.get(this, "enableRbac", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableStackdriverLogging = software.amazon.jsii.Kernel.get(this, "enableStackdriverLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableStackdriverMonitoring = software.amazon.jsii.Kernel.get(this, "enableStackdriverMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventPublishConfig = software.amazon.jsii.Kernel.get(this, "eventPublishConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceEventPublishConfig.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceNetworkConfig.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.privateInstance = software.amazon.jsii.Kernel.get(this, "privateInstance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceTimeouts.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.zone = software.amazon.jsii.Kernel.get(this, "zone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.accelerators = builder.accelerators;
            this.cryptoKeyConfig = builder.cryptoKeyConfig;
            this.dataprocServiceAccount = builder.dataprocServiceAccount;
            this.description = builder.description;
            this.displayName = builder.displayName;
            this.enableRbac = builder.enableRbac;
            this.enableStackdriverLogging = builder.enableStackdriverLogging;
            this.enableStackdriverMonitoring = builder.enableStackdriverMonitoring;
            this.eventPublishConfig = builder.eventPublishConfig;
            this.id = builder.id;
            this.labels = builder.labels;
            this.networkConfig = builder.networkConfig;
            this.options = builder.options;
            this.privateInstance = builder.privateInstance;
            this.project = builder.project;
            this.region = builder.region;
            this.timeouts = builder.timeouts;
            this.version = builder.version;
            this.zone = builder.zone;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getAccelerators() {
            return this.accelerators;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceCryptoKeyConfig getCryptoKeyConfig() {
            return this.cryptoKeyConfig;
        }

        @Override
        public final java.lang.String getDataprocServiceAccount() {
            return this.dataprocServiceAccount;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.Object getEnableRbac() {
            return this.enableRbac;
        }

        @Override
        public final java.lang.Object getEnableStackdriverLogging() {
            return this.enableStackdriverLogging;
        }

        @Override
        public final java.lang.Object getEnableStackdriverMonitoring() {
            return this.enableStackdriverMonitoring;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceEventPublishConfig getEventPublishConfig() {
            return this.eventPublishConfig;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceNetworkConfig getNetworkConfig() {
            return this.networkConfig;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getOptions() {
            return this.options;
        }

        @Override
        public final java.lang.Object getPrivateInstance() {
            return this.privateInstance;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.data_fusion_instance.DataFusionInstanceTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.String getZone() {
            return this.zone;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Object getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAccelerators() != null) {
                data.set("accelerators", om.valueToTree(this.getAccelerators()));
            }
            if (this.getCryptoKeyConfig() != null) {
                data.set("cryptoKeyConfig", om.valueToTree(this.getCryptoKeyConfig()));
            }
            if (this.getDataprocServiceAccount() != null) {
                data.set("dataprocServiceAccount", om.valueToTree(this.getDataprocServiceAccount()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getEnableRbac() != null) {
                data.set("enableRbac", om.valueToTree(this.getEnableRbac()));
            }
            if (this.getEnableStackdriverLogging() != null) {
                data.set("enableStackdriverLogging", om.valueToTree(this.getEnableStackdriverLogging()));
            }
            if (this.getEnableStackdriverMonitoring() != null) {
                data.set("enableStackdriverMonitoring", om.valueToTree(this.getEnableStackdriverMonitoring()));
            }
            if (this.getEventPublishConfig() != null) {
                data.set("eventPublishConfig", om.valueToTree(this.getEventPublishConfig()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getNetworkConfig() != null) {
                data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getPrivateInstance() != null) {
                data.set("privateInstance", om.valueToTree(this.getPrivateInstance()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }
            if (this.getZone() != null) {
                data.set("zone", om.valueToTree(this.getZone()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.dataFusionInstance.DataFusionInstanceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataFusionInstanceConfig.Jsii$Proxy that = (DataFusionInstanceConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!type.equals(that.type)) return false;
            if (this.accelerators != null ? !this.accelerators.equals(that.accelerators) : that.accelerators != null) return false;
            if (this.cryptoKeyConfig != null ? !this.cryptoKeyConfig.equals(that.cryptoKeyConfig) : that.cryptoKeyConfig != null) return false;
            if (this.dataprocServiceAccount != null ? !this.dataprocServiceAccount.equals(that.dataprocServiceAccount) : that.dataprocServiceAccount != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.enableRbac != null ? !this.enableRbac.equals(that.enableRbac) : that.enableRbac != null) return false;
            if (this.enableStackdriverLogging != null ? !this.enableStackdriverLogging.equals(that.enableStackdriverLogging) : that.enableStackdriverLogging != null) return false;
            if (this.enableStackdriverMonitoring != null ? !this.enableStackdriverMonitoring.equals(that.enableStackdriverMonitoring) : that.enableStackdriverMonitoring != null) return false;
            if (this.eventPublishConfig != null ? !this.eventPublishConfig.equals(that.eventPublishConfig) : that.eventPublishConfig != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.privateInstance != null ? !this.privateInstance.equals(that.privateInstance) : that.privateInstance != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.version != null ? !this.version.equals(that.version) : that.version != null) return false;
            if (this.zone != null ? !this.zone.equals(that.zone) : that.zone != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.accelerators != null ? this.accelerators.hashCode() : 0);
            result = 31 * result + (this.cryptoKeyConfig != null ? this.cryptoKeyConfig.hashCode() : 0);
            result = 31 * result + (this.dataprocServiceAccount != null ? this.dataprocServiceAccount.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.enableRbac != null ? this.enableRbac.hashCode() : 0);
            result = 31 * result + (this.enableStackdriverLogging != null ? this.enableStackdriverLogging.hashCode() : 0);
            result = 31 * result + (this.enableStackdriverMonitoring != null ? this.enableStackdriverMonitoring.hashCode() : 0);
            result = 31 * result + (this.eventPublishConfig != null ? this.eventPublishConfig.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.privateInstance != null ? this.privateInstance.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.zone != null ? this.zone.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
