package com.hashicorp.cdktf.providers.google.dataplex_task;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:15.378Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.dataplexTask.DataplexTaskExecutionSpec")
@software.amazon.jsii.Jsii.Proxy(DataplexTaskExecutionSpec.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataplexTaskExecutionSpec extends software.amazon.jsii.JsiiSerializable {

    /**
     * Service account to use to execute a task.
     * <p>
     * If not provided, the default Compute service account for the project is used.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#service_account DataplexTask#service_account}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceAccount();

    /**
     * The arguments to pass to the task.
     * <p>
     * The args can use placeholders of the format ${placeholder} as part of key/value string. These will be interpolated before passing the args to the driver. Currently supported placeholders: - ${taskId} - ${job_time} To pass positional args, set the key as TASK_ARGS. The value should be a comma-separated string of all the positional arguments. To use a delimiter other than comma, refer to https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of other keys being present in the args, then TASK_ARGS will be passed as the last argument. An object containing a list of 'key': value pairs. Example: { 'name': 'wrench', 'mass': '1.3kg', 'count': '3' }.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#args DataplexTask#args}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getArgs() {
        return null;
    }

    /**
     * The Cloud KMS key to use for encryption, of the form: projects/{project_number}/locations/{locationId}/keyRings/{key-ring-name}/cryptoKeys/{key-name}.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#kms_key DataplexTask#kms_key}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
        return null;
    }

    /**
     * The maximum duration after which the job execution is expired.
     * <p>
     * A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#max_job_execution_lifetime DataplexTask#max_job_execution_lifetime}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxJobExecutionLifetime() {
        return null;
    }

    /**
     * The project in which jobs are run.
     * <p>
     * By default, the project containing the Lake is used. If a project is provided, the ExecutionSpec.service_account must belong to this project.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#project DataplexTask#project}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataplexTaskExecutionSpec}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataplexTaskExecutionSpec}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataplexTaskExecutionSpec> {
        java.lang.String serviceAccount;
        java.util.Map<java.lang.String, java.lang.String> args;
        java.lang.String kmsKey;
        java.lang.String maxJobExecutionLifetime;
        java.lang.String project;

        /**
         * Sets the value of {@link DataplexTaskExecutionSpec#getServiceAccount}
         * @param serviceAccount Service account to use to execute a task. This parameter is required.
         *                       If not provided, the default Compute service account for the project is used.
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#service_account DataplexTask#service_account}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(java.lang.String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        /**
         * Sets the value of {@link DataplexTaskExecutionSpec#getArgs}
         * @param args The arguments to pass to the task.
         *             The args can use placeholders of the format ${placeholder} as part of key/value string. These will be interpolated before passing the args to the driver. Currently supported placeholders: - ${taskId} - ${job_time} To pass positional args, set the key as TASK_ARGS. The value should be a comma-separated string of all the positional arguments. To use a delimiter other than comma, refer to https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of other keys being present in the args, then TASK_ARGS will be passed as the last argument. An object containing a list of 'key': value pairs. Example: { 'name': 'wrench', 'mass': '1.3kg', 'count': '3' }.
         *             
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#args DataplexTask#args}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder args(java.util.Map<java.lang.String, java.lang.String> args) {
            this.args = args;
            return this;
        }

        /**
         * Sets the value of {@link DataplexTaskExecutionSpec#getKmsKey}
         * @param kmsKey The Cloud KMS key to use for encryption, of the form: projects/{project_number}/locations/{locationId}/keyRings/{key-ring-name}/cryptoKeys/{key-name}.
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#kms_key DataplexTask#kms_key}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(java.lang.String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link DataplexTaskExecutionSpec#getMaxJobExecutionLifetime}
         * @param maxJobExecutionLifetime The maximum duration after which the job execution is expired.
         *                                A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
         *                                
         *                                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#max_job_execution_lifetime DataplexTask#max_job_execution_lifetime}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxJobExecutionLifetime(java.lang.String maxJobExecutionLifetime) {
            this.maxJobExecutionLifetime = maxJobExecutionLifetime;
            return this;
        }

        /**
         * Sets the value of {@link DataplexTaskExecutionSpec#getProject}
         * @param project The project in which jobs are run.
         *                By default, the project containing the Lake is used. If a project is provided, the ExecutionSpec.service_account must belong to this project.
         *                
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/dataplex_task#project DataplexTask#project}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataplexTaskExecutionSpec}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataplexTaskExecutionSpec build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataplexTaskExecutionSpec}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataplexTaskExecutionSpec {
        private final java.lang.String serviceAccount;
        private final java.util.Map<java.lang.String, java.lang.String> args;
        private final java.lang.String kmsKey;
        private final java.lang.String maxJobExecutionLifetime;
        private final java.lang.String project;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceAccount = software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxJobExecutionLifetime = software.amazon.jsii.Kernel.get(this, "maxJobExecutionLifetime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceAccount = java.util.Objects.requireNonNull(builder.serviceAccount, "serviceAccount is required");
            this.args = builder.args;
            this.kmsKey = builder.kmsKey;
            this.maxJobExecutionLifetime = builder.maxJobExecutionLifetime;
            this.project = builder.project;
        }

        @Override
        public final java.lang.String getServiceAccount() {
            return this.serviceAccount;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getArgs() {
            return this.args;
        }

        @Override
        public final java.lang.String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.String getMaxJobExecutionLifetime() {
            return this.maxJobExecutionLifetime;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceAccount", om.valueToTree(this.getServiceAccount()));
            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getMaxJobExecutionLifetime() != null) {
                data.set("maxJobExecutionLifetime", om.valueToTree(this.getMaxJobExecutionLifetime()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.dataplexTask.DataplexTaskExecutionSpec"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataplexTaskExecutionSpec.Jsii$Proxy that = (DataplexTaskExecutionSpec.Jsii$Proxy) o;

            if (!serviceAccount.equals(that.serviceAccount)) return false;
            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.maxJobExecutionLifetime != null ? !this.maxJobExecutionLifetime.equals(that.maxJobExecutionLifetime) : that.maxJobExecutionLifetime != null) return false;
            return this.project != null ? this.project.equals(that.project) : that.project == null;
        }

        @Override
        public final int hashCode() {
            int result = this.serviceAccount.hashCode();
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.maxJobExecutionLifetime != null ? this.maxJobExecutionLifetime.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            return result;
        }
    }
}
