package com.hashicorp.cdktf.providers.google.integrations_client;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:16.435Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.integrationsClient.IntegrationsClientCloudKmsConfig")
@software.amazon.jsii.Jsii.Proxy(IntegrationsClientCloudKmsConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationsClientCloudKmsConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * A Cloud KMS key is a named object containing one or more key versions, along with metadata for the key.
     * <p>
     * A key exists on exactly one key ring tied to a
     * specific location.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#key IntegrationsClient#key}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKey();

    /**
     * Location name of the key ring, e.g. "us-west1".
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#kms_location IntegrationsClient#kms_location}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKmsLocation();

    /**
     * A key ring organizes keys in a specific Google Cloud location and allows you to manage access control on groups of keys.
     * <p>
     * A key ring's name does not need to be
     * unique across a Google Cloud project, but must be unique within a given location.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#kms_ring IntegrationsClient#kms_ring}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKmsRing();

    /**
     * Each version of a key contains key material used for encryption or signing.
     * <p>
     * A key's version is represented by an integer, starting at 1. To decrypt data
     * or verify a signature, you must use the same key version that was used to
     * encrypt or sign the data.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#key_version IntegrationsClient#key_version}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyVersion() {
        return null;
    }

    /**
     * The Google Cloud project id of the project where the kms key stored.
     * <p>
     * If empty,
     * the kms key is stored at the same project as customer's project and ecrypted
     * with CMEK, otherwise, the kms key is stored in the tenant project and
     * encrypted with GMEK.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#kms_project_id IntegrationsClient#kms_project_id}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsProjectId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntegrationsClientCloudKmsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationsClientCloudKmsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntegrationsClientCloudKmsConfig> {
        java.lang.String key;
        java.lang.String kmsLocation;
        java.lang.String kmsRing;
        java.lang.String keyVersion;
        java.lang.String kmsProjectId;

        /**
         * Sets the value of {@link IntegrationsClientCloudKmsConfig#getKey}
         * @param key A Cloud KMS key is a named object containing one or more key versions, along with metadata for the key. This parameter is required.
         *            A key exists on exactly one key ring tied to a
         *            specific location.
         *            
         *            Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#key IntegrationsClient#key}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationsClientCloudKmsConfig#getKmsLocation}
         * @param kmsLocation Location name of the key ring, e.g. "us-west1". This parameter is required.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#kms_location IntegrationsClient#kms_location}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsLocation(java.lang.String kmsLocation) {
            this.kmsLocation = kmsLocation;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationsClientCloudKmsConfig#getKmsRing}
         * @param kmsRing A key ring organizes keys in a specific Google Cloud location and allows you to manage access control on groups of keys. This parameter is required.
         *                A key ring's name does not need to be
         *                unique across a Google Cloud project, but must be unique within a given location.
         *                
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#kms_ring IntegrationsClient#kms_ring}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsRing(java.lang.String kmsRing) {
            this.kmsRing = kmsRing;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationsClientCloudKmsConfig#getKeyVersion}
         * @param keyVersion Each version of a key contains key material used for encryption or signing.
         *                   A key's version is represented by an integer, starting at 1. To decrypt data
         *                   or verify a signature, you must use the same key version that was used to
         *                   encrypt or sign the data.
         *                   
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#key_version IntegrationsClient#key_version}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyVersion(java.lang.String keyVersion) {
            this.keyVersion = keyVersion;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationsClientCloudKmsConfig#getKmsProjectId}
         * @param kmsProjectId The Google Cloud project id of the project where the kms key stored.
         *                     If empty,
         *                     the kms key is stored at the same project as customer's project and ecrypted
         *                     with CMEK, otherwise, the kms key is stored in the tenant project and
         *                     encrypted with GMEK.
         *                     
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/integrations_client#kms_project_id IntegrationsClient#kms_project_id}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsProjectId(java.lang.String kmsProjectId) {
            this.kmsProjectId = kmsProjectId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationsClientCloudKmsConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntegrationsClientCloudKmsConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntegrationsClientCloudKmsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationsClientCloudKmsConfig {
        private final java.lang.String key;
        private final java.lang.String kmsLocation;
        private final java.lang.String kmsRing;
        private final java.lang.String keyVersion;
        private final java.lang.String kmsProjectId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsLocation = software.amazon.jsii.Kernel.get(this, "kmsLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsRing = software.amazon.jsii.Kernel.get(this, "kmsRing", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyVersion = software.amazon.jsii.Kernel.get(this, "keyVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsProjectId = software.amazon.jsii.Kernel.get(this, "kmsProjectId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            this.kmsLocation = java.util.Objects.requireNonNull(builder.kmsLocation, "kmsLocation is required");
            this.kmsRing = java.util.Objects.requireNonNull(builder.kmsRing, "kmsRing is required");
            this.keyVersion = builder.keyVersion;
            this.kmsProjectId = builder.kmsProjectId;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.lang.String getKmsLocation() {
            return this.kmsLocation;
        }

        @Override
        public final java.lang.String getKmsRing() {
            return this.kmsRing;
        }

        @Override
        public final java.lang.String getKeyVersion() {
            return this.keyVersion;
        }

        @Override
        public final java.lang.String getKmsProjectId() {
            return this.kmsProjectId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("kmsLocation", om.valueToTree(this.getKmsLocation()));
            data.set("kmsRing", om.valueToTree(this.getKmsRing()));
            if (this.getKeyVersion() != null) {
                data.set("keyVersion", om.valueToTree(this.getKeyVersion()));
            }
            if (this.getKmsProjectId() != null) {
                data.set("kmsProjectId", om.valueToTree(this.getKmsProjectId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.integrationsClient.IntegrationsClientCloudKmsConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationsClientCloudKmsConfig.Jsii$Proxy that = (IntegrationsClientCloudKmsConfig.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!kmsLocation.equals(that.kmsLocation)) return false;
            if (!kmsRing.equals(that.kmsRing)) return false;
            if (this.keyVersion != null ? !this.keyVersion.equals(that.keyVersion) : that.keyVersion != null) return false;
            return this.kmsProjectId != null ? this.kmsProjectId.equals(that.kmsProjectId) : that.kmsProjectId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.kmsLocation.hashCode());
            result = 31 * result + (this.kmsRing.hashCode());
            result = 31 * result + (this.keyVersion != null ? this.keyVersion.hashCode() : 0);
            result = 31 * result + (this.kmsProjectId != null ? this.kmsProjectId.hashCode() : 0);
            return result;
        }
    }
}
