package com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:16.739Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.networkServicesEdgeCacheOrigin.NetworkServicesEdgeCacheOriginConfig")
@software.amazon.jsii.Jsii.Proxy(NetworkServicesEdgeCacheOriginConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkServicesEdgeCacheOriginConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Name of the resource;
     * <p>
     * provided by the client when the resource is created.
     * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
     * and all following characters must be a dash, underscore, letter or digit.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#name NetworkServicesEdgeCacheOrigin#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
     * <p>
     * This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
     * When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
     * If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#origin_address NetworkServicesEdgeCacheOrigin#origin_address}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOriginAddress();

    /**
     * aws_v4_authentication block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#aws_v4_authentication NetworkServicesEdgeCacheOrigin#aws_v4_authentication}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginAwsV4Authentication getAwsV4Authentication() {
        return null;
    }

    /**
     * A human-readable description of the resource.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#description NetworkServicesEdgeCacheOrigin#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Origin resource to try when the current origin cannot be reached.
     * <p>
     * After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
     * The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
     * A reference to a Topic resource.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#failover_origin NetworkServicesEdgeCacheOrigin#failover_origin}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFailoverOrigin() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#id NetworkServicesEdgeCacheOrigin#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * Set of label tags associated with the EdgeCache resource.
     * <p>
     * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
     * Please refer to the field 'effective_labels' for all of the labels present on the resource.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#labels NetworkServicesEdgeCacheOrigin#labels}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * The maximum number of attempts to cache fill from this origin.
     * <p>
     * Another attempt is made when a cache fill fails with one of the retryConditions.
     * Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
     * retryConditions and failoverOrigin to control its own cache fill failures.
     * The total number of allowed attempts to cache fill across this and failover origins is limited to four.
     * The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
     * The last valid, non-retried response from all origins will be returned to the client.
     * If no origin returns a valid response, an HTTP 502 will be returned to the client.
     * Defaults to 1. Must be a value greater than 0 and less than 4.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#max_attempts NetworkServicesEdgeCacheOrigin#max_attempts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAttempts() {
        return null;
    }

    /**
     * origin_override_action block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#origin_override_action NetworkServicesEdgeCacheOrigin#origin_override_action}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginOverrideAction getOriginOverrideAction() {
        return null;
    }

    /**
     * origin_redirect block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#origin_redirect NetworkServicesEdgeCacheOrigin#origin_redirect}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginRedirect getOriginRedirect() {
        return null;
    }

    /**
     * The port to connect to the origin on.
     * <p>
     * Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#port NetworkServicesEdgeCacheOrigin#port}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#project NetworkServicesEdgeCacheOrigin#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * The protocol to use to connect to the configured origin.
     * <p>
     * Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
     * When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server. Possible values: ["HTTP2", "HTTPS", "HTTP"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#protocol NetworkServicesEdgeCacheOrigin#protocol}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return null;
    }

    /**
     * Specifies one or more retry conditions for the configured origin.
     * <p>
     * If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
     * the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
     * The default retryCondition is "CONNECT_FAILURE".
     * retryConditions apply to this origin, and not subsequent failoverOrigin(s),
     * which may specify their own retryConditions and maxAttempts.
     * Valid values are:
     * * CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
     * * HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
     * * GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
     * * RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
     * * NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
     * * FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden). Possible values: ["CONNECT_FAILURE", "HTTP_5XX", "GATEWAY_ERROR", "RETRIABLE_4XX", "NOT_FOUND", "FORBIDDEN"]
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#retry_conditions NetworkServicesEdgeCacheOrigin#retry_conditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRetryConditions() {
        return null;
    }

    /**
     * timeout block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#timeout NetworkServicesEdgeCacheOrigin#timeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeout getTimeout() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#timeouts NetworkServicesEdgeCacheOrigin#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkServicesEdgeCacheOriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkServicesEdgeCacheOriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkServicesEdgeCacheOriginConfig> {
        java.lang.String name;
        java.lang.String originAddress;
        com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginAwsV4Authentication awsV4Authentication;
        java.lang.String description;
        java.lang.String failoverOrigin;
        java.lang.String id;
        java.util.Map<java.lang.String, java.lang.String> labels;
        java.lang.Number maxAttempts;
        com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginOverrideAction originOverrideAction;
        com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginRedirect originRedirect;
        java.lang.Number port;
        java.lang.String project;
        java.lang.String protocol;
        java.util.List<java.lang.String> retryConditions;
        com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeout timeout;
        com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Object count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getName}
         * @param name Name of the resource;. This parameter is required.
         *             provided by the client when the resource is created.
         *             The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
         *             and all following characters must be a dash, underscore, letter or digit.
         *             
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#name NetworkServicesEdgeCacheOrigin#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getOriginAddress}
         * @param originAddress A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket. This parameter is required.
         *                      This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
         *                      
         *                      When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
         *                      If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
         *                      
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#origin_address NetworkServicesEdgeCacheOrigin#origin_address}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAddress(java.lang.String originAddress) {
            this.originAddress = originAddress;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getAwsV4Authentication}
         * @param awsV4Authentication aws_v4_authentication block.
         *                            Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#aws_v4_authentication NetworkServicesEdgeCacheOrigin#aws_v4_authentication}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsV4Authentication(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginAwsV4Authentication awsV4Authentication) {
            this.awsV4Authentication = awsV4Authentication;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getDescription}
         * @param description A human-readable description of the resource.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#description NetworkServicesEdgeCacheOrigin#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getFailoverOrigin}
         * @param failoverOrigin The Origin resource to try when the current origin cannot be reached.
         *                       After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
         *                       
         *                       The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
         *                       A reference to a Topic resource.
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#failover_origin NetworkServicesEdgeCacheOrigin#failover_origin}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failoverOrigin(java.lang.String failoverOrigin) {
            this.failoverOrigin = failoverOrigin;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#id NetworkServicesEdgeCacheOrigin#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getLabels}
         * @param labels Set of label tags associated with the EdgeCache resource.
         *               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
         *               Please refer to the field 'effective_labels' for all of the labels present on the resource.
         *               
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#labels NetworkServicesEdgeCacheOrigin#labels}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getMaxAttempts}
         * @param maxAttempts The maximum number of attempts to cache fill from this origin.
         *                    Another attempt is made when a cache fill fails with one of the retryConditions.
         *                    
         *                    Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
         *                    retryConditions and failoverOrigin to control its own cache fill failures.
         *                    
         *                    The total number of allowed attempts to cache fill across this and failover origins is limited to four.
         *                    The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
         *                    
         *                    The last valid, non-retried response from all origins will be returned to the client.
         *                    If no origin returns a valid response, an HTTP 502 will be returned to the client.
         *                    
         *                    Defaults to 1. Must be a value greater than 0 and less than 4.
         *                    
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#max_attempts NetworkServicesEdgeCacheOrigin#max_attempts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAttempts(java.lang.Number maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getOriginOverrideAction}
         * @param originOverrideAction origin_override_action block.
         *                             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#origin_override_action NetworkServicesEdgeCacheOrigin#origin_override_action}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originOverrideAction(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginOverrideAction originOverrideAction) {
            this.originOverrideAction = originOverrideAction;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getOriginRedirect}
         * @param originRedirect origin_redirect block.
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#origin_redirect NetworkServicesEdgeCacheOrigin#origin_redirect}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRedirect(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginRedirect originRedirect) {
            this.originRedirect = originRedirect;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getPort}
         * @param port The port to connect to the origin on.
         *             Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
         *             
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#port NetworkServicesEdgeCacheOrigin#port}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#project NetworkServicesEdgeCacheOrigin#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getProtocol}
         * @param protocol The protocol to use to connect to the configured origin.
         *                 Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
         *                 
         *                 When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server. Possible values: ["HTTP2", "HTTPS", "HTTP"]
         *                 
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#protocol NetworkServicesEdgeCacheOrigin#protocol}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getRetryConditions}
         * @param retryConditions Specifies one or more retry conditions for the configured origin.
         *                        If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
         *                        the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
         *                        
         *                        The default retryCondition is "CONNECT_FAILURE".
         *                        
         *                        retryConditions apply to this origin, and not subsequent failoverOrigin(s),
         *                        which may specify their own retryConditions and maxAttempts.
         *                        
         *                        Valid values are:
         *                        
         *                        * CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
         *                        * HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
         *                        * GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
         *                        * RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
         *                        * NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
         *                        * FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden). Possible values: ["CONNECT_FAILURE", "HTTP_5XX", "GATEWAY_ERROR", "RETRIABLE_4XX", "NOT_FOUND", "FORBIDDEN"]
         *                        
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#retry_conditions NetworkServicesEdgeCacheOrigin#retry_conditions}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryConditions(java.util.List<java.lang.String> retryConditions) {
            this.retryConditions = retryConditions;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getTimeout}
         * @param timeout timeout block.
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#timeout NetworkServicesEdgeCacheOrigin#timeout}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_edge_cache_origin#timeouts NetworkServicesEdgeCacheOrigin#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(com.hashicorp.cdktf.TerraformCount count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkServicesEdgeCacheOriginConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkServicesEdgeCacheOriginConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkServicesEdgeCacheOriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkServicesEdgeCacheOriginConfig {
        private final java.lang.String name;
        private final java.lang.String originAddress;
        private final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginAwsV4Authentication awsV4Authentication;
        private final java.lang.String description;
        private final java.lang.String failoverOrigin;
        private final java.lang.String id;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final java.lang.Number maxAttempts;
        private final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginOverrideAction originOverrideAction;
        private final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginRedirect originRedirect;
        private final java.lang.Number port;
        private final java.lang.String project;
        private final java.lang.String protocol;
        private final java.util.List<java.lang.String> retryConditions;
        private final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeout timeout;
        private final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Object count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.originAddress = software.amazon.jsii.Kernel.get(this, "originAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.awsV4Authentication = software.amazon.jsii.Kernel.get(this, "awsV4Authentication", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginAwsV4Authentication.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.failoverOrigin = software.amazon.jsii.Kernel.get(this, "failoverOrigin", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maxAttempts = software.amazon.jsii.Kernel.get(this, "maxAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.originOverrideAction = software.amazon.jsii.Kernel.get(this, "originOverrideAction", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginOverrideAction.class));
            this.originRedirect = software.amazon.jsii.Kernel.get(this, "originRedirect", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginRedirect.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retryConditions = software.amazon.jsii.Kernel.get(this, "retryConditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeout.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.originAddress = java.util.Objects.requireNonNull(builder.originAddress, "originAddress is required");
            this.awsV4Authentication = builder.awsV4Authentication;
            this.description = builder.description;
            this.failoverOrigin = builder.failoverOrigin;
            this.id = builder.id;
            this.labels = builder.labels;
            this.maxAttempts = builder.maxAttempts;
            this.originOverrideAction = builder.originOverrideAction;
            this.originRedirect = builder.originRedirect;
            this.port = builder.port;
            this.project = builder.project;
            this.protocol = builder.protocol;
            this.retryConditions = builder.retryConditions;
            this.timeout = builder.timeout;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getOriginAddress() {
            return this.originAddress;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginAwsV4Authentication getAwsV4Authentication() {
            return this.awsV4Authentication;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFailoverOrigin() {
            return this.failoverOrigin;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.Number getMaxAttempts() {
            return this.maxAttempts;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginOverrideAction getOriginOverrideAction() {
            return this.originOverrideAction;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginOriginRedirect getOriginRedirect() {
            return this.originRedirect;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.util.List<java.lang.String> getRetryConditions() {
            return this.retryConditions;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeout getTimeout() {
            return this.timeout;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.network_services_edge_cache_origin.NetworkServicesEdgeCacheOriginTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Object getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("originAddress", om.valueToTree(this.getOriginAddress()));
            if (this.getAwsV4Authentication() != null) {
                data.set("awsV4Authentication", om.valueToTree(this.getAwsV4Authentication()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFailoverOrigin() != null) {
                data.set("failoverOrigin", om.valueToTree(this.getFailoverOrigin()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getMaxAttempts() != null) {
                data.set("maxAttempts", om.valueToTree(this.getMaxAttempts()));
            }
            if (this.getOriginOverrideAction() != null) {
                data.set("originOverrideAction", om.valueToTree(this.getOriginOverrideAction()));
            }
            if (this.getOriginRedirect() != null) {
                data.set("originRedirect", om.valueToTree(this.getOriginRedirect()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getRetryConditions() != null) {
                data.set("retryConditions", om.valueToTree(this.getRetryConditions()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.networkServicesEdgeCacheOrigin.NetworkServicesEdgeCacheOriginConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkServicesEdgeCacheOriginConfig.Jsii$Proxy that = (NetworkServicesEdgeCacheOriginConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!originAddress.equals(that.originAddress)) return false;
            if (this.awsV4Authentication != null ? !this.awsV4Authentication.equals(that.awsV4Authentication) : that.awsV4Authentication != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.failoverOrigin != null ? !this.failoverOrigin.equals(that.failoverOrigin) : that.failoverOrigin != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.maxAttempts != null ? !this.maxAttempts.equals(that.maxAttempts) : that.maxAttempts != null) return false;
            if (this.originOverrideAction != null ? !this.originOverrideAction.equals(that.originOverrideAction) : that.originOverrideAction != null) return false;
            if (this.originRedirect != null ? !this.originRedirect.equals(that.originRedirect) : that.originRedirect != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.retryConditions != null ? !this.retryConditions.equals(that.retryConditions) : that.retryConditions != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.originAddress.hashCode());
            result = 31 * result + (this.awsV4Authentication != null ? this.awsV4Authentication.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.failoverOrigin != null ? this.failoverOrigin.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.maxAttempts != null ? this.maxAttempts.hashCode() : 0);
            result = 31 * result + (this.originOverrideAction != null ? this.originOverrideAction.hashCode() : 0);
            result = 31 * result + (this.originRedirect != null ? this.originRedirect.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.retryConditions != null ? this.retryConditions.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
