package com.hashicorp.cdktf.providers.google.network_services_gateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:16.782Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.networkServicesGateway.NetworkServicesGatewayConfig")
@software.amazon.jsii.Jsii.Proxy(NetworkServicesGatewayConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkServicesGatewayConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Short name of the Gateway resource to be created.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#name NetworkServicesGateway#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * One or more port numbers (1-65535), on which the Gateway will receive traffic.
     * <p>
     * The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are
     * limited to 1 port. Gateways of type 'OPEN_MESH' listen on 0.0.0.0 and support multiple ports.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#ports NetworkServicesGateway#ports}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.Number> getPorts();

    /**
     * Immutable. The type of the customer-managed gateway. Possible values are: * OPEN_MESH * SECURE_WEB_GATEWAY. Possible values: ["TYPE_UNSPECIFIED", "OPEN_MESH", "SECURE_WEB_GATEWAY"].
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#type NetworkServicesGateway#type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Zero or one IPv4-address on which the Gateway will receive the traffic.
     * <p>
     * When no address is provided,
     * an IP from the subnetwork is allocated This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     * Gateways of type 'OPEN_MESH' listen on 0.0.0.0.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#addresses NetworkServicesGateway#addresses}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAddresses() {
        return null;
    }

    /**
     * A fully-qualified Certificates URL reference.
     * <p>
     * The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
     * This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#certificate_urls NetworkServicesGateway#certificate_urls}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCertificateUrls() {
        return null;
    }

    /**
     * When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
     * <p>
     * If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#delete_swg_autogen_router_on_destroy NetworkServicesGateway#delete_swg_autogen_router_on_destroy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteSwgAutogenRouterOnDestroy() {
        return null;
    }

    /**
     * A free-text description of the resource. Max length 1024 characters.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#description NetworkServicesGateway#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A fully-qualified GatewaySecurityPolicy URL reference.
     * <p>
     * Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
     * For example: 'projects/* /locations/* /gatewaySecurityPolicies/swg-policy'.
     * This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#gateway_security_policy NetworkServicesGateway#gateway_security_policy}
     * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGatewaySecurityPolicy() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#id NetworkServicesGateway#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * Set of label tags associated with the Gateway resource.
     * <p>
     * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
     * Please refer to the field 'effective_labels' for all of the labels present on the resource.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#labels NetworkServicesGateway#labels}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * The location of the gateway. The default value is 'global'.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#location NetworkServicesGateway#location}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
        return null;
    }

    /**
     * The relative resource name identifying the VPC network that is using this configuration.
     * <p>
     * For example: 'projects/* /global/networks/network-1'.
     * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#network NetworkServicesGateway#network}
     * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetwork() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#project NetworkServicesGateway#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * Immutable.
     * <p>
     * Scope determines how configuration across multiple Gateway instances are merged.
     * The configuration for multiple Gateway instances with the same scope will be merged as presented as
     * a single coniguration to the proxy/load balancer.
     * Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#scope NetworkServicesGateway#scope}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
        return null;
    }

    /**
     * A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#server_tls_policy NetworkServicesGateway#server_tls_policy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerTlsPolicy() {
        return null;
    }

    /**
     * The relative resource name identifying the subnetwork in which this SWG is allocated.
     * <p>
     * For example: 'projects/* /regions/us-central1/subnetworks/network-1'.
     * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#subnetwork NetworkServicesGateway#subnetwork}
     * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetwork() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#timeouts NetworkServicesGateway#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.network_services_gateway.NetworkServicesGatewayTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkServicesGatewayConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkServicesGatewayConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkServicesGatewayConfig> {
        java.lang.String name;
        java.util.List<java.lang.Number> ports;
        java.lang.String type;
        java.util.List<java.lang.String> addresses;
        java.util.List<java.lang.String> certificateUrls;
        java.lang.Object deleteSwgAutogenRouterOnDestroy;
        java.lang.String description;
        java.lang.String gatewaySecurityPolicy;
        java.lang.String id;
        java.util.Map<java.lang.String, java.lang.String> labels;
        java.lang.String location;
        java.lang.String network;
        java.lang.String project;
        java.lang.String scope;
        java.lang.String serverTlsPolicy;
        java.lang.String subnetwork;
        com.hashicorp.cdktf.providers.google.network_services_gateway.NetworkServicesGatewayTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Object count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getName}
         * @param name Short name of the Gateway resource to be created. This parameter is required.
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#name NetworkServicesGateway#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getPorts}
         * @param ports One or more port numbers (1-65535), on which the Gateway will receive traffic. This parameter is required.
         *              The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are
         *              limited to 1 port. Gateways of type 'OPEN_MESH' listen on 0.0.0.0 and support multiple ports.
         *              
         *              Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#ports NetworkServicesGateway#ports}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder ports(java.util.List<? extends java.lang.Number> ports) {
            this.ports = (java.util.List<java.lang.Number>)ports;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getType}
         * @param type Immutable. The type of the customer-managed gateway. Possible values are: * OPEN_MESH * SECURE_WEB_GATEWAY. Possible values: ["TYPE_UNSPECIFIED", "OPEN_MESH", "SECURE_WEB_GATEWAY"]. This parameter is required.
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#type NetworkServicesGateway#type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getAddresses}
         * @param addresses Zero or one IPv4-address on which the Gateway will receive the traffic.
         *                  When no address is provided,
         *                  an IP from the subnetwork is allocated This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
         *                  Gateways of type 'OPEN_MESH' listen on 0.0.0.0.
         *                  
         *                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#addresses NetworkServicesGateway#addresses}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addresses(java.util.List<java.lang.String> addresses) {
            this.addresses = addresses;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getCertificateUrls}
         * @param certificateUrls A fully-qualified Certificates URL reference.
         *                        The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
         *                        This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
         *                        
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#certificate_urls NetworkServicesGateway#certificate_urls}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateUrls(java.util.List<java.lang.String> certificateUrls) {
            this.certificateUrls = certificateUrls;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getDeleteSwgAutogenRouterOnDestroy}
         * @param deleteSwgAutogenRouterOnDestroy When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
         *                                        If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
         *                                        
         *                                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#delete_swg_autogen_router_on_destroy NetworkServicesGateway#delete_swg_autogen_router_on_destroy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteSwgAutogenRouterOnDestroy(java.lang.Boolean deleteSwgAutogenRouterOnDestroy) {
            this.deleteSwgAutogenRouterOnDestroy = deleteSwgAutogenRouterOnDestroy;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getDeleteSwgAutogenRouterOnDestroy}
         * @param deleteSwgAutogenRouterOnDestroy When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
         *                                        If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
         *                                        
         *                                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#delete_swg_autogen_router_on_destroy NetworkServicesGateway#delete_swg_autogen_router_on_destroy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteSwgAutogenRouterOnDestroy(com.hashicorp.cdktf.IResolvable deleteSwgAutogenRouterOnDestroy) {
            this.deleteSwgAutogenRouterOnDestroy = deleteSwgAutogenRouterOnDestroy;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getDescription}
         * @param description A free-text description of the resource. Max length 1024 characters.
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#description NetworkServicesGateway#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getGatewaySecurityPolicy}
         * @param gatewaySecurityPolicy A fully-qualified GatewaySecurityPolicy URL reference.
         *                              Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
         *                              For example: 'projects/* /locations/* /gatewaySecurityPolicies/swg-policy'.
         *                              This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
         *                              
         *                              Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#gateway_security_policy NetworkServicesGateway#gateway_security_policy}
         *                              
         *                              Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewaySecurityPolicy(java.lang.String gatewaySecurityPolicy) {
            this.gatewaySecurityPolicy = gatewaySecurityPolicy;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#id NetworkServicesGateway#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getLabels}
         * @param labels Set of label tags associated with the Gateway resource.
         *               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
         *               Please refer to the field 'effective_labels' for all of the labels present on the resource.
         *               
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#labels NetworkServicesGateway#labels}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getLocation}
         * @param location The location of the gateway. The default value is 'global'.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#location NetworkServicesGateway#location}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(java.lang.String location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getNetwork}
         * @param network The relative resource name identifying the VPC network that is using this configuration.
         *                For example: 'projects/* /global/networks/network-1'.
         *                Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
         *                
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#network NetworkServicesGateway#network}
         *                
         *                Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder network(java.lang.String network) {
            this.network = network;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#project NetworkServicesGateway#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getScope}
         * @param scope Immutable.
         *              Scope determines how configuration across multiple Gateway instances are merged.
         *              The configuration for multiple Gateway instances with the same scope will be merged as presented as
         *              a single coniguration to the proxy/load balancer.
         *              Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
         *              
         *              Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#scope NetworkServicesGateway#scope}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getServerTlsPolicy}
         * @param serverTlsPolicy A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated. If empty, TLS termination is disabled.
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#server_tls_policy NetworkServicesGateway#server_tls_policy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverTlsPolicy(java.lang.String serverTlsPolicy) {
            this.serverTlsPolicy = serverTlsPolicy;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getSubnetwork}
         * @param subnetwork The relative resource name identifying the subnetwork in which this SWG is allocated.
         *                   For example: 'projects/* /regions/us-central1/subnetworks/network-1'.
         *                   Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY.
         *                   
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#subnetwork NetworkServicesGateway#subnetwork}
         *                   
         *                   Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetwork(java.lang.String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/network_services_gateway#timeouts NetworkServicesGateway#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.network_services_gateway.NetworkServicesGatewayTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(com.hashicorp.cdktf.TerraformCount count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesGatewayConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkServicesGatewayConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkServicesGatewayConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkServicesGatewayConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkServicesGatewayConfig {
        private final java.lang.String name;
        private final java.util.List<java.lang.Number> ports;
        private final java.lang.String type;
        private final java.util.List<java.lang.String> addresses;
        private final java.util.List<java.lang.String> certificateUrls;
        private final java.lang.Object deleteSwgAutogenRouterOnDestroy;
        private final java.lang.String description;
        private final java.lang.String gatewaySecurityPolicy;
        private final java.lang.String id;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final java.lang.String location;
        private final java.lang.String network;
        private final java.lang.String project;
        private final java.lang.String scope;
        private final java.lang.String serverTlsPolicy;
        private final java.lang.String subnetwork;
        private final com.hashicorp.cdktf.providers.google.network_services_gateway.NetworkServicesGatewayTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Object count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addresses = software.amazon.jsii.Kernel.get(this, "addresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.certificateUrls = software.amazon.jsii.Kernel.get(this, "certificateUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.deleteSwgAutogenRouterOnDestroy = software.amazon.jsii.Kernel.get(this, "deleteSwgAutogenRouterOnDestroy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gatewaySecurityPolicy = software.amazon.jsii.Kernel.get(this, "gatewaySecurityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.network = software.amazon.jsii.Kernel.get(this, "network", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverTlsPolicy = software.amazon.jsii.Kernel.get(this, "serverTlsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetwork = software.amazon.jsii.Kernel.get(this, "subnetwork", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.network_services_gateway.NetworkServicesGatewayTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.ports = (java.util.List<java.lang.Number>)java.util.Objects.requireNonNull(builder.ports, "ports is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.addresses = builder.addresses;
            this.certificateUrls = builder.certificateUrls;
            this.deleteSwgAutogenRouterOnDestroy = builder.deleteSwgAutogenRouterOnDestroy;
            this.description = builder.description;
            this.gatewaySecurityPolicy = builder.gatewaySecurityPolicy;
            this.id = builder.id;
            this.labels = builder.labels;
            this.location = builder.location;
            this.network = builder.network;
            this.project = builder.project;
            this.scope = builder.scope;
            this.serverTlsPolicy = builder.serverTlsPolicy;
            this.subnetwork = builder.subnetwork;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.Number> getPorts() {
            return this.ports;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.util.List<java.lang.String> getAddresses() {
            return this.addresses;
        }

        @Override
        public final java.util.List<java.lang.String> getCertificateUrls() {
            return this.certificateUrls;
        }

        @Override
        public final java.lang.Object getDeleteSwgAutogenRouterOnDestroy() {
            return this.deleteSwgAutogenRouterOnDestroy;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getGatewaySecurityPolicy() {
            return this.gatewaySecurityPolicy;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getLocation() {
            return this.location;
        }

        @Override
        public final java.lang.String getNetwork() {
            return this.network;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.String getServerTlsPolicy() {
            return this.serverTlsPolicy;
        }

        @Override
        public final java.lang.String getSubnetwork() {
            return this.subnetwork;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.network_services_gateway.NetworkServicesGatewayTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Object getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("ports", om.valueToTree(this.getPorts()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAddresses() != null) {
                data.set("addresses", om.valueToTree(this.getAddresses()));
            }
            if (this.getCertificateUrls() != null) {
                data.set("certificateUrls", om.valueToTree(this.getCertificateUrls()));
            }
            if (this.getDeleteSwgAutogenRouterOnDestroy() != null) {
                data.set("deleteSwgAutogenRouterOnDestroy", om.valueToTree(this.getDeleteSwgAutogenRouterOnDestroy()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGatewaySecurityPolicy() != null) {
                data.set("gatewaySecurityPolicy", om.valueToTree(this.getGatewaySecurityPolicy()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getLocation() != null) {
                data.set("location", om.valueToTree(this.getLocation()));
            }
            if (this.getNetwork() != null) {
                data.set("network", om.valueToTree(this.getNetwork()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            if (this.getServerTlsPolicy() != null) {
                data.set("serverTlsPolicy", om.valueToTree(this.getServerTlsPolicy()));
            }
            if (this.getSubnetwork() != null) {
                data.set("subnetwork", om.valueToTree(this.getSubnetwork()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.networkServicesGateway.NetworkServicesGatewayConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkServicesGatewayConfig.Jsii$Proxy that = (NetworkServicesGatewayConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!ports.equals(that.ports)) return false;
            if (!type.equals(that.type)) return false;
            if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) return false;
            if (this.certificateUrls != null ? !this.certificateUrls.equals(that.certificateUrls) : that.certificateUrls != null) return false;
            if (this.deleteSwgAutogenRouterOnDestroy != null ? !this.deleteSwgAutogenRouterOnDestroy.equals(that.deleteSwgAutogenRouterOnDestroy) : that.deleteSwgAutogenRouterOnDestroy != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.gatewaySecurityPolicy != null ? !this.gatewaySecurityPolicy.equals(that.gatewaySecurityPolicy) : that.gatewaySecurityPolicy != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
            if (this.network != null ? !this.network.equals(that.network) : that.network != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            if (this.serverTlsPolicy != null ? !this.serverTlsPolicy.equals(that.serverTlsPolicy) : that.serverTlsPolicy != null) return false;
            if (this.subnetwork != null ? !this.subnetwork.equals(that.subnetwork) : that.subnetwork != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.ports.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.addresses != null ? this.addresses.hashCode() : 0);
            result = 31 * result + (this.certificateUrls != null ? this.certificateUrls.hashCode() : 0);
            result = 31 * result + (this.deleteSwgAutogenRouterOnDestroy != null ? this.deleteSwgAutogenRouterOnDestroy.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.gatewaySecurityPolicy != null ? this.gatewaySecurityPolicy.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
            result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.serverTlsPolicy != null ? this.serverTlsPolicy.hashCode() : 0);
            result = 31 * result + (this.subnetwork != null ? this.subnetwork.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
