package com.hashicorp.cdktf.providers.google.storage_bucket_object;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.96.0 (build 921e240)", date = "2024-04-09T03:36:17.353Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.storageBucketObject.StorageBucketObjectConfig")
@software.amazon.jsii.Jsii.Proxy(StorageBucketObjectConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StorageBucketObjectConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * The name of the containing bucket.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#bucket StorageBucketObject#bucket}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucket();

    /**
     * The name of the object. If you're interpolating the name of this object, see output_name instead.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#name StorageBucketObject#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Cache-Control directive to specify caching behavior of object data.
     * <p>
     * If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#cache_control StorageBucketObject#cache_control}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheControl() {
        return null;
    }

    /**
     * Data as string to be uploaded.
     * <p>
     * Must be defined if source is not. Note: The content field is marked as sensitive. To view the raw contents of the object, please define an output.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content StorageBucketObject#content}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContent() {
        return null;
    }

    /**
     * Content-Disposition of the object data.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content_disposition StorageBucketObject#content_disposition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentDisposition() {
        return null;
    }

    /**
     * Content-Encoding of the object data.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content_encoding StorageBucketObject#content_encoding}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentEncoding() {
        return null;
    }

    /**
     * Content-Language of the object data.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content_language StorageBucketObject#content_language}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentLanguage() {
        return null;
    }

    /**
     * Content-Type of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content_type StorageBucketObject#content_type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * customer_encryption block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#customer_encryption StorageBucketObject#customer_encryption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectCustomerEncryption getCustomerEncryption() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#detect_md5hash StorageBucketObject#detect_md5hash}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDetectMd5Hash() {
        return null;
    }

    /**
     * Whether an object is under event-based hold.
     * <p>
     * Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any).
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#event_based_hold StorageBucketObject#event_based_hold}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventBasedHold() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#id StorageBucketObject#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * Resource name of the Cloud KMS key that will be used to encrypt the object.
     * <p>
     * Overrides the object metadata's kmsKeyName value, if any.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#kms_key_name StorageBucketObject#kms_key_name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyName() {
        return null;
    }

    /**
     * User-provided metadata, in key/value pairs.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#metadata StorageBucketObject#metadata}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getMetadata() {
        return null;
    }

    /**
     * retention block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#retention StorageBucketObject#retention}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectRetention getRetention() {
        return null;
    }

    /**
     * A path to the data you want to upload. Must be defined if content is not.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#source StorageBucketObject#source}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
        return null;
    }

    /**
     * The StorageClass of the new bucket object.
     * <p>
     * Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE. If not provided, this defaults to the bucket's default storage class or to a standard class.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#storage_class StorageBucketObject#storage_class}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageClass() {
        return null;
    }

    /**
     * Whether an object is under temporary hold.
     * <p>
     * While this flag is set to true, the object is protected against deletion and overwrites.
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#temporary_hold StorageBucketObject#temporary_hold}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTemporaryHold() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#timeouts StorageBucketObject#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StorageBucketObjectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StorageBucketObjectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StorageBucketObjectConfig> {
        java.lang.String bucket;
        java.lang.String name;
        java.lang.String cacheControl;
        java.lang.String content;
        java.lang.String contentDisposition;
        java.lang.String contentEncoding;
        java.lang.String contentLanguage;
        java.lang.String contentType;
        com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectCustomerEncryption customerEncryption;
        java.lang.String detectMd5Hash;
        java.lang.Object eventBasedHold;
        java.lang.String id;
        java.lang.String kmsKeyName;
        java.util.Map<java.lang.String, java.lang.String> metadata;
        com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectRetention retention;
        java.lang.String source;
        java.lang.String storageClass;
        java.lang.Object temporaryHold;
        com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Object count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getBucket}
         * @param bucket The name of the containing bucket. This parameter is required.
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#bucket StorageBucketObject#bucket}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(java.lang.String bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getName}
         * @param name The name of the object. If you're interpolating the name of this object, see output_name instead. This parameter is required.
         *             Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#name StorageBucketObject#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getCacheControl}
         * @param cacheControl Cache-Control directive to specify caching behavior of object data.
         *                     If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
         *                     
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#cache_control StorageBucketObject#cache_control}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheControl(java.lang.String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getContent}
         * @param content Data as string to be uploaded.
         *                Must be defined if source is not. Note: The content field is marked as sensitive. To view the raw contents of the object, please define an output.
         *                
         *                Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content StorageBucketObject#content}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(java.lang.String content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getContentDisposition}
         * @param contentDisposition Content-Disposition of the object data.
         *                           Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content_disposition StorageBucketObject#content_disposition}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentDisposition(java.lang.String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getContentEncoding}
         * @param contentEncoding Content-Encoding of the object data.
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content_encoding StorageBucketObject#content_encoding}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentEncoding(java.lang.String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getContentLanguage}
         * @param contentLanguage Content-Language of the object data.
         *                        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content_language StorageBucketObject#content_language}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentLanguage(java.lang.String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getContentType}
         * @param contentType Content-Type of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
         *                    Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#content_type StorageBucketObject#content_type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getCustomerEncryption}
         * @param customerEncryption customer_encryption block.
         *                           Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#customer_encryption StorageBucketObject#customer_encryption}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerEncryption(com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectCustomerEncryption customerEncryption) {
            this.customerEncryption = customerEncryption;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getDetectMd5Hash}
         * @param detectMd5Hash Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#detect_md5hash StorageBucketObject#detect_md5hash}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectMd5Hash(java.lang.String detectMd5Hash) {
            this.detectMd5Hash = detectMd5Hash;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getEventBasedHold}
         * @param eventBasedHold Whether an object is under event-based hold.
         *                       Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any).
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#event_based_hold StorageBucketObject#event_based_hold}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBasedHold(java.lang.Boolean eventBasedHold) {
            this.eventBasedHold = eventBasedHold;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getEventBasedHold}
         * @param eventBasedHold Whether an object is under event-based hold.
         *                       Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any).
         *                       
         *                       Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#event_based_hold StorageBucketObject#event_based_hold}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBasedHold(com.hashicorp.cdktf.IResolvable eventBasedHold) {
            this.eventBasedHold = eventBasedHold;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#id StorageBucketObject#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getKmsKeyName}
         * @param kmsKeyName Resource name of the Cloud KMS key that will be used to encrypt the object.
         *                   Overrides the object metadata's kmsKeyName value, if any.
         *                   
         *                   Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#kms_key_name StorageBucketObject#kms_key_name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyName(java.lang.String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getMetadata}
         * @param metadata User-provided metadata, in key/value pairs.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#metadata StorageBucketObject#metadata}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(java.util.Map<java.lang.String, java.lang.String> metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getRetention}
         * @param retention retention block.
         *                  Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#retention StorageBucketObject#retention}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectRetention retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getSource}
         * @param source A path to the data you want to upload. Must be defined if content is not.
         *               Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#source StorageBucketObject#source}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getStorageClass}
         * @param storageClass The StorageClass of the new bucket object.
         *                     Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE. If not provided, this defaults to the bucket's default storage class or to a standard class.
         *                     
         *                     Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#storage_class StorageBucketObject#storage_class}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClass(java.lang.String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getTemporaryHold}
         * @param temporaryHold Whether an object is under temporary hold.
         *                      While this flag is set to true, the object is protected against deletion and overwrites.
         *                      
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#temporary_hold StorageBucketObject#temporary_hold}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder temporaryHold(java.lang.Boolean temporaryHold) {
            this.temporaryHold = temporaryHold;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getTemporaryHold}
         * @param temporaryHold Whether an object is under temporary hold.
         *                      While this flag is set to true, the object is protected against deletion and overwrites.
         *                      
         *                      Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#temporary_hold StorageBucketObject#temporary_hold}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder temporaryHold(com.hashicorp.cdktf.IResolvable temporaryHold) {
            this.temporaryHold = temporaryHold;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google/5.24.0/docs/resources/storage_bucket_object#timeouts StorageBucketObject#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(com.hashicorp.cdktf.TerraformCount count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link StorageBucketObjectConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StorageBucketObjectConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StorageBucketObjectConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StorageBucketObjectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageBucketObjectConfig {
        private final java.lang.String bucket;
        private final java.lang.String name;
        private final java.lang.String cacheControl;
        private final java.lang.String content;
        private final java.lang.String contentDisposition;
        private final java.lang.String contentEncoding;
        private final java.lang.String contentLanguage;
        private final java.lang.String contentType;
        private final com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectCustomerEncryption customerEncryption;
        private final java.lang.String detectMd5Hash;
        private final java.lang.Object eventBasedHold;
        private final java.lang.String id;
        private final java.lang.String kmsKeyName;
        private final java.util.Map<java.lang.String, java.lang.String> metadata;
        private final com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectRetention retention;
        private final java.lang.String source;
        private final java.lang.String storageClass;
        private final java.lang.Object temporaryHold;
        private final com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Object count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheControl = software.amazon.jsii.Kernel.get(this, "cacheControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentDisposition = software.amazon.jsii.Kernel.get(this, "contentDisposition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentEncoding = software.amazon.jsii.Kernel.get(this, "contentEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentLanguage = software.amazon.jsii.Kernel.get(this, "contentLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerEncryption = software.amazon.jsii.Kernel.get(this, "customerEncryption", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectCustomerEncryption.class));
            this.detectMd5Hash = software.amazon.jsii.Kernel.get(this, "detectMd5Hash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventBasedHold = software.amazon.jsii.Kernel.get(this, "eventBasedHold", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyName = software.amazon.jsii.Kernel.get(this, "kmsKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectRetention.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.temporaryHold = software.amazon.jsii.Kernel.get(this, "temporaryHold", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.cacheControl = builder.cacheControl;
            this.content = builder.content;
            this.contentDisposition = builder.contentDisposition;
            this.contentEncoding = builder.contentEncoding;
            this.contentLanguage = builder.contentLanguage;
            this.contentType = builder.contentType;
            this.customerEncryption = builder.customerEncryption;
            this.detectMd5Hash = builder.detectMd5Hash;
            this.eventBasedHold = builder.eventBasedHold;
            this.id = builder.id;
            this.kmsKeyName = builder.kmsKeyName;
            this.metadata = builder.metadata;
            this.retention = builder.retention;
            this.source = builder.source;
            this.storageClass = builder.storageClass;
            this.temporaryHold = builder.temporaryHold;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final java.lang.String getContent() {
            return this.content;
        }

        @Override
        public final java.lang.String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final java.lang.String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final java.lang.String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectCustomerEncryption getCustomerEncryption() {
            return this.customerEncryption;
        }

        @Override
        public final java.lang.String getDetectMd5Hash() {
            return this.detectMd5Hash;
        }

        @Override
        public final java.lang.Object getEventBasedHold() {
            return this.eventBasedHold;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.String getKmsKeyName() {
            return this.kmsKeyName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectRetention getRetention() {
            return this.retention;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final java.lang.Object getTemporaryHold() {
            return this.temporaryHold;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.storage_bucket_object.StorageBucketObjectTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Object getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCacheControl() != null) {
                data.set("cacheControl", om.valueToTree(this.getCacheControl()));
            }
            if (this.getContent() != null) {
                data.set("content", om.valueToTree(this.getContent()));
            }
            if (this.getContentDisposition() != null) {
                data.set("contentDisposition", om.valueToTree(this.getContentDisposition()));
            }
            if (this.getContentEncoding() != null) {
                data.set("contentEncoding", om.valueToTree(this.getContentEncoding()));
            }
            if (this.getContentLanguage() != null) {
                data.set("contentLanguage", om.valueToTree(this.getContentLanguage()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getCustomerEncryption() != null) {
                data.set("customerEncryption", om.valueToTree(this.getCustomerEncryption()));
            }
            if (this.getDetectMd5Hash() != null) {
                data.set("detectMd5Hash", om.valueToTree(this.getDetectMd5Hash()));
            }
            if (this.getEventBasedHold() != null) {
                data.set("eventBasedHold", om.valueToTree(this.getEventBasedHold()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getKmsKeyName() != null) {
                data.set("kmsKeyName", om.valueToTree(this.getKmsKeyName()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getRetention() != null) {
                data.set("retention", om.valueToTree(this.getRetention()));
            }
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }
            if (this.getStorageClass() != null) {
                data.set("storageClass", om.valueToTree(this.getStorageClass()));
            }
            if (this.getTemporaryHold() != null) {
                data.set("temporaryHold", om.valueToTree(this.getTemporaryHold()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.storageBucketObject.StorageBucketObjectConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StorageBucketObjectConfig.Jsii$Proxy that = (StorageBucketObjectConfig.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (!name.equals(that.name)) return false;
            if (this.cacheControl != null ? !this.cacheControl.equals(that.cacheControl) : that.cacheControl != null) return false;
            if (this.content != null ? !this.content.equals(that.content) : that.content != null) return false;
            if (this.contentDisposition != null ? !this.contentDisposition.equals(that.contentDisposition) : that.contentDisposition != null) return false;
            if (this.contentEncoding != null ? !this.contentEncoding.equals(that.contentEncoding) : that.contentEncoding != null) return false;
            if (this.contentLanguage != null ? !this.contentLanguage.equals(that.contentLanguage) : that.contentLanguage != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.customerEncryption != null ? !this.customerEncryption.equals(that.customerEncryption) : that.customerEncryption != null) return false;
            if (this.detectMd5Hash != null ? !this.detectMd5Hash.equals(that.detectMd5Hash) : that.detectMd5Hash != null) return false;
            if (this.eventBasedHold != null ? !this.eventBasedHold.equals(that.eventBasedHold) : that.eventBasedHold != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.kmsKeyName != null ? !this.kmsKeyName.equals(that.kmsKeyName) : that.kmsKeyName != null) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            if (this.retention != null ? !this.retention.equals(that.retention) : that.retention != null) return false;
            if (this.source != null ? !this.source.equals(that.source) : that.source != null) return false;
            if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) return false;
            if (this.temporaryHold != null ? !this.temporaryHold.equals(that.temporaryHold) : that.temporaryHold != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.cacheControl != null ? this.cacheControl.hashCode() : 0);
            result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
            result = 31 * result + (this.contentDisposition != null ? this.contentDisposition.hashCode() : 0);
            result = 31 * result + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
            result = 31 * result + (this.contentLanguage != null ? this.contentLanguage.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.customerEncryption != null ? this.customerEncryption.hashCode() : 0);
            result = 31 * result + (this.detectMd5Hash != null ? this.detectMd5Hash.hashCode() : 0);
            result = 31 * result + (this.eventBasedHold != null ? this.eventBasedHold.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.kmsKeyName != null ? this.kmsKeyName.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            result = 31 * result + (this.storageClass != null ? this.storageClass.hashCode() : 0);
            result = 31 * result + (this.temporaryHold != null ? this.temporaryHold.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
