package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:04.487Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.BigqueryJobQuery")
@software.amazon.jsii.Jsii.Proxy(BigqueryJobQuery.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BigqueryJobQuery extends software.amazon.jsii.JsiiSerializable {

    /**
     * SQL query text to execute.
     * <p>
     * The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
     * NOTE*: queries containing <a href="https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language">DML language</a>
     * ('DELETE', 'UPDATE', 'MERGE', 'INSERT') must specify 'create_disposition = ""' and 'write_disposition = ""'.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#query BigqueryJob#query}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQuery();

    /**
     * If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
     * <p>
     * Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
     * However, you must still set destinationTable when result size exceeds the allowed maximum response size.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#allow_large_results BigqueryJob#allow_large_results}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowLargeResults() {
        return null;
    }

    /**
     * Specifies whether the job is allowed to create new tables.
     * <p>
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#create_disposition BigqueryJob#create_disposition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCreateDisposition() {
        return null;
    }

    /**
     * default_dataset block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#default_dataset BigqueryJob#default_dataset}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.BigqueryJobQueryDefaultDataset getDefaultDataset() {
        return null;
    }

    /**
     * destination_encryption_configuration block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationEncryptionConfiguration getDestinationEncryptionConfiguration() {
        return null;
    }

    /**
     * destination_table block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_table BigqueryJob#destination_table}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationTable getDestinationTable() {
        return null;
    }

    /**
     * If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
     * <p>
     * allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#flatten_results BigqueryJob#flatten_results}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFlattenResults() {
        return null;
    }

    /**
     * Limits the billing tier for this job.
     * <p>
     * Queries that have resource usage beyond this tier will fail (without incurring a charge).
     * If unspecified, this will be set to your project default.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#maximum_billing_tier BigqueryJob#maximum_billing_tier}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBillingTier() {
        return null;
    }

    /**
     * Limits the bytes billed for this job.
     * <p>
     * Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
     * If unspecified, this will be set to your project default.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#maximum_bytes_billed BigqueryJob#maximum_bytes_billed}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaximumBytesBilled() {
        return null;
    }

    /**
     * Standard SQL only.
     * <p>
     * Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (&#64;myparam) query parameters in this query.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#parameter_mode BigqueryJob#parameter_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getParameterMode() {
        return null;
    }

    /**
     * Specifies a priority for the query. Default value: "INTERACTIVE" Possible values: ["INTERACTIVE", "BATCH"].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#priority BigqueryJob#priority}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPriority() {
        return null;
    }

    /**
     * Allows the schema of the destination table to be updated as a side effect of the query job.
     * <p>
     * Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
     * when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
     * specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
     * One or more of the following values are specified:
     * ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
     * ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#schema_update_options BigqueryJob#schema_update_options}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSchemaUpdateOptions() {
        return null;
    }

    /**
     * script_options block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#script_options BigqueryJob#script_options}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.BigqueryJobQueryScriptOptions getScriptOptions() {
        return null;
    }

    /**
     * Specifies whether to use BigQuery's legacy SQL dialect for this query.
     * <p>
     * The default value is true.
     * If set to false, the query will use BigQuery's standard SQL.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_legacy_sql BigqueryJob#use_legacy_sql}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseLegacySql() {
        return null;
    }

    /**
     * Whether to look for the result in the query cache.
     * <p>
     * The query cache is a best-effort cache that will be flushed whenever
     * tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
     * The default value is true.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_query_cache BigqueryJob#use_query_cache}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseQueryCache() {
        return null;
    }

    /**
     * user_defined_function_resources block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#user_defined_function_resources BigqueryJob#user_defined_function_resources}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserDefinedFunctionResources() {
        return null;
    }

    /**
     * Specifies the action that occurs if the destination table already exists.
     * <p>
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#write_disposition BigqueryJob#write_disposition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWriteDisposition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BigqueryJobQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BigqueryJobQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BigqueryJobQuery> {
        java.lang.String query;
        java.lang.Object allowLargeResults;
        java.lang.String createDisposition;
        com.hashicorp.cdktf.providers.google.BigqueryJobQueryDefaultDataset defaultDataset;
        com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationEncryptionConfiguration destinationEncryptionConfiguration;
        com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationTable destinationTable;
        java.lang.Object flattenResults;
        java.lang.Number maximumBillingTier;
        java.lang.String maximumBytesBilled;
        java.lang.String parameterMode;
        java.lang.String priority;
        java.util.List<java.lang.String> schemaUpdateOptions;
        com.hashicorp.cdktf.providers.google.BigqueryJobQueryScriptOptions scriptOptions;
        java.lang.Object useLegacySql;
        java.lang.Object useQueryCache;
        java.lang.Object userDefinedFunctionResources;
        java.lang.String writeDisposition;

        /**
         * Sets the value of {@link BigqueryJobQuery#getQuery}
         * @param query SQL query text to execute. This parameter is required.
         *              The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
         *              NOTE*: queries containing <a href="https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language">DML language</a>
         *              ('DELETE', 'UPDATE', 'MERGE', 'INSERT') must specify 'create_disposition = ""' and 'write_disposition = ""'.
         *              <p>
         *              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#query BigqueryJob#query}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder query(java.lang.String query) {
            this.query = query;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getAllowLargeResults}
         * @param allowLargeResults If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
         *                          Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
         *                          However, you must still set destinationTable when result size exceeds the allowed maximum response size.
         *                          <p>
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#allow_large_results BigqueryJob#allow_large_results}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowLargeResults(java.lang.Boolean allowLargeResults) {
            this.allowLargeResults = allowLargeResults;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getAllowLargeResults}
         * @param allowLargeResults If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
         *                          Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
         *                          However, you must still set destinationTable when result size exceeds the allowed maximum response size.
         *                          <p>
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#allow_large_results BigqueryJob#allow_large_results}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowLargeResults(com.hashicorp.cdktf.IResolvable allowLargeResults) {
            this.allowLargeResults = allowLargeResults;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getCreateDisposition}
         * @param createDisposition Specifies whether the job is allowed to create new tables.
         *                          The following values are supported:
         *                          CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
         *                          CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
         *                          Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
         *                          <p>
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#create_disposition BigqueryJob#create_disposition}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createDisposition(java.lang.String createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getDefaultDataset}
         * @param defaultDataset default_dataset block.
         *                       Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#default_dataset BigqueryJob#default_dataset}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDataset(com.hashicorp.cdktf.providers.google.BigqueryJobQueryDefaultDataset defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getDestinationEncryptionConfiguration}
         * @param destinationEncryptionConfiguration destination_encryption_configuration block.
         *                                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationEncryptionConfiguration(com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationEncryptionConfiguration destinationEncryptionConfiguration) {
            this.destinationEncryptionConfiguration = destinationEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getDestinationTable}
         * @param destinationTable destination_table block.
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_table BigqueryJob#destination_table}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationTable(com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationTable destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getFlattenResults}
         * @param flattenResults If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
         *                       allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
         *                       <p>
         *                       Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#flatten_results BigqueryJob#flatten_results}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flattenResults(java.lang.Boolean flattenResults) {
            this.flattenResults = flattenResults;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getFlattenResults}
         * @param flattenResults If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
         *                       allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
         *                       <p>
         *                       Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#flatten_results BigqueryJob#flatten_results}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flattenResults(com.hashicorp.cdktf.IResolvable flattenResults) {
            this.flattenResults = flattenResults;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getMaximumBillingTier}
         * @param maximumBillingTier Limits the billing tier for this job.
         *                           Queries that have resource usage beyond this tier will fail (without incurring a charge).
         *                           If unspecified, this will be set to your project default.
         *                           <p>
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#maximum_billing_tier BigqueryJob#maximum_billing_tier}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumBillingTier(java.lang.Number maximumBillingTier) {
            this.maximumBillingTier = maximumBillingTier;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getMaximumBytesBilled}
         * @param maximumBytesBilled Limits the bytes billed for this job.
         *                           Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
         *                           If unspecified, this will be set to your project default.
         *                           <p>
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#maximum_bytes_billed BigqueryJob#maximum_bytes_billed}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumBytesBilled(java.lang.String maximumBytesBilled) {
            this.maximumBytesBilled = maximumBytesBilled;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getParameterMode}
         * @param parameterMode Standard SQL only.
         *                      Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (&#64;myparam) query parameters in this query.
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#parameter_mode BigqueryJob#parameter_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMode(java.lang.String parameterMode) {
            this.parameterMode = parameterMode;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getPriority}
         * @param priority Specifies a priority for the query. Default value: "INTERACTIVE" Possible values: ["INTERACTIVE", "BATCH"].
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#priority BigqueryJob#priority}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.String priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getSchemaUpdateOptions}
         * @param schemaUpdateOptions Allows the schema of the destination table to be updated as a side effect of the query job.
         *                            Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
         *                            when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
         *                            specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
         *                            One or more of the following values are specified:
         *                            ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
         *                            ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
         *                            <p>
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#schema_update_options BigqueryJob#schema_update_options}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaUpdateOptions(java.util.List<java.lang.String> schemaUpdateOptions) {
            this.schemaUpdateOptions = schemaUpdateOptions;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getScriptOptions}
         * @param scriptOptions script_options block.
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#script_options BigqueryJob#script_options}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scriptOptions(com.hashicorp.cdktf.providers.google.BigqueryJobQueryScriptOptions scriptOptions) {
            this.scriptOptions = scriptOptions;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getUseLegacySql}
         * @param useLegacySql Specifies whether to use BigQuery's legacy SQL dialect for this query.
         *                     The default value is true.
         *                     If set to false, the query will use BigQuery's standard SQL.
         *                     <p>
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_legacy_sql BigqueryJob#use_legacy_sql}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLegacySql(java.lang.Boolean useLegacySql) {
            this.useLegacySql = useLegacySql;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getUseLegacySql}
         * @param useLegacySql Specifies whether to use BigQuery's legacy SQL dialect for this query.
         *                     The default value is true.
         *                     If set to false, the query will use BigQuery's standard SQL.
         *                     <p>
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_legacy_sql BigqueryJob#use_legacy_sql}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLegacySql(com.hashicorp.cdktf.IResolvable useLegacySql) {
            this.useLegacySql = useLegacySql;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getUseQueryCache}
         * @param useQueryCache Whether to look for the result in the query cache.
         *                      The query cache is a best-effort cache that will be flushed whenever
         *                      tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
         *                      The default value is true.
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_query_cache BigqueryJob#use_query_cache}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useQueryCache(java.lang.Boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getUseQueryCache}
         * @param useQueryCache Whether to look for the result in the query cache.
         *                      The query cache is a best-effort cache that will be flushed whenever
         *                      tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
         *                      The default value is true.
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_query_cache BigqueryJob#use_query_cache}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useQueryCache(com.hashicorp.cdktf.IResolvable useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getUserDefinedFunctionResources}
         * @param userDefinedFunctionResources user_defined_function_resources block.
         *                                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#user_defined_function_resources BigqueryJob#user_defined_function_resources}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userDefinedFunctionResources(com.hashicorp.cdktf.IResolvable userDefinedFunctionResources) {
            this.userDefinedFunctionResources = userDefinedFunctionResources;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getUserDefinedFunctionResources}
         * @param userDefinedFunctionResources user_defined_function_resources block.
         *                                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#user_defined_function_resources BigqueryJob#user_defined_function_resources}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userDefinedFunctionResources(java.util.List<? extends com.hashicorp.cdktf.providers.google.BigqueryJobQueryUserDefinedFunctionResources> userDefinedFunctionResources) {
            this.userDefinedFunctionResources = userDefinedFunctionResources;
            return this;
        }

        /**
         * Sets the value of {@link BigqueryJobQuery#getWriteDisposition}
         * @param writeDisposition Specifies the action that occurs if the destination table already exists.
         *                         The following values are supported:
         *                         WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
         *                         WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
         *                         WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
         *                         Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
         *                         Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
         *                         <p>
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigquery_job#write_disposition BigqueryJob#write_disposition}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeDisposition(java.lang.String writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BigqueryJobQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BigqueryJobQuery build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BigqueryJobQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BigqueryJobQuery {
        private final java.lang.String query;
        private final java.lang.Object allowLargeResults;
        private final java.lang.String createDisposition;
        private final com.hashicorp.cdktf.providers.google.BigqueryJobQueryDefaultDataset defaultDataset;
        private final com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationEncryptionConfiguration destinationEncryptionConfiguration;
        private final com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationTable destinationTable;
        private final java.lang.Object flattenResults;
        private final java.lang.Number maximumBillingTier;
        private final java.lang.String maximumBytesBilled;
        private final java.lang.String parameterMode;
        private final java.lang.String priority;
        private final java.util.List<java.lang.String> schemaUpdateOptions;
        private final com.hashicorp.cdktf.providers.google.BigqueryJobQueryScriptOptions scriptOptions;
        private final java.lang.Object useLegacySql;
        private final java.lang.Object useQueryCache;
        private final java.lang.Object userDefinedFunctionResources;
        private final java.lang.String writeDisposition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.query = software.amazon.jsii.Kernel.get(this, "query", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowLargeResults = software.amazon.jsii.Kernel.get(this, "allowLargeResults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.createDisposition = software.amazon.jsii.Kernel.get(this, "createDisposition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultDataset = software.amazon.jsii.Kernel.get(this, "defaultDataset", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.BigqueryJobQueryDefaultDataset.class));
            this.destinationEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "destinationEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationEncryptionConfiguration.class));
            this.destinationTable = software.amazon.jsii.Kernel.get(this, "destinationTable", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationTable.class));
            this.flattenResults = software.amazon.jsii.Kernel.get(this, "flattenResults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maximumBillingTier = software.amazon.jsii.Kernel.get(this, "maximumBillingTier", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maximumBytesBilled = software.amazon.jsii.Kernel.get(this, "maximumBytesBilled", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameterMode = software.amazon.jsii.Kernel.get(this, "parameterMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schemaUpdateOptions = software.amazon.jsii.Kernel.get(this, "schemaUpdateOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.scriptOptions = software.amazon.jsii.Kernel.get(this, "scriptOptions", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.BigqueryJobQueryScriptOptions.class));
            this.useLegacySql = software.amazon.jsii.Kernel.get(this, "useLegacySql", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.useQueryCache = software.amazon.jsii.Kernel.get(this, "useQueryCache", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.userDefinedFunctionResources = software.amazon.jsii.Kernel.get(this, "userDefinedFunctionResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.writeDisposition = software.amazon.jsii.Kernel.get(this, "writeDisposition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.query = java.util.Objects.requireNonNull(builder.query, "query is required");
            this.allowLargeResults = builder.allowLargeResults;
            this.createDisposition = builder.createDisposition;
            this.defaultDataset = builder.defaultDataset;
            this.destinationEncryptionConfiguration = builder.destinationEncryptionConfiguration;
            this.destinationTable = builder.destinationTable;
            this.flattenResults = builder.flattenResults;
            this.maximumBillingTier = builder.maximumBillingTier;
            this.maximumBytesBilled = builder.maximumBytesBilled;
            this.parameterMode = builder.parameterMode;
            this.priority = builder.priority;
            this.schemaUpdateOptions = builder.schemaUpdateOptions;
            this.scriptOptions = builder.scriptOptions;
            this.useLegacySql = builder.useLegacySql;
            this.useQueryCache = builder.useQueryCache;
            this.userDefinedFunctionResources = builder.userDefinedFunctionResources;
            this.writeDisposition = builder.writeDisposition;
        }

        @Override
        public final java.lang.String getQuery() {
            return this.query;
        }

        @Override
        public final java.lang.Object getAllowLargeResults() {
            return this.allowLargeResults;
        }

        @Override
        public final java.lang.String getCreateDisposition() {
            return this.createDisposition;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.BigqueryJobQueryDefaultDataset getDefaultDataset() {
            return this.defaultDataset;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationEncryptionConfiguration getDestinationEncryptionConfiguration() {
            return this.destinationEncryptionConfiguration;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.BigqueryJobQueryDestinationTable getDestinationTable() {
            return this.destinationTable;
        }

        @Override
        public final java.lang.Object getFlattenResults() {
            return this.flattenResults;
        }

        @Override
        public final java.lang.Number getMaximumBillingTier() {
            return this.maximumBillingTier;
        }

        @Override
        public final java.lang.String getMaximumBytesBilled() {
            return this.maximumBytesBilled;
        }

        @Override
        public final java.lang.String getParameterMode() {
            return this.parameterMode;
        }

        @Override
        public final java.lang.String getPriority() {
            return this.priority;
        }

        @Override
        public final java.util.List<java.lang.String> getSchemaUpdateOptions() {
            return this.schemaUpdateOptions;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.BigqueryJobQueryScriptOptions getScriptOptions() {
            return this.scriptOptions;
        }

        @Override
        public final java.lang.Object getUseLegacySql() {
            return this.useLegacySql;
        }

        @Override
        public final java.lang.Object getUseQueryCache() {
            return this.useQueryCache;
        }

        @Override
        public final java.lang.Object getUserDefinedFunctionResources() {
            return this.userDefinedFunctionResources;
        }

        @Override
        public final java.lang.String getWriteDisposition() {
            return this.writeDisposition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("query", om.valueToTree(this.getQuery()));
            if (this.getAllowLargeResults() != null) {
                data.set("allowLargeResults", om.valueToTree(this.getAllowLargeResults()));
            }
            if (this.getCreateDisposition() != null) {
                data.set("createDisposition", om.valueToTree(this.getCreateDisposition()));
            }
            if (this.getDefaultDataset() != null) {
                data.set("defaultDataset", om.valueToTree(this.getDefaultDataset()));
            }
            if (this.getDestinationEncryptionConfiguration() != null) {
                data.set("destinationEncryptionConfiguration", om.valueToTree(this.getDestinationEncryptionConfiguration()));
            }
            if (this.getDestinationTable() != null) {
                data.set("destinationTable", om.valueToTree(this.getDestinationTable()));
            }
            if (this.getFlattenResults() != null) {
                data.set("flattenResults", om.valueToTree(this.getFlattenResults()));
            }
            if (this.getMaximumBillingTier() != null) {
                data.set("maximumBillingTier", om.valueToTree(this.getMaximumBillingTier()));
            }
            if (this.getMaximumBytesBilled() != null) {
                data.set("maximumBytesBilled", om.valueToTree(this.getMaximumBytesBilled()));
            }
            if (this.getParameterMode() != null) {
                data.set("parameterMode", om.valueToTree(this.getParameterMode()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getSchemaUpdateOptions() != null) {
                data.set("schemaUpdateOptions", om.valueToTree(this.getSchemaUpdateOptions()));
            }
            if (this.getScriptOptions() != null) {
                data.set("scriptOptions", om.valueToTree(this.getScriptOptions()));
            }
            if (this.getUseLegacySql() != null) {
                data.set("useLegacySql", om.valueToTree(this.getUseLegacySql()));
            }
            if (this.getUseQueryCache() != null) {
                data.set("useQueryCache", om.valueToTree(this.getUseQueryCache()));
            }
            if (this.getUserDefinedFunctionResources() != null) {
                data.set("userDefinedFunctionResources", om.valueToTree(this.getUserDefinedFunctionResources()));
            }
            if (this.getWriteDisposition() != null) {
                data.set("writeDisposition", om.valueToTree(this.getWriteDisposition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.BigqueryJobQuery"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BigqueryJobQuery.Jsii$Proxy that = (BigqueryJobQuery.Jsii$Proxy) o;

            if (!query.equals(that.query)) return false;
            if (this.allowLargeResults != null ? !this.allowLargeResults.equals(that.allowLargeResults) : that.allowLargeResults != null) return false;
            if (this.createDisposition != null ? !this.createDisposition.equals(that.createDisposition) : that.createDisposition != null) return false;
            if (this.defaultDataset != null ? !this.defaultDataset.equals(that.defaultDataset) : that.defaultDataset != null) return false;
            if (this.destinationEncryptionConfiguration != null ? !this.destinationEncryptionConfiguration.equals(that.destinationEncryptionConfiguration) : that.destinationEncryptionConfiguration != null) return false;
            if (this.destinationTable != null ? !this.destinationTable.equals(that.destinationTable) : that.destinationTable != null) return false;
            if (this.flattenResults != null ? !this.flattenResults.equals(that.flattenResults) : that.flattenResults != null) return false;
            if (this.maximumBillingTier != null ? !this.maximumBillingTier.equals(that.maximumBillingTier) : that.maximumBillingTier != null) return false;
            if (this.maximumBytesBilled != null ? !this.maximumBytesBilled.equals(that.maximumBytesBilled) : that.maximumBytesBilled != null) return false;
            if (this.parameterMode != null ? !this.parameterMode.equals(that.parameterMode) : that.parameterMode != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            if (this.schemaUpdateOptions != null ? !this.schemaUpdateOptions.equals(that.schemaUpdateOptions) : that.schemaUpdateOptions != null) return false;
            if (this.scriptOptions != null ? !this.scriptOptions.equals(that.scriptOptions) : that.scriptOptions != null) return false;
            if (this.useLegacySql != null ? !this.useLegacySql.equals(that.useLegacySql) : that.useLegacySql != null) return false;
            if (this.useQueryCache != null ? !this.useQueryCache.equals(that.useQueryCache) : that.useQueryCache != null) return false;
            if (this.userDefinedFunctionResources != null ? !this.userDefinedFunctionResources.equals(that.userDefinedFunctionResources) : that.userDefinedFunctionResources != null) return false;
            return this.writeDisposition != null ? this.writeDisposition.equals(that.writeDisposition) : that.writeDisposition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + (this.allowLargeResults != null ? this.allowLargeResults.hashCode() : 0);
            result = 31 * result + (this.createDisposition != null ? this.createDisposition.hashCode() : 0);
            result = 31 * result + (this.defaultDataset != null ? this.defaultDataset.hashCode() : 0);
            result = 31 * result + (this.destinationEncryptionConfiguration != null ? this.destinationEncryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.destinationTable != null ? this.destinationTable.hashCode() : 0);
            result = 31 * result + (this.flattenResults != null ? this.flattenResults.hashCode() : 0);
            result = 31 * result + (this.maximumBillingTier != null ? this.maximumBillingTier.hashCode() : 0);
            result = 31 * result + (this.maximumBytesBilled != null ? this.maximumBytesBilled.hashCode() : 0);
            result = 31 * result + (this.parameterMode != null ? this.parameterMode.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.schemaUpdateOptions != null ? this.schemaUpdateOptions.hashCode() : 0);
            result = 31 * result + (this.scriptOptions != null ? this.scriptOptions.hashCode() : 0);
            result = 31 * result + (this.useLegacySql != null ? this.useLegacySql.hashCode() : 0);
            result = 31 * result + (this.useQueryCache != null ? this.useQueryCache.hashCode() : 0);
            result = 31 * result + (this.userDefinedFunctionResources != null ? this.userDefinedFunctionResources.hashCode() : 0);
            result = 31 * result + (this.writeDisposition != null ? this.writeDisposition.hashCode() : 0);
            return result;
        }
    }
}
