package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:04.534Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.BigtableInstanceCluster")
@software.amazon.jsii.Jsii.Proxy(BigtableInstanceCluster.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BigtableInstanceCluster extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Cloud Bigtable cluster.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#cluster_id BigtableInstance#cluster_id}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterId();

    /**
     * autoscaling_config block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#autoscaling_config BigtableInstance#autoscaling_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.BigtableInstanceClusterAutoscalingConfig getAutoscalingConfig() {
        return null;
    }

    /**
     * Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster.
     * <p>
     * The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the cloudkms.cryptoKeyEncrypterDecrypter role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster. 3) All clusters within an instance must use the same CMEK key. Values are of the form projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#kms_key_name BigtableInstance#kms_key_name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyName() {
        return null;
    }

    /**
     * The number of nodes in your Cloud Bigtable cluster.
     * <p>
     * Required, with a minimum of 1 for a PRODUCTION instance. Must be left unset for a DEVELOPMENT instance.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#num_nodes BigtableInstance#num_nodes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumNodes() {
        return null;
    }

    /**
     * The storage type to use. One of "SSD" or "HDD". Defaults to "SSD".
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#storage_type BigtableInstance#storage_type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return null;
    }

    /**
     * The zone to create the Cloud Bigtable cluster in.
     * <p>
     * Each cluster must have a different zone in the same region. Zones that support Bigtable instances are noted on the Cloud Bigtable locations page.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#zone BigtableInstance#zone}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BigtableInstanceCluster}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BigtableInstanceCluster}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BigtableInstanceCluster> {
        java.lang.String clusterId;
        com.hashicorp.cdktf.providers.google.BigtableInstanceClusterAutoscalingConfig autoscalingConfig;
        java.lang.String kmsKeyName;
        java.lang.Number numNodes;
        java.lang.String storageType;
        java.lang.String zone;

        /**
         * Sets the value of {@link BigtableInstanceCluster#getClusterId}
         * @param clusterId The ID of the Cloud Bigtable cluster. This parameter is required.
         *                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#cluster_id BigtableInstance#cluster_id}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        /**
         * Sets the value of {@link BigtableInstanceCluster#getAutoscalingConfig}
         * @param autoscalingConfig autoscaling_config block.
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#autoscaling_config BigtableInstance#autoscaling_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoscalingConfig(com.hashicorp.cdktf.providers.google.BigtableInstanceClusterAutoscalingConfig autoscalingConfig) {
            this.autoscalingConfig = autoscalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link BigtableInstanceCluster#getKmsKeyName}
         * @param kmsKeyName Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster.
         *                   The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the cloudkms.cryptoKeyEncrypterDecrypter role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster. 3) All clusters within an instance must use the same CMEK key. Values are of the form projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}
         *                   <p>
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#kms_key_name BigtableInstance#kms_key_name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyName(java.lang.String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        /**
         * Sets the value of {@link BigtableInstanceCluster#getNumNodes}
         * @param numNodes The number of nodes in your Cloud Bigtable cluster.
         *                 Required, with a minimum of 1 for a PRODUCTION instance. Must be left unset for a DEVELOPMENT instance.
         *                 <p>
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#num_nodes BigtableInstance#num_nodes}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numNodes(java.lang.Number numNodes) {
            this.numNodes = numNodes;
            return this;
        }

        /**
         * Sets the value of {@link BigtableInstanceCluster#getStorageType}
         * @param storageType The storage type to use. One of "SSD" or "HDD". Defaults to "SSD".
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#storage_type BigtableInstance#storage_type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(java.lang.String storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link BigtableInstanceCluster#getZone}
         * @param zone The zone to create the Cloud Bigtable cluster in.
         *             Each cluster must have a different zone in the same region. Zones that support Bigtable instances are noted on the Cloud Bigtable locations page.
         *             <p>
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/bigtable_instance#zone BigtableInstance#zone}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(java.lang.String zone) {
            this.zone = zone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BigtableInstanceCluster}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BigtableInstanceCluster build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BigtableInstanceCluster}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BigtableInstanceCluster {
        private final java.lang.String clusterId;
        private final com.hashicorp.cdktf.providers.google.BigtableInstanceClusterAutoscalingConfig autoscalingConfig;
        private final java.lang.String kmsKeyName;
        private final java.lang.Number numNodes;
        private final java.lang.String storageType;
        private final java.lang.String zone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterId = software.amazon.jsii.Kernel.get(this, "clusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoscalingConfig = software.amazon.jsii.Kernel.get(this, "autoscalingConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.BigtableInstanceClusterAutoscalingConfig.class));
            this.kmsKeyName = software.amazon.jsii.Kernel.get(this, "kmsKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numNodes = software.amazon.jsii.Kernel.get(this, "numNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.zone = software.amazon.jsii.Kernel.get(this, "zone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterId = java.util.Objects.requireNonNull(builder.clusterId, "clusterId is required");
            this.autoscalingConfig = builder.autoscalingConfig;
            this.kmsKeyName = builder.kmsKeyName;
            this.numNodes = builder.numNodes;
            this.storageType = builder.storageType;
            this.zone = builder.zone;
        }

        @Override
        public final java.lang.String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.BigtableInstanceClusterAutoscalingConfig getAutoscalingConfig() {
            return this.autoscalingConfig;
        }

        @Override
        public final java.lang.String getKmsKeyName() {
            return this.kmsKeyName;
        }

        @Override
        public final java.lang.Number getNumNodes() {
            return this.numNodes;
        }

        @Override
        public final java.lang.String getStorageType() {
            return this.storageType;
        }

        @Override
        public final java.lang.String getZone() {
            return this.zone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterId", om.valueToTree(this.getClusterId()));
            if (this.getAutoscalingConfig() != null) {
                data.set("autoscalingConfig", om.valueToTree(this.getAutoscalingConfig()));
            }
            if (this.getKmsKeyName() != null) {
                data.set("kmsKeyName", om.valueToTree(this.getKmsKeyName()));
            }
            if (this.getNumNodes() != null) {
                data.set("numNodes", om.valueToTree(this.getNumNodes()));
            }
            if (this.getStorageType() != null) {
                data.set("storageType", om.valueToTree(this.getStorageType()));
            }
            if (this.getZone() != null) {
                data.set("zone", om.valueToTree(this.getZone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.BigtableInstanceCluster"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BigtableInstanceCluster.Jsii$Proxy that = (BigtableInstanceCluster.Jsii$Proxy) o;

            if (!clusterId.equals(that.clusterId)) return false;
            if (this.autoscalingConfig != null ? !this.autoscalingConfig.equals(that.autoscalingConfig) : that.autoscalingConfig != null) return false;
            if (this.kmsKeyName != null ? !this.kmsKeyName.equals(that.kmsKeyName) : that.kmsKeyName != null) return false;
            if (this.numNodes != null ? !this.numNodes.equals(that.numNodes) : that.numNodes != null) return false;
            if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
            return this.zone != null ? this.zone.equals(that.zone) : that.zone == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterId.hashCode();
            result = 31 * result + (this.autoscalingConfig != null ? this.autoscalingConfig.hashCode() : 0);
            result = 31 * result + (this.kmsKeyName != null ? this.kmsKeyName.hashCode() : 0);
            result = 31 * result + (this.numNodes != null ? this.numNodes.hashCode() : 0);
            result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
            result = 31 * result + (this.zone != null ? this.zone.hashCode() : 0);
            return result;
        }
    }
}
