package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:04.701Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.CloudTasksQueueRetryConfig")
@software.amazon.jsii.Jsii.Proxy(CloudTasksQueueRetryConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudTasksQueueRetryConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Number of attempts per task.
     * <p>
     * Cloud Tasks will attempt the task maxAttempts times (that is, if
     * the first attempt fails, then there will be maxAttempts - 1
     * retries). Must be &gt;= -1.
     * <p>
     * If unspecified when the queue is created, Cloud Tasks will pick
     * the default.
     * <p>
     * -1 indicates unlimited attempts.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_attempts CloudTasksQueue#max_attempts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAttempts() {
        return null;
    }

    /**
     * A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_backoff CloudTasksQueue#max_backoff}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxBackoff() {
        return null;
    }

    /**
     * The time between retries will double maxDoublings times.
     * <p>
     * A task's retry interval starts at minBackoff, then doubles maxDoublings times,
     * then increases linearly, and finally retries retries at intervals of maxBackoff
     * up to maxAttempts times.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_doublings CloudTasksQueue#max_doublings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDoublings() {
        return null;
    }

    /**
     * If positive, maxRetryDuration specifies the time limit for retrying a failed task, measured from when the task was first attempted.
     * <p>
     * Once maxRetryDuration time has passed and the task has
     * been attempted maxAttempts times, no further attempts will be
     * made and the task will be deleted.
     * <p>
     * If zero, then the task age is unlimited.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_retry_duration CloudTasksQueue#max_retry_duration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxRetryDuration() {
        return null;
    }

    /**
     * A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#min_backoff CloudTasksQueue#min_backoff}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMinBackoff() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudTasksQueueRetryConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudTasksQueueRetryConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudTasksQueueRetryConfig> {
        java.lang.Number maxAttempts;
        java.lang.String maxBackoff;
        java.lang.Number maxDoublings;
        java.lang.String maxRetryDuration;
        java.lang.String minBackoff;

        /**
         * Sets the value of {@link CloudTasksQueueRetryConfig#getMaxAttempts}
         * @param maxAttempts Number of attempts per task.
         *                    Cloud Tasks will attempt the task maxAttempts times (that is, if
         *                    the first attempt fails, then there will be maxAttempts - 1
         *                    retries). Must be &gt;= -1.
         *                    <p>
         *                    If unspecified when the queue is created, Cloud Tasks will pick
         *                    the default.
         *                    <p>
         *                    -1 indicates unlimited attempts.
         *                    <p>
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_attempts CloudTasksQueue#max_attempts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAttempts(java.lang.Number maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        /**
         * Sets the value of {@link CloudTasksQueueRetryConfig#getMaxBackoff}
         * @param maxBackoff A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_backoff CloudTasksQueue#max_backoff}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBackoff(java.lang.String maxBackoff) {
            this.maxBackoff = maxBackoff;
            return this;
        }

        /**
         * Sets the value of {@link CloudTasksQueueRetryConfig#getMaxDoublings}
         * @param maxDoublings The time between retries will double maxDoublings times.
         *                     A task's retry interval starts at minBackoff, then doubles maxDoublings times,
         *                     then increases linearly, and finally retries retries at intervals of maxBackoff
         *                     up to maxAttempts times.
         *                     <p>
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_doublings CloudTasksQueue#max_doublings}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxDoublings(java.lang.Number maxDoublings) {
            this.maxDoublings = maxDoublings;
            return this;
        }

        /**
         * Sets the value of {@link CloudTasksQueueRetryConfig#getMaxRetryDuration}
         * @param maxRetryDuration If positive, maxRetryDuration specifies the time limit for retrying a failed task, measured from when the task was first attempted.
         *                         Once maxRetryDuration time has passed and the task has
         *                         been attempted maxAttempts times, no further attempts will be
         *                         made and the task will be deleted.
         *                         <p>
         *                         If zero, then the task age is unlimited.
         *                         <p>
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_retry_duration CloudTasksQueue#max_retry_duration}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetryDuration(java.lang.String maxRetryDuration) {
            this.maxRetryDuration = maxRetryDuration;
            return this;
        }

        /**
         * Sets the value of {@link CloudTasksQueueRetryConfig#getMinBackoff}
         * @param minBackoff A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#min_backoff CloudTasksQueue#min_backoff}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minBackoff(java.lang.String minBackoff) {
            this.minBackoff = minBackoff;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudTasksQueueRetryConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudTasksQueueRetryConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudTasksQueueRetryConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudTasksQueueRetryConfig {
        private final java.lang.Number maxAttempts;
        private final java.lang.String maxBackoff;
        private final java.lang.Number maxDoublings;
        private final java.lang.String maxRetryDuration;
        private final java.lang.String minBackoff;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxAttempts = software.amazon.jsii.Kernel.get(this, "maxAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxBackoff = software.amazon.jsii.Kernel.get(this, "maxBackoff", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxDoublings = software.amazon.jsii.Kernel.get(this, "maxDoublings", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRetryDuration = software.amazon.jsii.Kernel.get(this, "maxRetryDuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.minBackoff = software.amazon.jsii.Kernel.get(this, "minBackoff", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxAttempts = builder.maxAttempts;
            this.maxBackoff = builder.maxBackoff;
            this.maxDoublings = builder.maxDoublings;
            this.maxRetryDuration = builder.maxRetryDuration;
            this.minBackoff = builder.minBackoff;
        }

        @Override
        public final java.lang.Number getMaxAttempts() {
            return this.maxAttempts;
        }

        @Override
        public final java.lang.String getMaxBackoff() {
            return this.maxBackoff;
        }

        @Override
        public final java.lang.Number getMaxDoublings() {
            return this.maxDoublings;
        }

        @Override
        public final java.lang.String getMaxRetryDuration() {
            return this.maxRetryDuration;
        }

        @Override
        public final java.lang.String getMinBackoff() {
            return this.minBackoff;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxAttempts() != null) {
                data.set("maxAttempts", om.valueToTree(this.getMaxAttempts()));
            }
            if (this.getMaxBackoff() != null) {
                data.set("maxBackoff", om.valueToTree(this.getMaxBackoff()));
            }
            if (this.getMaxDoublings() != null) {
                data.set("maxDoublings", om.valueToTree(this.getMaxDoublings()));
            }
            if (this.getMaxRetryDuration() != null) {
                data.set("maxRetryDuration", om.valueToTree(this.getMaxRetryDuration()));
            }
            if (this.getMinBackoff() != null) {
                data.set("minBackoff", om.valueToTree(this.getMinBackoff()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.CloudTasksQueueRetryConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudTasksQueueRetryConfig.Jsii$Proxy that = (CloudTasksQueueRetryConfig.Jsii$Proxy) o;

            if (this.maxAttempts != null ? !this.maxAttempts.equals(that.maxAttempts) : that.maxAttempts != null) return false;
            if (this.maxBackoff != null ? !this.maxBackoff.equals(that.maxBackoff) : that.maxBackoff != null) return false;
            if (this.maxDoublings != null ? !this.maxDoublings.equals(that.maxDoublings) : that.maxDoublings != null) return false;
            if (this.maxRetryDuration != null ? !this.maxRetryDuration.equals(that.maxRetryDuration) : that.maxRetryDuration != null) return false;
            return this.minBackoff != null ? this.minBackoff.equals(that.minBackoff) : that.minBackoff == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxAttempts != null ? this.maxAttempts.hashCode() : 0;
            result = 31 * result + (this.maxBackoff != null ? this.maxBackoff.hashCode() : 0);
            result = 31 * result + (this.maxDoublings != null ? this.maxDoublings.hashCode() : 0);
            result = 31 * result + (this.maxRetryDuration != null ? this.maxRetryDuration.hashCode() : 0);
            result = 31 * result + (this.minBackoff != null ? this.minBackoff.hashCode() : 0);
            return result;
        }
    }
}
