package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:05.048Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.ComputeInterconnectAttachmentConfig")
@software.amazon.jsii.Jsii.Proxy(ComputeInterconnectAttachmentConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeInterconnectAttachmentConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Name of the resource.
     * <p>
     * Provided by the client when the resource is created. The
     * name must be 1-63 characters long, and comply with RFC1035. Specifically, the
     * name must be 1-63 characters long and match the regular expression
     * '<a href="%5B-a-z0-9%5D*%5Ba-z0-9%5D">a-z</a>?' which means the first character must be a
     * lowercase letter, and all following characters must be a dash, lowercase
     * letter, or digit, except the last character, which cannot be a dash.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#name ComputeInterconnectAttachment#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * URL of the cloud router to be used for dynamic routing.
     * <p>
     * This router must be in
     * the same region as this InterconnectAttachment. The InterconnectAttachment will
     * automatically connect the Interconnect to the network &amp; region within which the
     * Cloud Router is configured.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#router ComputeInterconnectAttachment#router}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouter();

    /**
     * Whether the VLAN attachment is enabled or disabled.  When using PARTNER type this will Pre-Activate the interconnect attachment.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#admin_enabled ComputeInterconnectAttachment#admin_enabled}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdminEnabled() {
        return null;
    }

    /**
     * Provisioned bandwidth capacity for the interconnect attachment.
     * <p>
     * For attachments of type DEDICATED, the user can set the bandwidth.
     * For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
     * Defaults to BPS_10G Possible values: ["BPS_50M", "BPS_100M", "BPS_200M", "BPS_300M", "BPS_400M", "BPS_500M", "BPS_1G", "BPS_2G", "BPS_5G", "BPS_10G", "BPS_20G", "BPS_50G"]
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#bandwidth ComputeInterconnectAttachment#bandwidth}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBandwidth() {
        return null;
    }

    /**
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
     * <p>
     * All prefixes must be within link-local address space (169.254.0.0/16)
     * and must be /29 or shorter (/28, /27, etc). Google will attempt to select
     * an unused /29 from the supplied candidate prefix(es). The request will
     * fail if all possible /29s are in use on Google's edge. If not supplied,
     * Google will randomly select an unused /29 from all of link-local space.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#candidate_subnets ComputeInterconnectAttachment#candidate_subnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCandidateSubnets() {
        return null;
    }

    /**
     * An optional description of this resource.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#description ComputeInterconnectAttachment#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Desired availability domain for the attachment.
     * <p>
     * Only available for type
     * PARTNER, at creation time. For improved reliability, customers should
     * configure a pair of attachments with one per availability domain. The
     * selected availability domain will be provided to the Partner via the
     * pairing key so that the provisioned circuit will lie in the specified
     * domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#edge_availability_domain ComputeInterconnectAttachment#edge_availability_domain}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEdgeAvailabilityDomain() {
        return null;
    }

    /**
     * Indicates the user-supplied encryption option of this interconnect attachment:.
     * <p>
     * NONE is the default value, which means that the attachment carries
     * unencrypted traffic. VMs can send traffic to, or receive traffic
     * from, this type of attachment.
     * <p>
     * IPSEC indicates that the attachment carries only traffic encrypted by
     * an IPsec device such as an HA VPN gateway. VMs cannot directly send
     * traffic to, or receive traffic from, such an attachment. To use
     * IPsec-encrypted Cloud Interconnect create the attachment using this
     * option.
     * <p>
     * Not currently available publicly. Default value: "NONE" Possible values: ["NONE", "IPSEC"]
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#encryption ComputeInterconnectAttachment#encryption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEncryption() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#id ComputeInterconnectAttachment#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     * <p>
     * Required if type is DEDICATED, must not
     * be set if type is PARTNER.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#interconnect ComputeInterconnectAttachment#interconnect}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInterconnect() {
        return null;
    }

    /**
     * URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC.
     * <p>
     * The addresses must be RFC 1918 IP address ranges. When creating HA
     * VPN gateway over the interconnect attachment, if the attachment is
     * configured to use an RFC 1918 IP address, then the VPN gateway's IP
     * address will be allocated from the IP address range specified
     * here.
     * <p>
     * For example, if the HA VPN gateway's interface 0 is paired to this
     * interconnect attachment, then an RFC 1918 IP address for the VPN
     * gateway interface 0 will be allocated from the IP address specified
     * for this interconnect attachment.
     * <p>
     * If this field is not specified for interconnect attachment that has
     * encryption option as IPSEC, later on when creating HA VPN gateway on
     * this interconnect attachment, the HA VPN gateway's IP address will be
     * allocated from regional external IP address pool.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#ipsec_internal_addresses ComputeInterconnectAttachment#ipsec_internal_addresses}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpsecInternalAddresses() {
        return null;
    }

    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
     * <p>
     * Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#mtu ComputeInterconnectAttachment#mtu}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMtu() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#project ComputeInterconnectAttachment#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * Region where the regional interconnect attachment resides.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#region ComputeInterconnectAttachment#region}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#timeouts ComputeInterconnectAttachment#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.ComputeInterconnectAttachmentTimeouts getTimeouts() {
        return null;
    }

    /**
     * The type of InterconnectAttachment you wish to create. Defaults to DEDICATED. Possible values: ["DEDICATED", "PARTNER", "PARTNER_PROVIDER"].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#type ComputeInterconnectAttachment#type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When using PARTNER type this will be managed upstream.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#vlan_tag8021q ComputeInterconnectAttachment#vlan_tag8021q}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVlanTag8021Q() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeInterconnectAttachmentConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeInterconnectAttachmentConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeInterconnectAttachmentConfig> {
        java.lang.String name;
        java.lang.String router;
        java.lang.Object adminEnabled;
        java.lang.String bandwidth;
        java.util.List<java.lang.String> candidateSubnets;
        java.lang.String description;
        java.lang.String edgeAvailabilityDomain;
        java.lang.String encryption;
        java.lang.String id;
        java.lang.String interconnect;
        java.util.List<java.lang.String> ipsecInternalAddresses;
        java.lang.String mtu;
        java.lang.String project;
        java.lang.String region;
        com.hashicorp.cdktf.providers.google.ComputeInterconnectAttachmentTimeouts timeouts;
        java.lang.String type;
        java.lang.Number vlanTag8021Q;
        java.lang.Object connection;
        java.lang.Number count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getName}
         * @param name Name of the resource. This parameter is required.
         *             Provided by the client when the resource is created. The
         *             name must be 1-63 characters long, and comply with RFC1035. Specifically, the
         *             name must be 1-63 characters long and match the regular expression
         *             '<a href="%5B-a-z0-9%5D*%5Ba-z0-9%5D">a-z</a>?' which means the first character must be a
         *             lowercase letter, and all following characters must be a dash, lowercase
         *             letter, or digit, except the last character, which cannot be a dash.
         *             <p>
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#name ComputeInterconnectAttachment#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getRouter}
         * @param router URL of the cloud router to be used for dynamic routing. This parameter is required.
         *               This router must be in
         *               the same region as this InterconnectAttachment. The InterconnectAttachment will
         *               automatically connect the Interconnect to the network &amp; region within which the
         *               Cloud Router is configured.
         *               <p>
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#router ComputeInterconnectAttachment#router}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder router(java.lang.String router) {
            this.router = router;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getAdminEnabled}
         * @param adminEnabled Whether the VLAN attachment is enabled or disabled.  When using PARTNER type this will Pre-Activate the interconnect attachment.
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#admin_enabled ComputeInterconnectAttachment#admin_enabled}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminEnabled(java.lang.Boolean adminEnabled) {
            this.adminEnabled = adminEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getAdminEnabled}
         * @param adminEnabled Whether the VLAN attachment is enabled or disabled.  When using PARTNER type this will Pre-Activate the interconnect attachment.
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#admin_enabled ComputeInterconnectAttachment#admin_enabled}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminEnabled(com.hashicorp.cdktf.IResolvable adminEnabled) {
            this.adminEnabled = adminEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getBandwidth}
         * @param bandwidth Provisioned bandwidth capacity for the interconnect attachment.
         *                  For attachments of type DEDICATED, the user can set the bandwidth.
         *                  For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
         *                  Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
         *                  Defaults to BPS_10G Possible values: ["BPS_50M", "BPS_100M", "BPS_200M", "BPS_300M", "BPS_400M", "BPS_500M", "BPS_1G", "BPS_2G", "BPS_5G", "BPS_10G", "BPS_20G", "BPS_50G"]
         *                  <p>
         *                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#bandwidth ComputeInterconnectAttachment#bandwidth}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bandwidth(java.lang.String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getCandidateSubnets}
         * @param candidateSubnets Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
         *                         All prefixes must be within link-local address space (169.254.0.0/16)
         *                         and must be /29 or shorter (/28, /27, etc). Google will attempt to select
         *                         an unused /29 from the supplied candidate prefix(es). The request will
         *                         fail if all possible /29s are in use on Google's edge. If not supplied,
         *                         Google will randomly select an unused /29 from all of link-local space.
         *                         <p>
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#candidate_subnets ComputeInterconnectAttachment#candidate_subnets}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder candidateSubnets(java.util.List<java.lang.String> candidateSubnets) {
            this.candidateSubnets = candidateSubnets;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getDescription}
         * @param description An optional description of this resource.
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#description ComputeInterconnectAttachment#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getEdgeAvailabilityDomain}
         * @param edgeAvailabilityDomain Desired availability domain for the attachment.
         *                               Only available for type
         *                               PARTNER, at creation time. For improved reliability, customers should
         *                               configure a pair of attachments with one per availability domain. The
         *                               selected availability domain will be provided to the Partner via the
         *                               pairing key so that the provisioned circuit will lie in the specified
         *                               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
         *                               <p>
         *                               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#edge_availability_domain ComputeInterconnectAttachment#edge_availability_domain}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edgeAvailabilityDomain(java.lang.String edgeAvailabilityDomain) {
            this.edgeAvailabilityDomain = edgeAvailabilityDomain;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getEncryption}
         * @param encryption Indicates the user-supplied encryption option of this interconnect attachment:.
         *                   NONE is the default value, which means that the attachment carries
         *                   unencrypted traffic. VMs can send traffic to, or receive traffic
         *                   from, this type of attachment.
         *                   <p>
         *                   IPSEC indicates that the attachment carries only traffic encrypted by
         *                   an IPsec device such as an HA VPN gateway. VMs cannot directly send
         *                   traffic to, or receive traffic from, such an attachment. To use
         *                   IPsec-encrypted Cloud Interconnect create the attachment using this
         *                   option.
         *                   <p>
         *                   Not currently available publicly. Default value: "NONE" Possible values: ["NONE", "IPSEC"]
         *                   <p>
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#encryption ComputeInterconnectAttachment#encryption}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(java.lang.String encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#id ComputeInterconnectAttachment#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getInterconnect}
         * @param interconnect URL of the underlying Interconnect object that this attachment's traffic will traverse through.
         *                     Required if type is DEDICATED, must not
         *                     be set if type is PARTNER.
         *                     <p>
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#interconnect ComputeInterconnectAttachment#interconnect}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interconnect(java.lang.String interconnect) {
            this.interconnect = interconnect;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getIpsecInternalAddresses}
         * @param ipsecInternalAddresses URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC.
         *                               The addresses must be RFC 1918 IP address ranges. When creating HA
         *                               VPN gateway over the interconnect attachment, if the attachment is
         *                               configured to use an RFC 1918 IP address, then the VPN gateway's IP
         *                               address will be allocated from the IP address range specified
         *                               here.
         *                               <p>
         *                               For example, if the HA VPN gateway's interface 0 is paired to this
         *                               interconnect attachment, then an RFC 1918 IP address for the VPN
         *                               gateway interface 0 will be allocated from the IP address specified
         *                               for this interconnect attachment.
         *                               <p>
         *                               If this field is not specified for interconnect attachment that has
         *                               encryption option as IPSEC, later on when creating HA VPN gateway on
         *                               this interconnect attachment, the HA VPN gateway's IP address will be
         *                               allocated from regional external IP address pool.
         *                               <p>
         *                               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#ipsec_internal_addresses ComputeInterconnectAttachment#ipsec_internal_addresses}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipsecInternalAddresses(java.util.List<java.lang.String> ipsecInternalAddresses) {
            this.ipsecInternalAddresses = ipsecInternalAddresses;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getMtu}
         * @param mtu Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
         *            Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
         *            <p>
         *            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#mtu ComputeInterconnectAttachment#mtu}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mtu(java.lang.String mtu) {
            this.mtu = mtu;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#project ComputeInterconnectAttachment#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getRegion}
         * @param region Region where the regional interconnect attachment resides.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#region ComputeInterconnectAttachment#region}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#timeouts ComputeInterconnectAttachment#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.ComputeInterconnectAttachmentTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getType}
         * @param type The type of InterconnectAttachment you wish to create. Defaults to DEDICATED. Possible values: ["DEDICATED", "PARTNER", "PARTNER_PROVIDER"].
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#type ComputeInterconnectAttachment#type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getVlanTag8021Q}
         * @param vlanTag8021Q The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When using PARTNER type this will be managed upstream.
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#vlan_tag8021q ComputeInterconnectAttachment#vlan_tag8021q}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vlanTag8021Q(java.lang.Number vlanTag8021Q) {
            this.vlanTag8021Q = vlanTag8021Q;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link ComputeInterconnectAttachmentConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeInterconnectAttachmentConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeInterconnectAttachmentConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeInterconnectAttachmentConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeInterconnectAttachmentConfig {
        private final java.lang.String name;
        private final java.lang.String router;
        private final java.lang.Object adminEnabled;
        private final java.lang.String bandwidth;
        private final java.util.List<java.lang.String> candidateSubnets;
        private final java.lang.String description;
        private final java.lang.String edgeAvailabilityDomain;
        private final java.lang.String encryption;
        private final java.lang.String id;
        private final java.lang.String interconnect;
        private final java.util.List<java.lang.String> ipsecInternalAddresses;
        private final java.lang.String mtu;
        private final java.lang.String project;
        private final java.lang.String region;
        private final com.hashicorp.cdktf.providers.google.ComputeInterconnectAttachmentTimeouts timeouts;
        private final java.lang.String type;
        private final java.lang.Number vlanTag8021Q;
        private final java.lang.Object connection;
        private final java.lang.Number count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.router = software.amazon.jsii.Kernel.get(this, "router", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminEnabled = software.amazon.jsii.Kernel.get(this, "adminEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bandwidth = software.amazon.jsii.Kernel.get(this, "bandwidth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.candidateSubnets = software.amazon.jsii.Kernel.get(this, "candidateSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.edgeAvailabilityDomain = software.amazon.jsii.Kernel.get(this, "edgeAvailabilityDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.interconnect = software.amazon.jsii.Kernel.get(this, "interconnect", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipsecInternalAddresses = software.amazon.jsii.Kernel.get(this, "ipsecInternalAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.mtu = software.amazon.jsii.Kernel.get(this, "mtu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.ComputeInterconnectAttachmentTimeouts.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vlanTag8021Q = software.amazon.jsii.Kernel.get(this, "vlanTag8021Q", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.router = java.util.Objects.requireNonNull(builder.router, "router is required");
            this.adminEnabled = builder.adminEnabled;
            this.bandwidth = builder.bandwidth;
            this.candidateSubnets = builder.candidateSubnets;
            this.description = builder.description;
            this.edgeAvailabilityDomain = builder.edgeAvailabilityDomain;
            this.encryption = builder.encryption;
            this.id = builder.id;
            this.interconnect = builder.interconnect;
            this.ipsecInternalAddresses = builder.ipsecInternalAddresses;
            this.mtu = builder.mtu;
            this.project = builder.project;
            this.region = builder.region;
            this.timeouts = builder.timeouts;
            this.type = builder.type;
            this.vlanTag8021Q = builder.vlanTag8021Q;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRouter() {
            return this.router;
        }

        @Override
        public final java.lang.Object getAdminEnabled() {
            return this.adminEnabled;
        }

        @Override
        public final java.lang.String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final java.util.List<java.lang.String> getCandidateSubnets() {
            return this.candidateSubnets;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEdgeAvailabilityDomain() {
            return this.edgeAvailabilityDomain;
        }

        @Override
        public final java.lang.String getEncryption() {
            return this.encryption;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.String getInterconnect() {
            return this.interconnect;
        }

        @Override
        public final java.util.List<java.lang.String> getIpsecInternalAddresses() {
            return this.ipsecInternalAddresses;
        }

        @Override
        public final java.lang.String getMtu() {
            return this.mtu;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.ComputeInterconnectAttachmentTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Number getVlanTag8021Q() {
            return this.vlanTag8021Q;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Number getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("router", om.valueToTree(this.getRouter()));
            if (this.getAdminEnabled() != null) {
                data.set("adminEnabled", om.valueToTree(this.getAdminEnabled()));
            }
            if (this.getBandwidth() != null) {
                data.set("bandwidth", om.valueToTree(this.getBandwidth()));
            }
            if (this.getCandidateSubnets() != null) {
                data.set("candidateSubnets", om.valueToTree(this.getCandidateSubnets()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEdgeAvailabilityDomain() != null) {
                data.set("edgeAvailabilityDomain", om.valueToTree(this.getEdgeAvailabilityDomain()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getInterconnect() != null) {
                data.set("interconnect", om.valueToTree(this.getInterconnect()));
            }
            if (this.getIpsecInternalAddresses() != null) {
                data.set("ipsecInternalAddresses", om.valueToTree(this.getIpsecInternalAddresses()));
            }
            if (this.getMtu() != null) {
                data.set("mtu", om.valueToTree(this.getMtu()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getVlanTag8021Q() != null) {
                data.set("vlanTag8021Q", om.valueToTree(this.getVlanTag8021Q()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.ComputeInterconnectAttachmentConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeInterconnectAttachmentConfig.Jsii$Proxy that = (ComputeInterconnectAttachmentConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!router.equals(that.router)) return false;
            if (this.adminEnabled != null ? !this.adminEnabled.equals(that.adminEnabled) : that.adminEnabled != null) return false;
            if (this.bandwidth != null ? !this.bandwidth.equals(that.bandwidth) : that.bandwidth != null) return false;
            if (this.candidateSubnets != null ? !this.candidateSubnets.equals(that.candidateSubnets) : that.candidateSubnets != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.edgeAvailabilityDomain != null ? !this.edgeAvailabilityDomain.equals(that.edgeAvailabilityDomain) : that.edgeAvailabilityDomain != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.interconnect != null ? !this.interconnect.equals(that.interconnect) : that.interconnect != null) return false;
            if (this.ipsecInternalAddresses != null ? !this.ipsecInternalAddresses.equals(that.ipsecInternalAddresses) : that.ipsecInternalAddresses != null) return false;
            if (this.mtu != null ? !this.mtu.equals(that.mtu) : that.mtu != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            if (this.vlanTag8021Q != null ? !this.vlanTag8021Q.equals(that.vlanTag8021Q) : that.vlanTag8021Q != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.router.hashCode());
            result = 31 * result + (this.adminEnabled != null ? this.adminEnabled.hashCode() : 0);
            result = 31 * result + (this.bandwidth != null ? this.bandwidth.hashCode() : 0);
            result = 31 * result + (this.candidateSubnets != null ? this.candidateSubnets.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.edgeAvailabilityDomain != null ? this.edgeAvailabilityDomain.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.interconnect != null ? this.interconnect.hashCode() : 0);
            result = 31 * result + (this.ipsecInternalAddresses != null ? this.ipsecInternalAddresses.hashCode() : 0);
            result = 31 * result + (this.mtu != null ? this.mtu.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.vlanTag8021Q != null ? this.vlanTag8021Q.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
