package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:05.159Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.ComputeRegionInstanceGroupManagerUpdatePolicy")
@software.amazon.jsii.Jsii.Proxy(ComputeRegionInstanceGroupManagerUpdatePolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeRegionInstanceGroupManagerUpdatePolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * Minimal action to be taken on an instance.
     * <p>
     * You can specify either REFRESH to update without stopping instances, RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a REFRESH, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#minimal_action ComputeRegionInstanceGroupManager#minimal_action}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMinimalAction();

    /**
     * The type of update process.
     * <p>
     * You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#type ComputeRegionInstanceGroupManager#type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The instance redistribution policy for regional managed instance groups.
     * <p>
     * Valid values are: "PROACTIVE", "NONE". If PROACTIVE (default), the group attempts to maintain an even distribution of VM instances across zones in the region. If NONE, proactive redistribution is disabled.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#instance_redistribution_type ComputeRegionInstanceGroupManager#instance_redistribution_type}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceRedistributionType() {
        return null;
    }

    /**
     * The maximum number of instances that can be created above the specified targetSize during the update process.
     * <p>
     * Conflicts with max_surge_percent. It has to be either 0 or at least equal to the number of zones. If fixed values are used, at least one of max_unavailable_fixed or max_surge_fixed must be greater than 0.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#max_surge_fixed ComputeRegionInstanceGroupManager#max_surge_fixed}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSurgeFixed() {
        return null;
    }

    /**
     * The maximum number of instances(calculated as percentage) that can be created above the specified targetSize during the update process.
     * <p>
     * Conflicts with max_surge_fixed. Percent value is only allowed for regional managed instance groups with size at least 10.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#max_surge_percent ComputeRegionInstanceGroupManager#max_surge_percent}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSurgePercent() {
        return null;
    }

    /**
     * The maximum number of instances that can be unavailable during the update process.
     * <p>
     * Conflicts with max_unavailable_percent. It has to be either 0 or at least equal to the number of zones. If fixed values are used, at least one of max_unavailable_fixed or max_surge_fixed must be greater than 0.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#max_unavailable_fixed ComputeRegionInstanceGroupManager#max_unavailable_fixed}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxUnavailableFixed() {
        return null;
    }

    /**
     * The maximum number of instances(calculated as percentage) that can be unavailable during the update process.
     * <p>
     * Conflicts with max_unavailable_fixed. Percent value is only allowed for regional managed instance groups with size at least 10.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#max_unavailable_percent ComputeRegionInstanceGroupManager#max_unavailable_percent}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxUnavailablePercent() {
        return null;
    }

    /**
     * Most disruptive action that is allowed to be taken on an instance.
     * <p>
     * You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#most_disruptive_allowed_action ComputeRegionInstanceGroupManager#most_disruptive_allowed_action}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMostDisruptiveAllowedAction() {
        return null;
    }

    /**
     * The instance replacement method for regional managed instance groups.
     * <p>
     * Valid values are: "RECREATE", "SUBSTITUTE". If SUBSTITUTE (default), the group replaces VM instances with new instances that have randomly generated names. If RECREATE, instance names are preserved.  You must also set max_unavailable_fixed or max_unavailable_percent to be greater than 0.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#replacement_method ComputeRegionInstanceGroupManager#replacement_method}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplacementMethod() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeRegionInstanceGroupManagerUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeRegionInstanceGroupManagerUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeRegionInstanceGroupManagerUpdatePolicy> {
        java.lang.String minimalAction;
        java.lang.String type;
        java.lang.String instanceRedistributionType;
        java.lang.Number maxSurgeFixed;
        java.lang.Number maxSurgePercent;
        java.lang.Number maxUnavailableFixed;
        java.lang.Number maxUnavailablePercent;
        java.lang.String mostDisruptiveAllowedAction;
        java.lang.String replacementMethod;

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getMinimalAction}
         * @param minimalAction Minimal action to be taken on an instance. This parameter is required.
         *                      You can specify either REFRESH to update without stopping instances, RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a REFRESH, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#minimal_action ComputeRegionInstanceGroupManager#minimal_action}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimalAction(java.lang.String minimalAction) {
            this.minimalAction = minimalAction;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getType}
         * @param type The type of update process. This parameter is required.
         *             You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
         *             <p>
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#type ComputeRegionInstanceGroupManager#type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getInstanceRedistributionType}
         * @param instanceRedistributionType The instance redistribution policy for regional managed instance groups.
         *                                   Valid values are: "PROACTIVE", "NONE". If PROACTIVE (default), the group attempts to maintain an even distribution of VM instances across zones in the region. If NONE, proactive redistribution is disabled.
         *                                   <p>
         *                                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#instance_redistribution_type ComputeRegionInstanceGroupManager#instance_redistribution_type}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRedistributionType(java.lang.String instanceRedistributionType) {
            this.instanceRedistributionType = instanceRedistributionType;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getMaxSurgeFixed}
         * @param maxSurgeFixed The maximum number of instances that can be created above the specified targetSize during the update process.
         *                      Conflicts with max_surge_percent. It has to be either 0 or at least equal to the number of zones. If fixed values are used, at least one of max_unavailable_fixed or max_surge_fixed must be greater than 0.
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#max_surge_fixed ComputeRegionInstanceGroupManager#max_surge_fixed}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSurgeFixed(java.lang.Number maxSurgeFixed) {
            this.maxSurgeFixed = maxSurgeFixed;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getMaxSurgePercent}
         * @param maxSurgePercent The maximum number of instances(calculated as percentage) that can be created above the specified targetSize during the update process.
         *                        Conflicts with max_surge_fixed. Percent value is only allowed for regional managed instance groups with size at least 10.
         *                        <p>
         *                        Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#max_surge_percent ComputeRegionInstanceGroupManager#max_surge_percent}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSurgePercent(java.lang.Number maxSurgePercent) {
            this.maxSurgePercent = maxSurgePercent;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getMaxUnavailableFixed}
         * @param maxUnavailableFixed The maximum number of instances that can be unavailable during the update process.
         *                            Conflicts with max_unavailable_percent. It has to be either 0 or at least equal to the number of zones. If fixed values are used, at least one of max_unavailable_fixed or max_surge_fixed must be greater than 0.
         *                            <p>
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#max_unavailable_fixed ComputeRegionInstanceGroupManager#max_unavailable_fixed}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUnavailableFixed(java.lang.Number maxUnavailableFixed) {
            this.maxUnavailableFixed = maxUnavailableFixed;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getMaxUnavailablePercent}
         * @param maxUnavailablePercent The maximum number of instances(calculated as percentage) that can be unavailable during the update process.
         *                              Conflicts with max_unavailable_fixed. Percent value is only allowed for regional managed instance groups with size at least 10.
         *                              <p>
         *                              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#max_unavailable_percent ComputeRegionInstanceGroupManager#max_unavailable_percent}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUnavailablePercent(java.lang.Number maxUnavailablePercent) {
            this.maxUnavailablePercent = maxUnavailablePercent;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getMostDisruptiveAllowedAction}
         * @param mostDisruptiveAllowedAction Most disruptive action that is allowed to be taken on an instance.
         *                                    You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
         *                                    <p>
         *                                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#most_disruptive_allowed_action ComputeRegionInstanceGroupManager#most_disruptive_allowed_action}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mostDisruptiveAllowedAction(java.lang.String mostDisruptiveAllowedAction) {
            this.mostDisruptiveAllowedAction = mostDisruptiveAllowedAction;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRegionInstanceGroupManagerUpdatePolicy#getReplacementMethod}
         * @param replacementMethod The instance replacement method for regional managed instance groups.
         *                          Valid values are: "RECREATE", "SUBSTITUTE". If SUBSTITUTE (default), the group replaces VM instances with new instances that have randomly generated names. If RECREATE, instance names are preserved.  You must also set max_unavailable_fixed or max_unavailable_percent to be greater than 0.
         *                          <p>
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager#replacement_method ComputeRegionInstanceGroupManager#replacement_method}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replacementMethod(java.lang.String replacementMethod) {
            this.replacementMethod = replacementMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeRegionInstanceGroupManagerUpdatePolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeRegionInstanceGroupManagerUpdatePolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeRegionInstanceGroupManagerUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeRegionInstanceGroupManagerUpdatePolicy {
        private final java.lang.String minimalAction;
        private final java.lang.String type;
        private final java.lang.String instanceRedistributionType;
        private final java.lang.Number maxSurgeFixed;
        private final java.lang.Number maxSurgePercent;
        private final java.lang.Number maxUnavailableFixed;
        private final java.lang.Number maxUnavailablePercent;
        private final java.lang.String mostDisruptiveAllowedAction;
        private final java.lang.String replacementMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minimalAction = software.amazon.jsii.Kernel.get(this, "minimalAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceRedistributionType = software.amazon.jsii.Kernel.get(this, "instanceRedistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxSurgeFixed = software.amazon.jsii.Kernel.get(this, "maxSurgeFixed", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxSurgePercent = software.amazon.jsii.Kernel.get(this, "maxSurgePercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxUnavailableFixed = software.amazon.jsii.Kernel.get(this, "maxUnavailableFixed", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxUnavailablePercent = software.amazon.jsii.Kernel.get(this, "maxUnavailablePercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mostDisruptiveAllowedAction = software.amazon.jsii.Kernel.get(this, "mostDisruptiveAllowedAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replacementMethod = software.amazon.jsii.Kernel.get(this, "replacementMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minimalAction = java.util.Objects.requireNonNull(builder.minimalAction, "minimalAction is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.instanceRedistributionType = builder.instanceRedistributionType;
            this.maxSurgeFixed = builder.maxSurgeFixed;
            this.maxSurgePercent = builder.maxSurgePercent;
            this.maxUnavailableFixed = builder.maxUnavailableFixed;
            this.maxUnavailablePercent = builder.maxUnavailablePercent;
            this.mostDisruptiveAllowedAction = builder.mostDisruptiveAllowedAction;
            this.replacementMethod = builder.replacementMethod;
        }

        @Override
        public final java.lang.String getMinimalAction() {
            return this.minimalAction;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getInstanceRedistributionType() {
            return this.instanceRedistributionType;
        }

        @Override
        public final java.lang.Number getMaxSurgeFixed() {
            return this.maxSurgeFixed;
        }

        @Override
        public final java.lang.Number getMaxSurgePercent() {
            return this.maxSurgePercent;
        }

        @Override
        public final java.lang.Number getMaxUnavailableFixed() {
            return this.maxUnavailableFixed;
        }

        @Override
        public final java.lang.Number getMaxUnavailablePercent() {
            return this.maxUnavailablePercent;
        }

        @Override
        public final java.lang.String getMostDisruptiveAllowedAction() {
            return this.mostDisruptiveAllowedAction;
        }

        @Override
        public final java.lang.String getReplacementMethod() {
            return this.replacementMethod;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("minimalAction", om.valueToTree(this.getMinimalAction()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getInstanceRedistributionType() != null) {
                data.set("instanceRedistributionType", om.valueToTree(this.getInstanceRedistributionType()));
            }
            if (this.getMaxSurgeFixed() != null) {
                data.set("maxSurgeFixed", om.valueToTree(this.getMaxSurgeFixed()));
            }
            if (this.getMaxSurgePercent() != null) {
                data.set("maxSurgePercent", om.valueToTree(this.getMaxSurgePercent()));
            }
            if (this.getMaxUnavailableFixed() != null) {
                data.set("maxUnavailableFixed", om.valueToTree(this.getMaxUnavailableFixed()));
            }
            if (this.getMaxUnavailablePercent() != null) {
                data.set("maxUnavailablePercent", om.valueToTree(this.getMaxUnavailablePercent()));
            }
            if (this.getMostDisruptiveAllowedAction() != null) {
                data.set("mostDisruptiveAllowedAction", om.valueToTree(this.getMostDisruptiveAllowedAction()));
            }
            if (this.getReplacementMethod() != null) {
                data.set("replacementMethod", om.valueToTree(this.getReplacementMethod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.ComputeRegionInstanceGroupManagerUpdatePolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeRegionInstanceGroupManagerUpdatePolicy.Jsii$Proxy that = (ComputeRegionInstanceGroupManagerUpdatePolicy.Jsii$Proxy) o;

            if (!minimalAction.equals(that.minimalAction)) return false;
            if (!type.equals(that.type)) return false;
            if (this.instanceRedistributionType != null ? !this.instanceRedistributionType.equals(that.instanceRedistributionType) : that.instanceRedistributionType != null) return false;
            if (this.maxSurgeFixed != null ? !this.maxSurgeFixed.equals(that.maxSurgeFixed) : that.maxSurgeFixed != null) return false;
            if (this.maxSurgePercent != null ? !this.maxSurgePercent.equals(that.maxSurgePercent) : that.maxSurgePercent != null) return false;
            if (this.maxUnavailableFixed != null ? !this.maxUnavailableFixed.equals(that.maxUnavailableFixed) : that.maxUnavailableFixed != null) return false;
            if (this.maxUnavailablePercent != null ? !this.maxUnavailablePercent.equals(that.maxUnavailablePercent) : that.maxUnavailablePercent != null) return false;
            if (this.mostDisruptiveAllowedAction != null ? !this.mostDisruptiveAllowedAction.equals(that.mostDisruptiveAllowedAction) : that.mostDisruptiveAllowedAction != null) return false;
            return this.replacementMethod != null ? this.replacementMethod.equals(that.replacementMethod) : that.replacementMethod == null;
        }

        @Override
        public final int hashCode() {
            int result = this.minimalAction.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.instanceRedistributionType != null ? this.instanceRedistributionType.hashCode() : 0);
            result = 31 * result + (this.maxSurgeFixed != null ? this.maxSurgeFixed.hashCode() : 0);
            result = 31 * result + (this.maxSurgePercent != null ? this.maxSurgePercent.hashCode() : 0);
            result = 31 * result + (this.maxUnavailableFixed != null ? this.maxUnavailableFixed.hashCode() : 0);
            result = 31 * result + (this.maxUnavailablePercent != null ? this.maxUnavailablePercent.hashCode() : 0);
            result = 31 * result + (this.mostDisruptiveAllowedAction != null ? this.mostDisruptiveAllowedAction.hashCode() : 0);
            result = 31 * result + (this.replacementMethod != null ? this.replacementMethod.hashCode() : 0);
            return result;
        }
    }
}
