package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:05.237Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.ComputeRouterBgp")
@software.amazon.jsii.Jsii.Proxy(ComputeRouterBgp.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeRouterBgp extends software.amazon.jsii.JsiiSerializable {

    /**
     * Local BGP Autonomous System Number (ASN).
     * <p>
     * Must be an RFC6996
     * private ASN, either 16-bit or 32-bit. The value will be fixed for
     * this router resource. All VPN tunnels that link to this router
     * will have the same local ASN.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#asn ComputeRouter#asn}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getAsn();

    /**
     * User-specified list of prefix groups to advertise in custom mode.
     * <p>
     * This field can only be populated if advertiseMode is CUSTOM and
     * is advertised to all peers of the router. These groups will be
     * advertised in addition to any specified prefixes. Leave this field
     * blank to advertise no custom groups.
     * <p>
     * This enum field has the one valid value: ALL_SUBNETS
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#advertised_groups ComputeRouter#advertised_groups}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdvertisedGroups() {
        return null;
    }

    /**
     * advertised_ip_ranges block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#advertised_ip_ranges ComputeRouter#advertised_ip_ranges}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvertisedIpRanges() {
        return null;
    }

    /**
     * User-specified flag to indicate which mode to use for advertisement. Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#advertise_mode ComputeRouter#advertise_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdvertiseMode() {
        return null;
    }

    /**
     * The interval in seconds between BGP keepalive messages that are sent to the peer.
     * <p>
     * Hold time is three times the interval at which keepalive messages are sent, and the hold time is the
     * maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer.
     * BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for
     * the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#keepalive_interval ComputeRouter#keepalive_interval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getKeepaliveInterval() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeRouterBgp}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeRouterBgp}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeRouterBgp> {
        java.lang.Number asn;
        java.util.List<java.lang.String> advertisedGroups;
        java.lang.Object advertisedIpRanges;
        java.lang.String advertiseMode;
        java.lang.Number keepaliveInterval;

        /**
         * Sets the value of {@link ComputeRouterBgp#getAsn}
         * @param asn Local BGP Autonomous System Number (ASN). This parameter is required.
         *            Must be an RFC6996
         *            private ASN, either 16-bit or 32-bit. The value will be fixed for
         *            this router resource. All VPN tunnels that link to this router
         *            will have the same local ASN.
         *            <p>
         *            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#asn ComputeRouter#asn}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asn(java.lang.Number asn) {
            this.asn = asn;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterBgp#getAdvertisedGroups}
         * @param advertisedGroups User-specified list of prefix groups to advertise in custom mode.
         *                         This field can only be populated if advertiseMode is CUSTOM and
         *                         is advertised to all peers of the router. These groups will be
         *                         advertised in addition to any specified prefixes. Leave this field
         *                         blank to advertise no custom groups.
         *                         <p>
         *                         This enum field has the one valid value: ALL_SUBNETS
         *                         <p>
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#advertised_groups ComputeRouter#advertised_groups}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertisedGroups(java.util.List<java.lang.String> advertisedGroups) {
            this.advertisedGroups = advertisedGroups;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterBgp#getAdvertisedIpRanges}
         * @param advertisedIpRanges advertised_ip_ranges block.
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#advertised_ip_ranges ComputeRouter#advertised_ip_ranges}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertisedIpRanges(com.hashicorp.cdktf.IResolvable advertisedIpRanges) {
            this.advertisedIpRanges = advertisedIpRanges;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterBgp#getAdvertisedIpRanges}
         * @param advertisedIpRanges advertised_ip_ranges block.
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#advertised_ip_ranges ComputeRouter#advertised_ip_ranges}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertisedIpRanges(java.util.List<? extends com.hashicorp.cdktf.providers.google.ComputeRouterBgpAdvertisedIpRanges> advertisedIpRanges) {
            this.advertisedIpRanges = advertisedIpRanges;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterBgp#getAdvertiseMode}
         * @param advertiseMode User-specified flag to indicate which mode to use for advertisement. Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"].
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#advertise_mode ComputeRouter#advertise_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertiseMode(java.lang.String advertiseMode) {
            this.advertiseMode = advertiseMode;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterBgp#getKeepaliveInterval}
         * @param keepaliveInterval The interval in seconds between BGP keepalive messages that are sent to the peer.
         *                          Hold time is three times the interval at which keepalive messages are sent, and the hold time is the
         *                          maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer.
         *                          BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for
         *                          the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
         *                          <p>
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router#keepalive_interval ComputeRouter#keepalive_interval}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepaliveInterval(java.lang.Number keepaliveInterval) {
            this.keepaliveInterval = keepaliveInterval;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeRouterBgp}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeRouterBgp build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeRouterBgp}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeRouterBgp {
        private final java.lang.Number asn;
        private final java.util.List<java.lang.String> advertisedGroups;
        private final java.lang.Object advertisedIpRanges;
        private final java.lang.String advertiseMode;
        private final java.lang.Number keepaliveInterval;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.asn = software.amazon.jsii.Kernel.get(this, "asn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.advertisedGroups = software.amazon.jsii.Kernel.get(this, "advertisedGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.advertisedIpRanges = software.amazon.jsii.Kernel.get(this, "advertisedIpRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.advertiseMode = software.amazon.jsii.Kernel.get(this, "advertiseMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keepaliveInterval = software.amazon.jsii.Kernel.get(this, "keepaliveInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.asn = java.util.Objects.requireNonNull(builder.asn, "asn is required");
            this.advertisedGroups = builder.advertisedGroups;
            this.advertisedIpRanges = builder.advertisedIpRanges;
            this.advertiseMode = builder.advertiseMode;
            this.keepaliveInterval = builder.keepaliveInterval;
        }

        @Override
        public final java.lang.Number getAsn() {
            return this.asn;
        }

        @Override
        public final java.util.List<java.lang.String> getAdvertisedGroups() {
            return this.advertisedGroups;
        }

        @Override
        public final java.lang.Object getAdvertisedIpRanges() {
            return this.advertisedIpRanges;
        }

        @Override
        public final java.lang.String getAdvertiseMode() {
            return this.advertiseMode;
        }

        @Override
        public final java.lang.Number getKeepaliveInterval() {
            return this.keepaliveInterval;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("asn", om.valueToTree(this.getAsn()));
            if (this.getAdvertisedGroups() != null) {
                data.set("advertisedGroups", om.valueToTree(this.getAdvertisedGroups()));
            }
            if (this.getAdvertisedIpRanges() != null) {
                data.set("advertisedIpRanges", om.valueToTree(this.getAdvertisedIpRanges()));
            }
            if (this.getAdvertiseMode() != null) {
                data.set("advertiseMode", om.valueToTree(this.getAdvertiseMode()));
            }
            if (this.getKeepaliveInterval() != null) {
                data.set("keepaliveInterval", om.valueToTree(this.getKeepaliveInterval()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.ComputeRouterBgp"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeRouterBgp.Jsii$Proxy that = (ComputeRouterBgp.Jsii$Proxy) o;

            if (!asn.equals(that.asn)) return false;
            if (this.advertisedGroups != null ? !this.advertisedGroups.equals(that.advertisedGroups) : that.advertisedGroups != null) return false;
            if (this.advertisedIpRanges != null ? !this.advertisedIpRanges.equals(that.advertisedIpRanges) : that.advertisedIpRanges != null) return false;
            if (this.advertiseMode != null ? !this.advertiseMode.equals(that.advertiseMode) : that.advertiseMode != null) return false;
            return this.keepaliveInterval != null ? this.keepaliveInterval.equals(that.keepaliveInterval) : that.keepaliveInterval == null;
        }

        @Override
        public final int hashCode() {
            int result = this.asn.hashCode();
            result = 31 * result + (this.advertisedGroups != null ? this.advertisedGroups.hashCode() : 0);
            result = 31 * result + (this.advertisedIpRanges != null ? this.advertisedIpRanges.hashCode() : 0);
            result = 31 * result + (this.advertiseMode != null ? this.advertiseMode.hashCode() : 0);
            result = 31 * result + (this.keepaliveInterval != null ? this.keepaliveInterval.hashCode() : 0);
            return result;
        }
    }
}
